/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class JsonUtil {
    public static <T> T readJsonFromFile(String fileLocation, Class<T> type) throws FileNotFoundException {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        BufferedReader br = new BufferedReader(new FileReader(fileLocation));
        return (T)gson.fromJson((Reader)br, type);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T readJsonFromIFile(IFile json, Class<T> type) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        InputStreamReader isr = null;
        isr = new InputStreamReader(json.getContents());
        Object object = gson.fromJson((Reader)isr, type);
        if (isr == null) return (T)object;
        try {
            isr.close();
            return (T)object;
        }
        catch (IOException iOException) {}
        return (T)object;
        catch (CoreException e) {
            try {
                e.printStackTrace();
                if (isr == null) return null;
            }
            catch (Throwable throwable) {
                if (isr == null) throw throwable;
                try {
                    isr.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                isr.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public static void writeJsonToFile(String fileDestination, Object jsonJavaObject) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String json = gson.toJson(jsonJavaObject);
        FileWriter writer = new FileWriter(fileDestination);
        writer.write(json);
        writer.close();
    }

    public static void writeJsonToFile(File fileDestination, Object jsonJavaObject) throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String json = gson.toJson(jsonJavaObject);
        FileWriter writer = new FileWriter(fileDestination);
        writer.write(json);
        writer.close();
    }

    public static String convertJavaObjectToJson(Object jsonJavaObject) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return gson.toJson(jsonJavaObject);
    }

    public static <T> T convertJsonToJavaObject(String jsonString, Class<T> type) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return (T)gson.fromJson(jsonString, type);
    }
}

