/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;
import org.eclipse.jem.internal.proxy.initParser.IParserConstants;

public abstract class Expression
implements IParserConstants {
    protected Expression currentExpression;
    protected List fExpressionStack;
    protected ClassLoader fClassLoader;
    public int parenthesisLevel = 0;

    public static boolean compare(char[] from, char[] to) {
        return Arrays.equals(from, to);
    }

    public abstract Object evaluate() throws Exception;

    public abstract boolean isComplete();

    public abstract Class getTypeClass() throws Exception;

    public Class getEvaluationTypeClass(Expression exp) throws Exception {
        Class cls = exp.getTypeClass();
        if (cls == null) {
            throw new EvaluationException(new ClassNotFoundException(exp.getTypeClassName()));
        }
        return cls;
    }

    protected abstract String getTypeClassName();

    public boolean isNumber(char[] token) {
        int i;
        if (token.length == 0) {
            return false;
        }
        int parsePosition = 0;
        if (token[0] == '-') {
            parsePosition = 1;
        }
        if ((i = parsePosition) < token.length) {
            return Character.isDigit(token[i]);
        }
        return true;
    }

    public boolean isPop() {
        return false;
    }

    protected void popExpressionStack() {
        if (this.fExpressionStack != null && this.fExpressionStack.size() > 0) {
            this.currentExpression = (Expression)this.fExpressionStack.remove(this.fExpressionStack.size() - 1);
        }
    }

    protected void pushExpressionStack(Expression anExpression) {
        if (this.fExpressionStack == null) {
            this.fExpressionStack = new ArrayList(2);
        }
        this.fExpressionStack.add(this.currentExpression);
        this.currentExpression = anExpression;
    }

    void setClassLoader(ClassLoader aClassLoader) {
    }

    public abstract Expression push(char[] var1, char var2);

    public abstract boolean isPrimitive() throws Exception;

    public String toString(int depth, boolean aBreak) {
        StringBuffer buffer = new StringBuffer();
        if (aBreak) {
            buffer.append(System.getProperty("System.lineSeparator"));
        }
        int i = 0;
        while (i < depth) {
            buffer.append(" ");
            ++i;
        }
        buffer.append(this.toString());
        return buffer.toString();
    }
}

