/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.gulp.internal.launch.ui;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.js.common.build.system.BuildSystemVisitor;
import org.eclipse.wst.jsdt.js.common.build.system.launch.ui.GenericBuildSystemTab;
import org.eclipse.wst.jsdt.js.common.build.system.util.ASTUtil;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;
import org.eclipse.wst.jsdt.js.gulp.GulpPlugin;
import org.eclipse.wst.jsdt.js.gulp.internal.Messages;
import org.eclipse.wst.jsdt.js.gulp.internal.ui.ImageResource;
import org.eclipse.wst.jsdt.js.gulp.util.GulpVisitor;

public class GulpLaunchTab
extends GenericBuildSystemTab {
    public boolean isValid(ILaunchConfiguration launchConfig) {
        String task;
        File file;
        String buildFilePath;
        block5: {
            this.setErrorMessage(null);
            this.setWarningMessage(null);
            buildFilePath = this.buildFileText.getText();
            file = WorkbenchResourceUtil.getFile((String)buildFilePath);
            if (file == null) {
                this.setErrorMessage(Messages.GulpLaunchTab_ErrorNotExist);
                return false;
            }
            task = this.tasksCommbo.getText();
            if (!task.isEmpty()) break block5;
            return true;
        }
        try {
            IFile ifile = WorkbenchResourceUtil.getFileForLocation((String)file.getAbsolutePath());
            List<String> availTasks = Arrays.asList(this.getTaskNames(ASTUtil.getTasks((String)buildFilePath, (BuildSystemVisitor)new GulpVisitor(ifile))));
            if (!availTasks.contains(task)) {
                this.setWarningMessage(Messages.GulpLaunchTab_WarningTaskNotExist);
            }
        }
        catch (JavaScriptModelException e) {
            GulpPlugin.logError(e, e.getMessage());
        }
        return true;
    }

    public Image getImage() {
        return ImageResource.getImage("gulp_16.png");
    }

    public void initializeFrom(ILaunchConfiguration lc) {
        String buildFileLocation = "";
        try {
            buildFileLocation = lc.getAttribute("org.eclipse.wst.jsdt.js.gulp.BUILD_FILE", null);
            this.buildFileText.setText(buildFileLocation != null ? buildFileLocation : "");
            File file = WorkbenchResourceUtil.getFile((String)buildFileLocation);
            IFile ifile = null;
            if (file != null) {
                ifile = WorkbenchResourceUtil.getFileForLocation((String)file.getAbsolutePath());
            }
            Set tasks = ASTUtil.getTasks((String)buildFileLocation, (BuildSystemVisitor)new GulpVisitor(ifile));
            List<String> tasknames = Arrays.asList(this.getTaskNames(tasks));
            this.updateTasks(this.getTaskNames(tasks));
            String task = lc.getAttribute("org.eclipse.wst.jsdt.js.gulp.COMMAND", null);
            if (task != null && !task.isEmpty()) {
                this.tasksCommbo.setText(task);
            } else if (tasknames.contains("default")) {
                this.tasksCommbo.setText("default");
            } else {
                this.tasksCommbo.setText("");
            }
            String params = lc.getAttribute("org.eclipse.wst.jsdt.js.gulp.PARAMETERS", null);
            if (params != null) {
                this.parametersText.setText(params);
            } else {
                this.parametersText.setText("");
            }
        }
        catch (CoreException e) {
            GulpPlugin.logError(e, e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        IFile buildFile = this.getBuildFile();
        if (buildFile != null) {
            IProject project = buildFile.getProject();
            wc.setAttribute("org.eclipse.wst.jsdt.js.gulp.BUILD_FILE", buildFile.getLocation().toOSString());
            wc.setAttribute("org.eclipse.wst.jsdt.js.gulp.PROJECT", project.getName());
            wc.setAttribute("org.eclipse.wst.jsdt.js.gulp.DIR", buildFile.getParent().getLocation().toOSString());
            wc.setAttribute("org.eclipse.wst.jsdt.js.gulp.COMMAND", this.tasksCommbo.getText());
            wc.setAttribute("org.eclipse.wst.jsdt.js.gulp.PARAMETERS", this.parametersText.getText());
        }
    }

    protected String[] getTasksFromFile(IFile file) throws JavaScriptModelException {
        Set tasks = ASTUtil.getTasks((String)file.getLocation().toOSString(), (BuildSystemVisitor)new GulpVisitor(file));
        return this.getTaskNames(tasks);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
    }
}

