/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLogging;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

public class LoggingValueModelTests
extends EclipseLinkPersistenceUnitTestCase {
    private EclipseLinkLogging logging;
    private ModifiablePropertyValueModel<Boolean> timestampHolder;
    private PropertyChangeListener timestampListener;
    private PropertyChangeEvent timestampEvent;
    public static final Boolean TIMESTAMP_TEST_VALUE = Boolean.FALSE;

    public LoggingValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.logging = this.subject.getLogging();
        SimplePropertyValueModel loggingHolder = new SimplePropertyValueModel((Object)this.logging);
        this.timestampHolder = this.buildTimestampAA((PropertyValueModel<EclipseLinkLogging>)loggingHolder);
        this.timestampListener = this.buildTimestampChangeListener();
        this.timestampHolder.addPropertyChangeListener("value", this.timestampListener);
        this.timestampEvent = null;
    }

    public void testHasListeners() {
        AbstractModel subjectLogging = (AbstractModel)this.logging;
        PropertyAspectAdapter timestampAA = (PropertyAspectAdapter)this.timestampHolder;
        LoggingValueModelTests.assertTrue((boolean)timestampAA.hasAnyPropertyChangeListeners("value"));
        LoggingValueModelTests.assertTrue((boolean)subjectLogging.hasAnyPropertyChangeListeners("timestamp"));
        timestampAA.removePropertyChangeListener("value", this.timestampListener);
        LoggingValueModelTests.assertFalse((boolean)subjectLogging.hasAnyPropertyChangeListeners("timestamp"));
        LoggingValueModelTests.assertFalse((boolean)timestampAA.hasAnyPropertyChangeListeners("value"));
    }

    protected void populatePu() {
        this.persistenceUnitSetProperty("eclipselink.logging.timestamp", TIMESTAMP_TEST_VALUE);
    }

    protected PersistenceUnitProperties getModel() {
        return this.logging;
    }

    private ModifiablePropertyValueModel<Boolean> buildTimestampAA(PropertyValueModel<EclipseLinkLogging> subjectHolder) {
        return new PropertyAspectAdapter<EclipseLinkLogging, Boolean>(subjectHolder, new String[]{"timestamp"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkLogging)this.subject).getTimestamp();
            }

            protected void setValue_(Boolean enumValue) {
                ((EclipseLinkLogging)this.subject).setTimestamp(enumValue);
            }
        };
    }

    private PropertyChangeListener buildTimestampChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                LoggingValueModelTests.this.timestampEvent = e;
            }
        };
    }

    public void testValue() {
        this.verifyTimestampAAValue(TIMESTAMP_TEST_VALUE);
        LoggingValueModelTests.assertEquals((Object)EclipseLinkLogging.DEFAULT_TIMESTAMP, (Object)this.logging.getDefaultTimestamp());
    }

    public void testSetValue() throws Exception {
        this.timestampEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.timestampHolder, "value");
        Boolean newTimestamp = TIMESTAMP_TEST_VALUE == false;
        this.timestampHolder.setValue((Object)newTimestamp);
        this.verifyTimestampAAValue(newTimestamp);
        LoggingValueModelTests.assertNotNull((Object)this.timestampEvent);
    }

    public void testSetNullValue() {
        String notDeleted = "Property not deleted";
        this.timestampEvent = null;
        this.timestampHolder.setValue(null);
        this.verifyTimestampAAValue(null);
        LoggingValueModelTests.assertNotNull((Object)this.timestampEvent);
        this.verifyPuHasNotProperty("eclipselink.logging.timestamp", notDeleted);
    }

    protected void verifyTimestampAAValue(Boolean testValue) {
        this.verifyAAValue(testValue, this.logging.getTimestamp(), (PropertyValueModel)this.timestampHolder, "eclipselink.logging.timestamp");
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

