/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.jpa.core.context.orm.OrmAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmAssociationOverrideTests
extends ContextModelTestCase {
    public OrmAssociationOverrideTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        OrmSpecifiedAssociationOverride ormAssociationOverride = (OrmSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        OrmAssociationOverrideTests.assertNull((Object)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertNull((Object)xmlAssociationOverride.getName());
        OrmAssociationOverrideTests.assertTrue((boolean)overrideContainer.getOverrides().iterator().hasNext());
        OrmAssociationOverrideTests.assertFalse((boolean)entityResource.getAssociationOverrides().isEmpty());
        xmlAssociationOverride.setName("FOO");
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)xmlAssociationOverride.getName());
        xmlAssociationOverride.setName(null);
        OrmAssociationOverrideTests.assertNull((Object)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertNull((Object)xmlAssociationOverride.getName());
        xmlAssociationOverride.setName("FOO");
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)xmlAssociationOverride.getName());
        entityResource.getAssociationOverrides().remove(0);
        OrmAssociationOverrideTests.assertFalse((boolean)overrideContainer.getOverrides().iterator().hasNext());
        OrmAssociationOverrideTests.assertTrue((boolean)entityResource.getAssociationOverrides().isEmpty());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        OrmSpecifiedAssociationOverride ormAssociationOverride = (OrmSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        OrmAssociationOverrideTests.assertNull((Object)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertNull((Object)xmlAssociationOverride.getName());
        ormAssociationOverride.setName("foo");
        OrmAssociationOverrideTests.assertEquals((String)"foo", (String)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertEquals((String)"foo", (String)xmlAssociationOverride.getName());
        ormAssociationOverride.setName(null);
        OrmAssociationOverrideTests.assertNull((Object)ormAssociationOverride.getName());
        OrmAssociationOverrideTests.assertNull((Object)((XmlAssociationOverride)entityResource.getAssociationOverrides().get(0)).getName());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        OrmSpecifiedAssociationOverride ormAssociationOverride = (OrmSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        OrmSpecifiedJoinColumnRelationshipStrategy joiningStrategy = ormAssociationOverride.getRelationship().getJoinColumnStrategy();
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        OrmSpecifiedJoinColumn joinColumn = joiningStrategy.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmSpecifiedJoinColumn joinColumn2 = joiningStrategy.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        OrmSpecifiedJoinColumn joinColumn3 = joiningStrategy.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).getName());
        ListIterator joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        OrmAssociationOverrideTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmAssociationOverrideTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmAssociationOverrideTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        OrmSpecifiedAssociationOverride ormAssociationOverride = (OrmSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        OrmSpecifiedJoinColumnRelationshipStrategy joiningStrategy = ormAssociationOverride.getRelationship().getJoinColumnStrategy();
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        joiningStrategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joiningStrategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joiningStrategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmAssociationOverrideTests.assertEquals((int)3, (int)xmlAssociationOverride.getJoinColumns().size());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        OrmAssociationOverrideTests.assertEquals((int)2, (int)xmlAssociationOverride.getJoinColumns().size());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        OrmAssociationOverrideTests.assertEquals((int)1, (int)xmlAssociationOverride.getJoinColumns().size());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        OrmAssociationOverrideTests.assertEquals((int)0, (int)xmlAssociationOverride.getJoinColumns().size());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        OrmSpecifiedAssociationOverride ormAssociationOverride = (OrmSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        OrmSpecifiedJoinColumnRelationshipStrategy joiningStrategy = ormAssociationOverride.getRelationship().getJoinColumnStrategy();
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        joiningStrategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joiningStrategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joiningStrategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmAssociationOverrideTests.assertEquals((int)3, (int)xmlAssociationOverride.getJoinColumns().size());
        joiningStrategy.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).getName());
        joiningStrategy.moveSpecifiedJoinColumn(0, 1);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmAssociationOverrideContainer overrideContainer = ormEntity.getAssociationOverrideContainer();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getAssociationOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAssociationOverride());
        OrmSpecifiedAssociationOverride ormAssociationOverride = (OrmSpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        OrmSpecifiedJoinColumnRelationshipStrategy joiningStrategy = ormAssociationOverride.getRelationship().getJoinColumnStrategy();
        XmlAssociationOverride xmlAssociationOverride = (XmlAssociationOverride)entityResource.getAssociationOverrides().get(0);
        xmlAssociationOverride.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        xmlAssociationOverride.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        xmlAssociationOverride.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        ((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)xmlAssociationOverride.getJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().move(2, 0);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().move(0, 1);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().remove(1);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().remove(1);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        OrmAssociationOverrideTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        xmlAssociationOverride.getJoinColumns().remove(0);
        OrmAssociationOverrideTests.assertFalse((boolean)joiningStrategy.getSpecifiedJoinColumns().iterator().hasNext());
    }
}

