/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.tests.viewer;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.dtd.core.internal.provisional.contenttype.ContentTypeIdForDTD;
import org.eclipse.wst.dtd.ui.StructuredTextViewerConfigurationDTD;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.w3c.dom.Attr;

public class ViewerTestDTD
extends ViewPart {
    private final String DEFAULT_VIEWER_CONTENTS = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<HTML>\n\t<HEAD>\n\t\t<META http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">\n\t\t<TITLE>place title here</TITLE>\n\t</HEAD>\n\t<BODY>\n\t\tplace content here\t\n<script>\n\"text\";\n</SCRIPT>\n</BODY>\n</HTML>";
    private StructuredTextViewerConfiguration fConfig = null;
    private IContentOutlinePage fContentOutlinePage = null;
    private ISelectionChangedListener fHighlightRangeListener = null;
    private StructuredTextViewer fSourceViewer = null;
    private final String SSE_EDITOR_FONT = "org.eclipse.wst.sse.ui.textfont";

    protected void addActions(IContributionManager mgr) {
        if (mgr != null) {
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "New HTML";
                }

                public void run() {
                    super.run();
                    BusyIndicator.showWhile((Display)ViewerTestDTD.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            ViewerTestDTD.this.setupViewerForNew();
                            ViewerTestDTD.this.fSourceViewer.setEditable(true);
                        }
                    });
                }
            });
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Change Visibility";
                }

                public void run() {
                    super.run();
                    NumberInputDialog dlg = new NumberInputDialog(ViewerTestDTD.this.fSourceViewer.getControl().getShell());
                    int proceed = dlg.open();
                    if (proceed == 1) {
                        return;
                    }
                    ViewerTestDTD.this.fSourceViewer.resetVisibleRegion();
                    ViewerTestDTD.this.fSourceViewer.setVisibleRegion(dlg.startValue, dlg.lengthValue);
                }
            });
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Show All";
                }

                public void run() {
                    super.run();
                    ViewerTestDTD.this.fSourceViewer.resetVisibleRegion();
                }
            });
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Change Visibility in Editor";
                }

                public void run() {
                    super.run();
                    StructuredTextViewer sourceViewer = null;
                    IEditorPart part = ViewerTestDTD.this.getViewSite().getWorkbenchWindow().getActivePage().getActiveEditor();
                    if (part != null && part instanceof StructuredTextEditor) {
                        sourceViewer = ((StructuredTextEditor)part).getTextViewer();
                    }
                    if (sourceViewer != null) {
                        NumberInputDialog dlg = new NumberInputDialog(sourceViewer.getControl().getShell());
                        int proceed = dlg.open();
                        if (proceed == 1) {
                            return;
                        }
                        sourceViewer.resetVisibleRegion();
                        sourceViewer.setVisibleRegion(dlg.startValue, dlg.lengthValue);
                    }
                }
            });
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Show All in Editor";
                }

                public void run() {
                    super.run();
                    StructuredTextViewer sourceViewer = null;
                    IEditorPart part = ViewerTestDTD.this.getViewSite().getWorkbenchWindow().getActivePage().getActiveEditor();
                    if (part != null && part instanceof StructuredTextEditor) {
                        sourceViewer = ((StructuredTextEditor)part).getTextViewer();
                    }
                    if (sourceViewer != null) {
                        sourceViewer.resetVisibleRegion();
                    }
                }
            });
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Take Input from Active Editor";
                }

                public void run() {
                    super.run();
                    ITextEditor textEditor = ViewerTestDTD.this.getActiveEditor();
                    if (textEditor != null) {
                        ViewerTestDTD.this.setupViewerForEditor(textEditor);
                        ViewerTestDTD.this.fSourceViewer.setEditable(true);
                    }
                }
            });
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Take Input and Follow Selection";
                }

                public void run() {
                    super.run();
                    ViewerTestDTD.this.followSelection();
                    ViewerTestDTD.this.fSourceViewer.setEditable(true);
                }
            });
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Take Input and Follow Selection As ReadOnly";
                }

                public void run() {
                    super.run();
                    ViewerTestDTD.this.followSelection();
                    ViewerTestDTD.this.fSourceViewer.setEditable(false);
                }
            });
            mgr.add((IAction)new Action(){

                public String getText() {
                    return this.getToolTipText();
                }

                public String getToolTipText() {
                    return "Stop Following Selection";
                }

                public void run() {
                    super.run();
                    ViewerTestDTD.this.stopFollowSelection();
                }
            });
        }
    }

    public void createPartControl(Composite parent) {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        this.addActions((IContributionManager)mgr);
        this.fSourceViewer = new StructuredTextViewer(parent, null, null, false, 0);
        this.fConfig = new StructuredTextViewerConfigurationDTD();
        this.setupViewerForNew();
        this.setupViewerPreferences();
    }

    public void dispose() {
        this.stopFollowSelection();
        this.fSourceViewer.unconfigure();
    }

    private void followSelection() {
        ITextEditor editor = this.getActiveEditor();
        if (editor != null) {
            this.setupViewerForEditor(editor);
            if (this.fHighlightRangeListener == null) {
                this.fHighlightRangeListener = new NodeRangeSelectionListener();
            }
            this.fContentOutlinePage = (IContentOutlinePage)editor.getAdapter(IContentOutlinePage.class);
            if (this.fContentOutlinePage != null) {
                this.fContentOutlinePage.addSelectionChangedListener(this.fHighlightRangeListener);
                if (!this.fContentOutlinePage.getSelection().isEmpty() && this.fContentOutlinePage.getSelection() instanceof IStructuredSelection) {
                    this.fSourceViewer.resetVisibleRegion();
                    Object[] nodes = ((IStructuredSelection)this.fContentOutlinePage.getSelection()).toArray();
                    IndexedRegion startNode = (IndexedRegion)nodes[0];
                    IndexedRegion endNode = (IndexedRegion)nodes[nodes.length - 1];
                    int start = startNode.getStartOffset();
                    int end = endNode.getEndOffset();
                    this.fSourceViewer.setVisibleRegion(start, end - start);
                    this.fSourceViewer.setSelectedRange(start, 0);
                }
            }
        }
    }

    private ITextEditor getActiveEditor() {
        ITextEditor editor = null;
        IEditorPart editorPart = this.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart instanceof ITextEditor) {
            editor = (ITextEditor)editorPart;
        }
        if (editor == null && editorPart != null) {
            editor = (ITextEditor)editorPart.getAdapter(ITextEditor.class);
        }
        return editor;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void setFocus() {
        if (this.fSourceViewer.getControl() != null && !this.fSourceViewer.getControl().isDisposed()) {
            this.fSourceViewer.getControl().setFocus();
        }
    }

    private void setupViewerForEditor(ITextEditor editor) {
        this.stopFollowSelection();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        this.fSourceViewer.setDocument(doc);
        this.fSourceViewer.configure((SourceViewerConfiguration)new StructuredTextViewerConfigurationDTD());
    }

    private void setupViewerForNew() {
        this.stopFollowSelection();
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredDocument doc = modelManager.createStructuredDocumentFor(ContentTypeIdForDTD.ContentTypeID_DTD);
        doc.set("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n<HTML>\n\t<HEAD>\n\t\t<META http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">\n\t\t<TITLE>place title here</TITLE>\n\t</HEAD>\n\t<BODY>\n\t\tplace content here\t\n<script>\n\"text\";\n</SCRIPT>\n</BODY>\n</HTML>");
        this.fSourceViewer.setDocument((IDocument)doc);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fConfig);
    }

    private void setupViewerPreferences() {
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
    }

    private void stopFollowSelection() {
        if (this.fContentOutlinePage != null) {
            this.fContentOutlinePage.removeSelectionChangedListener(this.fHighlightRangeListener);
            this.fSourceViewer.resetVisibleRegion();
            this.fContentOutlinePage = null;
        }
    }

    protected class NodeRangeSelectionListener
    implements ISelectionChangedListener {
        protected NodeRangeSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IndexedRegion startNode = (IndexedRegion)selection.getFirstElement();
                IndexedRegion endNode = (IndexedRegion)selection.toArray()[selection.size() - 1];
                if (startNode instanceof Attr) {
                    startNode = (IndexedRegion)((Attr)startNode).getOwnerElement();
                }
                if (endNode instanceof Attr) {
                    endNode = (IndexedRegion)((Attr)endNode).getOwnerElement();
                }
                int start = startNode.getStartOffset();
                int end = endNode.getEndOffset();
                ViewerTestDTD.this.fSourceViewer.resetVisibleRegion();
                ViewerTestDTD.this.fSourceViewer.setVisibleRegion(start, end - start);
                ViewerTestDTD.this.fSourceViewer.setSelectedRange(start, 0);
            } else {
                ViewerTestDTD.this.fSourceViewer.resetVisibleRegion();
            }
        }
    }

    protected class NumberInputDialog
    extends Dialog {
        public Text length;
        int lengthValue;
        public Text start;
        int startValue;

        public NumberInputDialog(Shell shell) {
            super(shell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(composite, 0);
            container.setLayoutData((Object)new GridData(1808));
            container.setLayout((Layout)new GridLayout(2, true));
            this.setShellStyle(this.getShell().getStyle() | 0x10);
            Label label = new Label(container, 0);
            label.setText("Start");
            label.setLayoutData((Object)new GridData(1808));
            label = new Label(container, 0);
            label.setText("Length");
            label.setLayoutData((Object)new GridData(1808));
            this.start = new Text(container, 2048);
            this.startValue = ViewerTestDTD.this.fSourceViewer.getVisibleRegion().getOffset();
            this.start.setText("" + this.startValue);
            this.start.setLayoutData((Object)new GridData(1808));
            this.length = new Text(container, 2048);
            this.lengthValue = ViewerTestDTD.this.fSourceViewer.getVisibleRegion().getLength();
            this.length.setText("" + this.lengthValue);
            this.length.setLayoutData((Object)new GridData(1808));
            return composite;
        }

        protected void okPressed() {
            try {
                this.startValue = Integer.decode(this.start.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.startValue = 0;
            }
            try {
                this.lengthValue = Integer.decode(this.length.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.lengthValue = 0;
            }
            super.okPressed();
        }
    }
}

