/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.RuntimeTypeWithServerProxy;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.internal.wizard.page.NewRuntimeComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRuntimeWizardFragment
extends WizardFragment {
    protected String type;
    protected String version;
    protected String runtimeTypeId;
    protected Map<String, WizardFragment> fragmentMap = new HashMap<String, WizardFragment>();
    protected NewRuntimeComposite comp;

    public NewRuntimeWizardFragment() {
    }

    public NewRuntimeWizardFragment(String type, String version, String runtimeTypeId) {
        this.type = type;
        this.version = version;
        this.runtimeTypeId = runtimeTypeId;
    }

    @Override
    public boolean hasComposite() {
        return true;
    }

    @Override
    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        this.comp = new NewRuntimeComposite(parent, wizard, this.getTaskModel(), this.type, this.version, this.runtimeTypeId);
        return this.comp;
    }

    @Override
    public List getChildFragments() {
        ArrayList<WizardFragment> listImpl = new ArrayList<WizardFragment>();
        this.createChildFragments(listImpl);
        return listImpl;
    }

    @Override
    protected void createChildFragments(List<WizardFragment> list) {
        Object serverObj;
        if (this.getTaskModel() == null) {
            return;
        }
        Object runtime = this.getTaskModel().getObject("runtime");
        if (runtime == null) {
            return;
        }
        WizardFragment sub = null;
        if (runtime instanceof IRuntimeWorkingCopy) {
            sub = this.getWizardFragment(((RuntimeWorkingCopy)runtime).getRuntimeType().getId());
        } else if (runtime instanceof RuntimeTypeWithServerProxy) {
            sub = this.getWizardFragment(((RuntimeTypeWithServerProxy)runtime).getId());
        }
        if (sub != null) {
            list.add(sub);
        }
        if ((serverObj = this.getTaskModel().getObject("server")) != null && serverObj instanceof IServerWorkingCopy) {
            IServerWorkingCopy server = (IServerWorkingCopy)serverObj;
            if (server.getServerType().hasServerConfiguration() && server instanceof ServerWorkingCopy) {
                ServerWorkingCopy swc = (ServerWorkingCopy)server;
                try {
                    RuntimeWorkingCopy runtimeWorkingCopy;
                    if (runtime instanceof IRuntimeWorkingCopy && (runtimeWorkingCopy = (RuntimeWorkingCopy)runtime).getLocation() != null && !runtimeWorkingCopy.getLocation().isEmpty()) {
                        swc.importRuntimeConfiguration((IRuntime)runtimeWorkingCopy, null);
                    }
                }
                catch (CoreException coreException) {}
            }
            list.add(new WizardFragment(){

                public void enter() {
                    IRuntimeWorkingCopy runtime2 = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
                    IServerWorkingCopy server2 = (IServerWorkingCopy)this.getTaskModel().getObject("server");
                    server2.setRuntime((IRuntime)runtime2);
                }
            });
            sub = this.getWizardFragment(server.getServerType().getId());
            if (sub != null) {
                list.add(sub);
            }
            list.add(WizardTaskUtil.SaveServerFragment);
        }
    }

    protected WizardFragment getWizardFragment(String typeId) {
        WizardFragment fragment;
        try {
            fragment = this.fragmentMap.get(typeId);
            if (fragment != null) {
                return fragment;
            }
        }
        catch (Exception exception) {}
        fragment = ServerUIPlugin.getWizardFragment(typeId);
        if (fragment != null) {
            this.fragmentMap.put(typeId, fragment);
        }
        return fragment;
    }

    @Override
    public boolean isComplete() {
        return this.comp.hasValidSelectedRuntime();
    }

    @Override
    public void exit() {
        this.comp.refreshExtension();
    }
}

