/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.hyperlink;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.css.core.internal.document.CSSRegionContainer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.ui.internal.hyperlink.WorkspaceFileHyperlink;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSPrimitiveValue;

public class CSSHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (textViewer != null && region != null) {
            IHyperlink hyperlink;
            IDocument document = textViewer.getDocument();
            ICSSNode node = this.getNode(document, region);
            if (node == null) {
                return null;
            }
            String href = null;
            switch (node.getNodeType()) {
                case 11: {
                    if (((CSSPrimitiveValue)node).getPrimitiveType() != 20) break;
                    href = ((CSSPrimitiveValue)node).getStringValue();
                    break;
                }
                case 3: {
                    href = ((CSSImportRule)node).getHref();
                }
            }
            if (href != null && (hyperlink = this.getHyperlink(node, href)) != null) {
                return new IHyperlink[]{hyperlink};
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private ICSSNode getNode(IDocument document, IRegion region) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 69->72)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IHyperlink getHyperlink(ICSSNode node, String href) {
        String resolvedHref;
        IHyperlink hyperlink = null;
        String baseLocation = this.getBaseLocation((IStructuredModel)node.getOwnerDocument().getModel());
        if (baseLocation != null && (resolvedHref = URIResolverPlugin.createResolver().resolve(baseLocation, null, href)) != null && this.isValidURI(resolvedHref)) {
            IRegion hyperlinkRegion = this.getHyperlinkRegion(node, href);
            hyperlink = this.createHyperlink(resolvedHref, hyperlinkRegion);
        }
        return hyperlink;
    }

    private IRegion getHyperlinkRegion(ICSSNode node, String href) {
        CSSRegionContainer uriRegion = null;
        switch (node.getNodeType()) {
            case 11: {
                uriRegion = (CSSRegionContainer)node;
                break;
            }
            case 3: {
                ICSSNode attribute = node.getAttributes().getNamedItem("href");
                if (!(attribute instanceof CSSRegionContainer)) break;
                uriRegion = (CSSRegionContainer)attribute;
            }
        }
        if (uriRegion != null) {
            int start = uriRegion.getStartOffset();
            int end = uriRegion.getEndOffset();
            if (end > start) {
                return new Region(start, end - start);
            }
        }
        return null;
    }

    private IHyperlink createHyperlink(String href, IRegion region) {
        String systemPath;
        IFile file;
        WorkspaceFileHyperlink link = null;
        File systemFile = this.getFileFromUriString(href);
        if (systemFile != null && (file = this.getFile(systemPath = systemFile.getPath())) != null) {
            link = new WorkspaceFileHyperlink(region, file);
        }
        return link;
    }

    private IFile getFile(String fileString) {
        IFile file = null;
        if (fileString != null) {
            Path filePath = new Path(fileString);
            if (filePath.segmentCount() > 1 && ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath).exists()) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
            }
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
            int i = 0;
            while (i < files.length && file == null) {
                if (files[i].exists()) {
                    file = files[i];
                }
                ++i;
            }
        }
        return file;
    }

    private boolean isValidURI(String uriString) {
        boolean isValid = false;
        File file = this.getFileFromUriString(uriString);
        if (file != null) {
            isValid = file.isFile();
        }
        return isValid;
    }

    private File getFileFromUriString(String uriString) {
        File file = null;
        try {
            file = new File(uriString);
            URI uri = new URI(uriString);
            file = new File(uri);
        }
        catch (Exception exception) {}
        return file;
    }

    private String getBaseLocation(IStructuredModel model) {
        IFile file;
        Path path;
        String result = null;
        if (model != null && (path = new Path(result = model.getBaseLocation())).segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)).exists()) {
            String baseLocation = null;
            if (file.getLocation() != null) {
                baseLocation = file.getLocation().toString();
            }
            if (baseLocation == null && file.getLocationURI() != null) {
                baseLocation = file.getLocationURI().toString();
            }
            if (baseLocation == null) {
                baseLocation = file.getFullPath().toString();
            }
            result = baseLocation;
        }
        return result;
    }
}

