/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.details;

import java.util.ArrayList;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.swt.widgets.ComboTools;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.FilteringCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SetCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationListValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class EclipseLinkConvertCombo
extends Pane<EclipseLinkConvert> {
    private Combo combo;
    protected static String DEFAULT_KEY = "?!#!?#?#?default?#?!#?!#?";

    public EclipseLinkConvertCombo(Pane<?> parentPane, PropertyValueModel<? extends EclipseLinkConvert> subjectModel, PropertyValueModel<Boolean> enabledModel, Composite parentComposite) {
        super(parentPane, subjectModel, enabledModel, parentComposite);
    }

    protected boolean addsComposite() {
        return false;
    }

    public Combo getControl() {
        return this.combo;
    }

    protected void initializeLayout(Composite container) {
        this.combo = this.addEditableCombo(container, this.buildConvertNameListHolder(), this.buildConvertNameHolder(), this.buildConverterNameTransformer(), null);
        ComboTools.handleDefaultValue((Combo)this.combo);
    }

    protected final ModifiablePropertyValueModel<String> buildConvertNameHolder() {
        return new PropertyAspectAdapter<EclipseLinkConvert, String>(this.getSubjectHolder(), new String[]{"specifiedConverterName"}){

            protected String buildValue_() {
                return ((EclipseLinkConvert)this.subject).getSpecifiedConverterName();
            }

            protected void setValue_(String value) {
                if (value != null && value.startsWith(DEFAULT_KEY)) {
                    value = "none";
                }
                ((EclipseLinkConvert)this.subject).setSpecifiedConverterName(value);
            }
        };
    }

    private ListValueModel<String> buildConvertNameListHolder() {
        ArrayList<ListValueModel<String>> list = new ArrayList<ListValueModel<String>>();
        list.add(this.buildDefaultNameListHolder());
        list.add(this.buildReservedConverterNameListHolder());
        list.add(this.buildSortedConverterNamesModel());
        return CompositeListValueModel.forModels(list);
    }

    protected ListValueModel<String> buildDefaultNameListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultNameHolder());
    }

    private ModifiablePropertyValueModel<String> buildDefaultNameHolder() {
        return new PropertyAspectAdapter<EclipseLinkConvert, String>(this.getSubjectHolder(), new String[]{"defaultConverterName"}){

            protected String buildValue_() {
                String name = ((EclipseLinkConvert)this.subject).getDefaultConverterName();
                name = name == null ? DEFAULT_KEY : String.valueOf(DEFAULT_KEY) + name;
                return name;
            }
        };
    }

    private Transformer<String, String> buildConverterNameTransformer() {
        return new ConverterNameTransformer();
    }

    protected ListValueModel<String> buildReservedConverterNameListHolder() {
        return new StaticListValueModel((Object[])EclipseLinkConvert.RESERVED_CONVERTER_NAMES);
    }

    protected ListValueModel<String> buildSortedConverterNamesModel() {
        return new SortedListValueModelAdapter(this.buildUniqueConverterNamesModel());
    }

    protected CollectionValueModel<String> buildUniqueConverterNamesModel() {
        return new SetCollectionValueModel(this.buildConverterNamesModel());
    }

    protected CollectionValueModel<String> buildConverterNamesModel() {
        return new FilteringCollectionValueModel(this.buildConverterNamesModel_(), StringTools.IS_NOT_BLANK);
    }

    protected ListValueModel<String> buildConverterNamesModel_() {
        return new TransformationListValueModel<EclipseLinkConverter, String>(this.buildConvertersModel()){

            protected String transformItem_(EclipseLinkConverter converter) {
                return converter.getName();
            }
        };
    }

    protected ListValueModel<EclipseLinkConverter> buildConvertersModel() {
        return new ItemPropertyListValueModelAdapter(this.buildConvertersModel_(), new String[]{"name"});
    }

    protected CollectionValueModel<EclipseLinkConverter> buildConvertersModel_() {
        return new CollectionAspectAdapter<EclipseLinkPersistenceUnit, EclipseLinkConverter>(this.buildPersistenceUnitHolder(), new String[]{"converters"}){

            protected Iterable<EclipseLinkConverter> getIterable() {
                return ((EclipseLinkPersistenceUnit)this.subject).getConverters();
            }

            protected int size_() {
                return ((EclipseLinkPersistenceUnit)this.subject).getConvertersSize();
            }
        };
    }

    protected PropertyValueModel<EclipseLinkPersistenceUnit> buildPersistenceUnitHolder() {
        return new PropertyAspectAdapter<EclipseLinkConvert, EclipseLinkPersistenceUnit>(this.getSubjectHolder()){

            protected EclipseLinkPersistenceUnit buildValue_() {
                return ((EclipseLinkConvert)this.subject).getPersistenceUnit();
            }
        };
    }

    class ConverterNameTransformer
    extends TransformerAdapter<String, String> {
        ConverterNameTransformer() {
        }

        public String transform(String value) {
            if (EclipseLinkConvertCombo.this.getSubject() == null) {
                return value;
            }
            if (value == null) {
                value = ((EclipseLinkConvert)EclipseLinkConvertCombo.this.getSubject()).getDefaultConverterName();
                value = value != null ? String.valueOf(DEFAULT_KEY) + value : DEFAULT_KEY;
            }
            if (value.startsWith(DEFAULT_KEY)) {
                String defaultName = value.substring(DEFAULT_KEY.length());
                value = defaultName.length() > 0 ? NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultName) : NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)"none");
            }
            return value;
        }
    }
}

