/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding.read;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.sse.core.internal.encoding.CodedReaderCreator;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.encoding.NonContentBasedEncodingRules;
import org.eclipse.wst.xml.tests.encoding.TestsPlugin;
import org.eclipse.wst.xml.tests.encoding.util.ProjectUnzipUtility;

public class TestCodedReader
extends TestCase {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_TEST_DETAIL = false;
    private static boolean fTestProjectInitialized;
    private static final String TEST_PROJECT_NAME = "org.eclipse.encoding.resource.newtests";
    static IProject fTestProject;
    protected static int nSetups;
    static /* synthetic */ Class class$0;

    static {
        nSetups = 0;
    }

    private String massageCharset(String foundCharset) {
        String result = foundCharset;
        if ("UTF-16LE".equals(foundCharset)) {
            result = "UTF-16";
        } else if ("X-UnicodeLittle".equals(foundCharset)) {
            result = "UTF-16";
        } else if ("X-UnicodeBig".equals(foundCharset)) {
            result = "UTF-16BE";
        }
        return result;
    }

    public static void main(String[] args) {
    }

    /*
     * Exception decompiling
     */
    private static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 123->127)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void getAndCreateProject() throws CoreException {
        IWorkspace workspace = TestsPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        fTestProject = root.getProject(TEST_PROJECT_NAME);
        TestCodedReader.createProject(fTestProject, null, null);
        fTestProject.refreshLocal(2, null);
        TestCodedReader.assertTrue((boolean)fTestProject.exists());
    }

    private StringBuffer readInputStream(Reader reader) throws IOException {
        StringBuffer buffer = new StringBuffer();
        int numRead = 0;
        char[] tBuff = new char[4000];
        while ((numRead = reader.read(tBuff, 0, tBuff.length)) != -1) {
            buffer.append(tBuff, 0, numRead);
        }
        return buffer;
    }

    protected void setUp() throws Exception {
        super.setUp();
        ++nSetups;
        if (!fTestProjectInitialized) {
            TestCodedReader.getAndCreateProject();
            String destinationProjectString = fTestProject.getLocation().toOSString();
            String destinationFolder = String.valueOf(destinationProjectString) + "/";
            File zipFile = TestsPlugin.getTestFile("testfiles.zip");
            ProjectUnzipUtility projUtil = new ProjectUnzipUtility();
            projUtil.unzipAndImport(zipFile, destinationFolder);
            projUtil.initJavaProject(TEST_PROJECT_NAME);
            fTestProject.refreshLocal(2, null);
            fTestProjectInitialized = true;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (--nSetups == 0) {
            // empty if block
        }
    }

    /*
     * Exception decompiling
     */
    protected void doTest(String expectedJavaCharset, String expectedDetectedCharset, String filePath, Class expectedException) throws CoreException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 159->163)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Reader doCoreTest(String expectedJavaCharset, String expectedDetectedCharset, IFile file) throws CoreException, IOException {
        CodedReaderCreator codedReaderCreator = new CodedReaderCreator();
        codedReaderCreator.set(file);
        Reader reader = codedReaderCreator.getCodedReader();
        String javaCharsetName = file.getCharset();
        IContentDescription description = file.getContentDescription();
        javaCharsetName = this.massageCharset(javaCharsetName);
        if (expectedJavaCharset.equals("expectPlatformCharset")) {
            String platformDefault = NonContentBasedEncodingRules.useDefaultNameRules(null);
            TestCodedReader.assertTrue((boolean)javaCharsetName.equals(platformDefault));
        } else {
            boolean asExpected = javaCharsetName.equals(expectedJavaCharset);
            TestCodedReader.assertTrue((String)(String.valueOf(javaCharsetName) + " did not equal the expected " + expectedJavaCharset + " (this is a VM dependent test)"), (boolean)asExpected);
        }
        String javaCharsetNameProperty = (String)description.getProperty(IContentDescription.CHARSET);
        String detectedCharsetNameProperty = this.getDetectedCharsetName(description);
        detectedCharsetNameProperty = this.massageCharset(detectedCharsetNameProperty);
        if (!expectedJavaCharset.equals("expectPlatformCharset")) {
            boolean expecedResult = expectedJavaCharset.equals(javaCharsetNameProperty);
            TestCodedReader.assertTrue((String)"java based charset name was not as expected", (boolean)expecedResult);
        } else {
            String expectedDefault = NonContentBasedEncodingRules.useDefaultNameRules(null);
            boolean ExpectedResult = expectedDefault.equals(javaCharsetNameProperty);
            TestCodedReader.assertTrue((String)"java based charset name not as expected when platform default expected", (boolean)ExpectedResult);
        }
        if (expectedDetectedCharset != null) {
            boolean expectedResult = expectedDetectedCharset.equals(detectedCharsetNameProperty);
            TestCodedReader.assertTrue((String)"detected charset name was not as expected", (boolean)expectedResult);
        }
        StringBuffer buffer = this.readInputStream(reader);
        return reader;
    }

    private String getDetectedCharsetName(IContentDescription description) {
        String result = null;
        result = (String)description.getProperty(IContentDescriptionExtended.DETECTED_CHARSET);
        return result;
    }

    private String getGoodFullMsg(Exception e) {
        String msg = String.valueOf(e.getClass().getName()) + ": " + e.getMessage();
        return msg;
    }

    public void testFile1() throws CoreException, IOException {
        this.doTest("expectPlatformCharset", null, "testfiles/css/emptyFile.css", null);
    }

    public void testFile2() throws CoreException, IOException {
        this.doTest("EUC-JP", "EUC-JP", "testfiles/css/encoding_test_eucjp.css", null);
    }

    public void testFile3() throws CoreException, IOException {
        this.doTest("ISO-2022-JP", "ISO-2022-JP", "testfiles/css/encoding_test_jis.css", null);
    }

    public void testFile4() throws CoreException, IOException {
        this.doTest("Shift_JIS", "SHIFT_JIS", "testfiles/css/encoding_test_sjis.css", null);
    }

    public void testFile5() throws CoreException, IOException {
        this.doTest("expectPlatformCharset", null, "testfiles/css/noEncoding.css", null);
    }

    public void testFile6() throws CoreException, IOException {
        this.doTest("ISO-8859-6", "ISO-8859-6", "testfiles/css/nonStandard.css", null);
    }

    public void testFile7() throws CoreException, IOException {
        this.doTest("ISO-8859-6", "ISO-8859-6", "testfiles/css/nonStandardIllFormed.css", null);
    }

    public void testFile8() throws CoreException, IOException {
        this.doTest("ISO-8859-6", "ISO-8859-6", "testfiles/css/nonStandardIllFormed2.css", null);
    }

    public void testFile57() throws CoreException, IOException {
        this.doTest("expectPlatformCharset", null, "testfiles/html/EmptyFile.html", null);
    }

    public void testFile58() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/html/IllformedNormalNonDefault.html", null);
    }

    public void testFile59() throws CoreException, IOException {
        this.doTest("expectPlatformCharset", null, "testfiles/html/LargeNoEncoding.html", null);
    }

    public void testFile60() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "iso-8859-1", "testfiles/html/LargeNonDefault.html", null);
    }

    public void testFile61() throws CoreException, IOException {
        this.doTest("ISO-8859-6", "ISO-8859-6", "testfiles/html/MultiNonDefault.html", null);
    }

    public void testFile62() throws CoreException, IOException {
        this.doTest("expectPlatformCharset", null, "testfiles/html/NoEncoding.html", null);
    }

    public void testFile63() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/html/noquotes.html", null);
    }

    public void testFile64() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/html/NormalNonDefault.html", null);
    }

    public void testFile65() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/jsp/EmptyFile.jsp", null);
    }

    public void testFile66() throws CoreException, IOException {
        this.doTest("ISO-8859-8", null, "testfiles/jsp/IllformedNormalNonDefault.jsp", null);
    }

    public void testFile67() throws CoreException, IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.core.internal.exceptions.UnsupportedCharsetExceptionWithDetail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.doTest("null", "null", "testfiles/jsp/inValidEncodingValue.jsp", clazz);
    }

    public void testFile68() throws CoreException, IOException {
        this.doTest("windows-1252", "Cp1252", "testfiles/jsp/javaEncodingValue.jsp", null);
    }

    public void testFile69() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/jsp/MalformedNoEncoding.jsp", null);
    }

    public void testFile70() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/jsp/MalformedNoEncodingXSL.jsp", null);
    }

    public void testFile71() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/jsp/noEncoding.jsp", null);
    }

    public void testFile72() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/jsp/NoEncodinginXMLDecl.jsp", null);
    }

    public void testFile73() throws CoreException, IOException {
        this.doTest("ISO-8859-2", "ISO-8859-2", "testfiles/jsp/nomalDirectiveCase.jsp", null);
    }

    public void testFile74() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/jsp/nomalDirectiveCaseNoEncoding.jsp", null);
    }

    public void testFile75() throws CoreException, IOException {
        this.doTest("ISO-8859-3", "ISO-8859-3", "testfiles/jsp/nomalDirectiveCaseUsingCharset.jsp", null);
    }

    public void testFile76() throws CoreException, IOException {
        this.doTest("ISO-8859-2", "ISO-8859-2", "testfiles/jsp/nomalDirectiveCaseUsingXMLSyntax.jsp", null);
    }

    public void testFile77() throws CoreException, IOException {
        this.doTest("ISO-8859-8", null, "testfiles/jsp/NormalNonDefault.jsp", null);
    }

    public void testFile78() throws CoreException, IOException {
        this.doTest("ISO-8859-8", "ISO-8859-8", "testfiles/jsp/NormalNonDefaultWithXMLDecl.jsp", null);
    }

    public void testFile79() throws CoreException, IOException {
        this.doTest("ISO-8859-7", "ISO-8859-7", "testfiles/jsp/NormalPageCaseNonDefault.jsp", null);
    }

    public void testFile80() throws CoreException, IOException {
        this.doTest("Shift_JIS", "SHIFT_JIS", "testfiles/jsp/SelColBeanRow12ResultsForm.jsp", null);
    }

    public void testFile81() throws CoreException, IOException {
        this.doTest("ISO-8859-3", "ISO-8859-3", "testfiles/jsp/testBrokenLine.jsp", null);
    }

    public void testFile82() throws CoreException, IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.core.internal.exceptions.UnsupportedCharsetExceptionWithDetail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.doTest("null", "null", "testfiles/jsp/testDefaultEncoding.jsp", clazz);
    }

    public void testFile83() throws CoreException, IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.core.internal.exceptions.UnsupportedCharsetExceptionWithDetail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.doTest("null", "null", "testfiles/jsp/testDefaultEncodingWithJunk.jsp", clazz);
    }

    public void testFile84() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/jsp/testExtraJunk.jsp", null);
    }

    public void testFile85() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/jsp/testExtraValidStuff.jsp", null);
    }

    public void testFile86() throws CoreException, IOException {
        this.doTest("ISO-8859-1", null, "testfiles/jsp/testIllFormed.jsp", null);
    }

    public void testFile87() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/jsp/testIllFormed2.jsp", null);
    }

    public void testFile88() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/jsp/testNoEncodingValue.jsp", null);
    }

    public void testFile89() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/jsp/testNoPageDirective.jsp", null);
    }

    public void testFile90() throws CoreException, IOException {
        this.doTest("ISO-8859-2", "ISO-8859-2", "testfiles/jsp/testNoPageDirectiveAtFirst.jsp", null);
    }

    public void testFile91() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/jsp/testNoPageDirectiveInLargeFile.jsp", null);
    }

    public void testFile92() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/jsp/testNormalCase.jsp", null);
    }

    public void testFile93() throws CoreException, IOException {
        this.doTest("UTF-16", "UTF-16", "testfiles/jsp/testUTF16.jsp", null);
    }

    public void testFile94() throws CoreException, IOException {
        this.doTest("UTF-16LE", "UTF-16LE", "testfiles/jsp/utf16UnicodeStreamWithNoEncodingInHeader2.jsp", null);
    }

    public void testFile95() throws CoreException, IOException {
        this.doTest("UTF-16", "UTF-16", "testfiles/jsp/utf16UnicodeStreamWithNoEncodingInHeaderBE.jsp", null);
    }

    public void testFile96() throws CoreException, IOException {
        this.doTest("UTF-16", "UTF-16", "testfiles/jsp/utf16WithJapaneseChars.jsp", null);
    }

    public void testFile97() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/jsp/UTF8With3ByteBOM.jsp", null);
    }

    public void testFile98() throws CoreException, IOException {
        this.doTest("ISO-8859-8", "ISO-8859-8", "testfiles/jsp/WellFormedNormalNonDefault.jsp", null);
    }

    public void testFile99() throws CoreException, IOException {
        this.doTest("Shift_JIS", "SHIFT_JIS", "testfiles/regressionTestFiles/defect223365/SelColBeanRow12ResultsForm.jsp", null);
    }

    public void testFile100() throws CoreException, IOException {
        this.doTest("Shift_JIS", "SHIFT_JIS", "testfiles/regressionTestFiles/defect223365/SelColBeanRow12ResultsFormB.jsp", null);
    }

    public void testFile101() throws CoreException, IOException {
        this.doTest("Shift_JIS", "SHIFT_JIS", "testfiles/regressionTestFiles/defect224293/testshiftjisXmlSyntax.jsp", null);
    }

    public void testFile102() throws CoreException, IOException {
        this.doTest("Shift_JIS", "Shift_JIS", "testfiles/regressionTestFiles/defect229667/audi.jsp", null);
    }

    public void testFile103() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/EmptyFile.xml", null);
    }

    public void testFile104() throws CoreException, IOException {
        this.doTest("EUC-JP", "EUC-JP", "testfiles/xml/eucjp.xml", null);
    }

    public void testFile108() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/NoEncoding.xml", null);
    }

    public void testFile109() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/xml/NormalNonDefault.xml", null);
    }

    public void testFile110() throws CoreException, IOException {
        this.doTest("Shift_JIS", "Shift_JIS", "testfiles/xml/shiftjis.xml", null);
    }

    public void testFile111() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/xml/testExtraJunk.xml", null);
    }

    public void testFile112() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/testExtraValidStuff.xml", null);
    }

    public void testFile114() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/testIllFormed2.xml", null);
    }

    public void testFile116() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/testIllFormed4.xml", null);
    }

    public void testFile117() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "ISO-8859-1", "testfiles/xml/testMultiLine.xml", null);
    }

    public void testFile118() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/testNoEncodingValue.xml", null);
    }

    public void testFile119() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/testNormalCase.xml", null);
    }

    public void testFile120() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/testNoXMLDecl.xml", null);
    }

    public void testFile121() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/testNoXMLDeclAtFirst.xml", null);
    }

    public void testFile122() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/testNoXMLDeclInLargeFile.xml", null);
    }

    public void testFile128() throws CoreException, IOException {
        this.doTest("UTF-8", "UTF-8", "testfiles/xml/UTF8With3ByteBOM.xml", null);
    }

    public void testDocumentStreamCaseHTML() throws CoreException, IOException {
        this.doTest("Shift_JIS", "SHIFT_JIS", "testfiles/DocumentStreamTestCase/kaeru5.htm", null);
    }

    public void testDocumentStreamCaseJSP() throws CoreException, IOException {
        this.doTest("Shift_JIS", "SHIFT_JIS", "testfiles/DocumentStreamTestCase/kaeru5.jsp", null);
    }
}

