/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedSecondaryTable;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaSecondaryTableTests
extends ContextModelTestCase {
    private static final String TABLE_NAME = "MY_TABLE";

    private ICompilationUnit createTestEntityWithSecondaryTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@SecondaryTable(name=\"MY_TABLE\")");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithSecondaryTables() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@SecondaryTables({@SecondaryTable(name=\"foo\"), @SecondaryTable(name=\"bar\")})");
            }
        });
    }

    public JavaSecondaryTableTests(String name) {
        super(name);
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next();
        JavaSecondaryTableTests.assertEquals((String)TABLE_NAME, (String)secondaryTable.getSpecifiedName());
    }

    public void testGetDefaultNameNull() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next();
        JavaSecondaryTableTests.assertNull((Object)secondaryTable.getDefaultName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next();
        JavaSecondaryTableTests.assertEquals((String)TABLE_NAME, (String)secondaryTable.getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next();
        secondaryTable.setSpecifiedName("foo");
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getSpecifiedName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)table.getName());
    }

    public void testUpdateFromSpecifiedNameChangeInResourceModel() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getSpecifiedName());
    }

    public void testUpdateFromSpecifiedCatalogChangeInResourceModel() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator secondaryTableResources = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        ((SecondaryTableAnnotation)secondaryTableResources.next()).setCatalog("foo");
        ((SecondaryTableAnnotation)secondaryTableResources.next()).setCatalog("bar");
        this.getJpaProject().synchronizeContextModel();
        ListIterator secondaryTsbles = this.getJavaEntity().getSecondaryTables().iterator();
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)((JavaSpecifiedSecondaryTable)secondaryTsbles.next()).getSpecifiedCatalog());
        JavaSecondaryTableTests.assertEquals((String)"bar", (String)((JavaSpecifiedSecondaryTable)secondaryTsbles.next()).getSpecifiedCatalog());
    }

    public void testUpdateFromSpecifiedSchemaChangeInResourceModel() throws Exception {
        this.createTestEntityWithSecondaryTables();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator secondaryTableResources = resourceType.getAnnotations("javax.persistence.SecondaryTable").iterator();
        ((SecondaryTableAnnotation)secondaryTableResources.next()).setSchema("foo");
        ((SecondaryTableAnnotation)secondaryTableResources.next()).setSchema("bar");
        this.getJpaProject().synchronizeContextModel();
        ListIterator secondaryTsbles = this.getJavaEntity().getSecondaryTables().iterator();
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)((JavaSpecifiedSecondaryTable)secondaryTsbles.next()).getSpecifiedSchema());
        JavaSecondaryTableTests.assertEquals((String)"bar", (String)((JavaSpecifiedSecondaryTable)secondaryTsbles.next()).getSpecifiedSchema());
    }

    public void testGetCatalog() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation table = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        table.setCatalog("myCatalog");
        this.getJpaProject().synchronizeContextModel();
        JavaSecondaryTableTests.assertEquals((String)"myCatalog", (String)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getSpecifiedCatalog());
        JavaSecondaryTableTests.assertEquals((String)"myCatalog", (String)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getCatalog());
    }

    public void testGetDefaultCatalog() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSecondaryTableTests.assertNull((Object)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getDefaultCatalog());
        ((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).setSpecifiedCatalog("myCatalog");
        JavaSecondaryTableTests.assertNull((Object)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getDefaultCatalog());
    }

    public void testSetSpecifiedCatalog() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable table = (SpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next();
        table.setSpecifiedCatalog("myCatalog");
        table.setSpecifiedName(null);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation tableAnnotation = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((String)"myCatalog", (String)tableAnnotation.getCatalog());
    }

    public void testGetSchema() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        tableResource.setSchema("mySchema");
        this.getJpaProject().synchronizeContextModel();
        JavaSecondaryTableTests.assertEquals((String)"mySchema", (String)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getSpecifiedSchema());
        JavaSecondaryTableTests.assertEquals((String)"mySchema", (String)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getSchema());
    }

    public void testGetDefaultSchema() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSecondaryTableTests.assertNull((Object)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getDefaultSchema());
        ((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).setSpecifiedSchema("mySchema");
        JavaSecondaryTableTests.assertNull((Object)((JavaSpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next()).getDefaultSchema());
    }

    public void testSetSpecifiedSchema() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable table = (SpecifiedSecondaryTable)this.getJavaEntity().getSecondaryTables().iterator().next();
        table.setSpecifiedSchema("mySchema");
        table.setSpecifiedName(null);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation tableAnnotation = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((String)"mySchema", (String)tableAnnotation.getSchema());
    }

    public void testSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedSecondaryTable secondaryTable = (JavaSpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        ListIterator specifiedPkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        PrimaryKeyJoinColumnAnnotation pkJoinColumn = tableResource.addPkJoinColumn(0);
        pkJoinColumn.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        pkJoinColumn = tableResource.addPkJoinColumn(0);
        pkJoinColumn.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        tableResource.movePkJoinColumn(1, 0);
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        tableResource.removePkJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
        tableResource.removePkJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumns.hasNext());
    }

    public void testSpecifiedPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        JavaSecondaryTableTests.assertEquals((int)0, (int)secondaryTable.getSpecifiedPrimaryKeyJoinColumnsSize());
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaSecondaryTableTests.assertEquals((int)3, (int)secondaryTable.getSpecifiedPrimaryKeyJoinColumnsSize());
    }

    public void testPrimaryKeyJoinColumnsSize() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        JavaSecondaryTableTests.assertEquals((int)1, (int)secondaryTable.getPrimaryKeyJoinColumnsSize());
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaSecondaryTableTests.assertEquals((int)3, (int)secondaryTable.getPrimaryKeyJoinColumnsSize());
    }

    public void testGetDefaultPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        JavaSecondaryTableTests.assertNotNull((Object)secondaryTable.getDefaultPrimaryKeyJoinColumn());
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        JavaSecondaryTableTests.assertNull((Object)secondaryTable.getDefaultPrimaryKeyJoinColumn());
    }

    public void testPrimaryKeyJoinColumnDefaults() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        SpecifiedPrimaryKeyJoinColumn defaultPkJoinColumn = secondaryTable.getDefaultPrimaryKeyJoinColumn();
        JavaSecondaryTableTests.assertNotNull((Object)defaultPkJoinColumn);
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultName());
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultReferencedColumnName());
        IdMapping idMapping = (IdMapping)this.getJavaEntity().getPersistentType().getAttributeNamed("id").getMapping();
        idMapping.getColumn().setSpecifiedName("FOO");
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)defaultPkJoinColumn.getDefaultName());
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)defaultPkJoinColumn.getDefaultReferencedColumnName());
        idMapping.getColumn().setSpecifiedName(null);
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultName());
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultReferencedColumnName());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedSecondaryTable secondaryTable = (JavaSpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("BAZ");
        ListIterator specifiedPkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        ListIterator pkJoinColumns = tableResource.getPkJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumns.hasNext());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn2() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedSecondaryTable secondaryTable = (JavaSpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        ListIterator specifiedPkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        ListIterator pkJoinColumns = tableResource.getPkJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumns.hasNext());
    }

    public void testRemoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedSecondaryTable secondaryTable = (JavaSpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((int)3, (int)tableResource.getPkJoinColumnsSize());
        secondaryTable.removeSpecifiedPrimaryKeyJoinColumn(1);
        ListIterator pkJoinColumnResources = tableResource.getPkJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        ListIterator pkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumns.hasNext());
        secondaryTable.removeSpecifiedPrimaryKeyJoinColumn(1);
        pkJoinColumnResources = tableResource.getPkJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumnResources.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        pkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumns.hasNext());
        secondaryTable.removeSpecifiedPrimaryKeyJoinColumn(0);
        pkJoinColumnResources = tableResource.getPkJoinColumns().iterator();
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumnResources.hasNext());
        pkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertFalse((boolean)pkJoinColumns.hasNext());
        JavaSecondaryTableTests.assertEquals((int)0, (int)tableResource.getPkJoinColumnsSize());
    }

    public void testMoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedSecondaryTable secondaryTable = (JavaSpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        ListIterator specifiedPkJoinColumns = secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedPrimaryKeyJoinColumn)specifiedPkJoinColumns.next()).getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation tableResource = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        ListIterator pkJoinColumns = tableResource.getPkJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        secondaryTable.moveSpecifiedPrimaryKeyJoinColumn(2, 0);
        pkJoinColumns = tableResource.getPkJoinColumns().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((PrimaryKeyJoinColumnAnnotation)pkJoinColumns.next()).getName());
    }

    public void testPrimaryKeyJoinColumnGetDefaultName() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        SpecifiedPrimaryKeyJoinColumn defaultPkJoinColumn = secondaryTable.getDefaultPrimaryKeyJoinColumn();
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultName());
        JavaSpecifiedPersistentAttribute idAttribute = this.getJavaPersistentType().getAttributeNamed("id");
        idAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaSecondaryTableTests.assertNull((Object)defaultPkJoinColumn.getDefaultName());
    }

    public void testPrimaryKeyJoinColumnGetDefaultReferencedColumnName() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        SpecifiedPrimaryKeyJoinColumn defaultPkJoinColumn = secondaryTable.getDefaultPrimaryKeyJoinColumn();
        JavaSecondaryTableTests.assertEquals((String)"id", (String)defaultPkJoinColumn.getDefaultReferencedColumnName());
        JavaSpecifiedPersistentAttribute idAttribute = this.getJavaPersistentType().getAttributeNamed("id");
        idAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaSecondaryTableTests.assertNull((Object)defaultPkJoinColumn.getDefaultReferencedColumnName());
    }

    public void testPrimaryKeyJoinColumnIsVirtual() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        JavaSecondaryTableTests.assertTrue((boolean)secondaryTable.getDefaultPrimaryKeyJoinColumn().isVirtual());
        secondaryTable.addSpecifiedPrimaryKeyJoinColumn(0);
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)secondaryTable.getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaSecondaryTableTests.assertFalse((boolean)specifiedPkJoinColumn.isVirtual());
        JavaSecondaryTableTests.assertNull((Object)secondaryTable.getDefaultPrimaryKeyJoinColumn());
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedSecondaryTable secondaryTable = (JavaSpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        ListIterator uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        secondaryTableAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        JavaSecondaryTableTests.assertEquals((String)"bar", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"foo", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        JavaSecondaryTableTests.assertEquals((int)0, (int)secondaryTable.getUniqueConstraintsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        secondaryTableAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        JavaSecondaryTableTests.assertEquals((int)2, (int)secondaryTable.getUniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        ListIterator uniqueConstraints = secondaryTableAnnotation.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedSecondaryTable secondaryTable = (SpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        secondaryTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        ListIterator uniqueConstraints = secondaryTableAnnotation.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedSecondaryTable secondaryTable = (JavaSpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        secondaryTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        secondaryTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((int)3, (int)secondaryTableAnnotation.getUniqueConstraintsSize());
        secondaryTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = secondaryTableAnnotation.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        ListIterator uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTable.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = secondaryTableAnnotation.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTable.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = secondaryTableAnnotation.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedSecondaryTable secondaryTable = (JavaSpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        secondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        secondaryTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        secondaryTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        JavaSecondaryTableTests.assertEquals((int)3, (int)secondaryTableAnnotation.getUniqueConstraintsSize());
        secondaryTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        ListIterator uniqueConstraintAnnotations = secondaryTableAnnotation.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        secondaryTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        uniqueConstraintAnnotations = secondaryTableAnnotation.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithSecondaryTable();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedSecondaryTable secondaryTable = (JavaSpecifiedSecondaryTable)this.getJavaEntity().getSpecifiedSecondaryTables().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        SecondaryTableAnnotation secondaryTableAnnotation = (SecondaryTableAnnotation)resourceType.getAnnotation(0, "javax.persistence.SecondaryTable");
        secondaryTableAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        secondaryTableAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        secondaryTableAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableAnnotation.moveUniqueConstraint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableAnnotation.moveUniqueConstraint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((JavaSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableAnnotation.removeUniqueConstraint(0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = secondaryTable.getUniqueConstraints().iterator();
        JavaSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

