/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.EmbeddableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class EmbeddableTests
extends JpaJavaResourceModelTestCase {
    public EmbeddableTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEmbeddable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable");
            }
        });
    }

    private ICompilationUnit createTestEmbeddableAndEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable", "javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Embeddable");
            }
        });
    }

    public void testEmbeddable() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        Annotation mappingAnnotation = resourceType.getAnnotation("javax.persistence.Embeddable");
        EmbeddableTests.assertTrue((boolean)(mappingAnnotation instanceof EmbeddableAnnotation));
    }

    public void testEmbeddableAndEntity() throws Exception {
        ICompilationUnit cu = this.createTestEmbeddableAndEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        Annotation mappingAnnotation = resourceType.getAnnotation("javax.persistence.Embeddable");
        EmbeddableTests.assertTrue((boolean)(mappingAnnotation instanceof EmbeddableAnnotation));
        EntityAnnotation entity = (EntityAnnotation)resourceType.getAnnotation("javax.persistence.Entity");
        EmbeddableTests.assertNotNull((Object)entity);
    }
}

