/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.wst.jsdt.chromium.CallbackSemaphore;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ScriptImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8BlockingCallback;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandCallbackBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandSender;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.V8ProtocolUtil;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.CommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FailedCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FrameObject;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ScriptHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.SomeRef;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.ContextlessDebuggerMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessageFactory;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.JsDataTypeUtil;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.LoadableString;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.PropertyReference;
import org.eclipse.wst.jsdt.chromium.internal.v8native.value.ValueLoadException;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;

public class V8Helper {
    public static final String JAVASCRIPT_VOID = "javascript:void(0);";

    public static RelayOk reloadAllScriptsAsync(DebugSession debugSession, ScriptLoadCallback callback, SyncCallback syncCallback) {
        return V8Helper.reloadScriptAsync(debugSession, null, callback, syncCallback);
    }

    public static RelayOk reloadScriptAsync(final DebugSession debugSession, final List<Long> ids, final ScriptLoadCallback callback, SyncCallback syncCallback) {
        ContextlessDebuggerMessage message = DebuggerMessageFactory.scripts(ids, (Boolean)true);
        message = ids == null ? DebuggerMessageFactory.scripts(4, (Boolean)true) : DebuggerMessageFactory.scripts(ids, (Boolean)true);
        return debugSession.sendMessageAsync(message, true, new V8CommandCallbackBase(){

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                if (callback != null) {
                    callback.failure(message);
                }
            }

            @Override
            public void success(SuccessCommandResponse successResponse) {
                List<ScriptHandle> body;
                try {
                    body = successResponse.body().asScripts();
                }
                catch (JsonProtocolParseException e) {
                    throw new RuntimeException(e);
                }
                ScriptManager scriptManager = debugSession.getScriptManager();
                int i = 0;
                while (i < body.size()) {
                    ScriptHandle scriptHandle = body.get(i);
                    if (!V8Helper.JAVASCRIPT_VOID.equals(scriptHandle.source())) {
                        Long id = V8ProtocolUtil.getScriptIdFromResponse(scriptHandle);
                        ScriptImpl scriptById = scriptManager.findById(id);
                        if (scriptById == null) {
                            scriptManager.addScript(scriptHandle, successResponse.refs());
                        } else if (ids != null) {
                            scriptById.setSource(scriptHandle.source());
                        }
                    }
                    ++i;
                }
                if (callback != null) {
                    callback.success();
                }
            }
        }, syncCallback);
    }

    public static PropertyReference computeReceiverRef(FrameObject frame) {
        SomeRef receiverObject = frame.receiver();
        return V8ProtocolUtil.extractProperty(receiverObject, V8ProtocolUtil.PropertyNameGetter.THIS);
    }

    public static LoadableString createLoadableString(ValueHandle handle, LoadableString.Factory stringFactory) {
        Long len = handle.length();
        Long toIndex = handle.toIndex();
        if (len != null && toIndex != null && len.longValue() != toIndex.longValue()) {
            return stringFactory.create(handle);
        }
        return new LoadableString.Immutable(handle.text());
    }

    public static JsValue.Type calculateType(String typeString, String className, boolean tolerateNullType) {
        JsValue.Type type = JsDataTypeUtil.fromJsonTypeAndClassName(typeString, className);
        if (type == null) {
            if (tolerateNullType) {
                type = JsValue.Type.TYPE_OBJECT;
            } else {
                throw new ValueLoadException("Bad value object");
            }
        }
        return type;
    }

    public static <MESSAGE, RES, EX extends Exception> RES callV8Sync(V8CommandSender<MESSAGE, EX> commandSender, MESSAGE message, V8BlockingCallback<RES> callback) throws EX, MethodIsBlockingException {
        return V8Helper.callV8Sync(commandSender, message, callback, 120000L);
    }

    public static <MESSAGE, RES, EX extends Exception> RES callV8Sync(V8CommandSender<MESSAGE, EX> commandSender, MESSAGE message, final V8BlockingCallback<RES> callback, long timeoutMs) throws EX, MethodIsBlockingException {
        boolean waitRes;
        CallbackSemaphore syncCallback = new CallbackSemaphore();
        final Exception[] exBuff = new Exception[1];
        final ArrayList<Object> resBuff = new ArrayList<Object>(Collections.nCopies(1, null));
        V8CommandProcessor.V8HandlerCallback callbackWrapper = new V8CommandProcessor.V8HandlerCallback(){

            @Override
            public void failure(String message) {
                exBuff[0] = new Exception("Failure: " + message);
            }

            @Override
            public void messageReceived(CommandResponse response) {
                Object result = callback.messageReceived(response);
                resBuff.set(0, result);
            }
        };
        commandSender.sendV8CommandAsync(message, true, callbackWrapper, syncCallback);
        try {
            waitRes = syncCallback.tryAcquire(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            throw new CallbackException(e);
        }
        if (!waitRes) {
            throw new CallbackException("Timeout");
        }
        if (exBuff[0] != null) {
            throw new CallbackException(exBuff[0]);
        }
        return (RES)resBuff.get(0);
    }

    public static class CallbackException
    extends RuntimeException {
        CallbackException() {
        }

        CallbackException(String message, Throwable cause) {
            super(message, cause);
        }

        CallbackException(String message) {
            super(message);
        }

        CallbackException(Throwable cause) {
            super(cause);
        }
    }

    public static interface ScriptLoadCallback {
        public void success();

        public void failure(String var1);
    }
}

