/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.JavaProjectWizardFirstPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.JavaProjectWizardSecondPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetConfigurationBlock;

public class JavaProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private JavaProjectWizardFirstPage fFirstPage;
    private JavaProjectWizardSecondPage fSecondPage;
    private IConfigurationElement fConfigElement;

    public JavaProjectWizard() {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(JavaScriptPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.JavaProjectWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.fFirstPage = new JavaProjectWizardFirstPage();
        this.fFirstPage.setWorkingSets(this.getWorkingSets(this.getSelection()));
        this.addPage((IWizardPage)this.fFirstPage);
        this.fSecondPage = new JavaProjectWizardSecondPage(this.fFirstPage);
        this.addPage((IWizardPage)this.fSecondPage);
    }

    @Override
    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    @Override
    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            final IJavaScriptElement newElement = this.getCreatedElement();
            IWorkingSet[] workingSets = this.fFirstPage.getWorkingSets();
            WorkingSetConfigurationBlock.addToWorkingSets((IAdaptable)newElement, workingSets);
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getJavaProject().getProject());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PackageExplorerPart activePackageExplorer = JavaProjectWizard.this.getActivePackageExplorer();
                    if (activePackageExplorer != null) {
                        activePackageExplorer.tryToReveal(newElement);
                    }
                }
            });
        }
        return res;
    }

    @Override
    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.JavaProjectWizard_op_error_title;
        String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    @Override
    public IJavaScriptElement getCreatedElement() {
        return JavaScriptCore.create((IProject)this.fFirstPage.getProjectHandle());
    }

    private IWorkingSet[] getWorkingSets(IStructuredSelection selection) {
        IWorkingSet[] selected = WorkingSetConfigurationBlock.getSelectedWorkingSet(selection);
        if (selected != null && selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                if (!this.isValidWorkingSet(selected[i])) {
                    return null;
                }
                ++i;
            }
            return selected;
        }
        PackageExplorerPart explorerPart = this.getActivePackageExplorer();
        if (explorerPart == null) {
            return null;
        }
        if (explorerPart.getRootMode() == 1) {
            IWorkingSet filterWorkingSet = explorerPart.getFilterWorkingSet();
            if (filterWorkingSet == null) {
                return null;
            }
            if (!this.isValidWorkingSet(filterWorkingSet)) {
                return null;
            }
            return new IWorkingSet[]{filterWorkingSet};
        }
        if (explorerPart.getRootMode() == 2) {
            Object input = explorerPart.getViewPartInput();
            if (!(input instanceof IWorkingSet)) {
                return null;
            }
            IWorkingSet workingSet = (IWorkingSet)input;
            if (!this.isValidWorkingSet(workingSet)) {
                return null;
            }
            return new IWorkingSet[]{workingSet};
        }
        return null;
    }

    private PackageExplorerPart getActivePackageExplorer() {
        PackageExplorerPart explorerPart = PackageExplorerPart.getFromActivePerspective();
        if (explorerPart == null) {
            return null;
        }
        IWorkbenchPage activePage = explorerPart.getViewSite().getWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return null;
        }
        if (activePage.getActivePart() != explorerPart) {
            return null;
        }
        return explorerPart;
    }

    private boolean isValidWorkingSet(IWorkingSet workingSet) {
        String id = workingSet.getId();
        if (!"org.eclipse.wst.jsdt.ui.JavaWorkingSetPage".equals(id) && !"org.eclipse.ui.resourceWorkingSetPage".equals(id)) {
            return false;
        }
        return !workingSet.isAggregateWorkingSet();
    }
}

