/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.validation;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.eclipse.wst.json.core.internal.parser.JSONLineTokenizer;
import org.eclipse.wst.json.core.validation.ISeverityProvider;
import org.eclipse.wst.json.core.validation.JSONSyntaxValidatorHelper;
import org.eclipse.wst.json.core.validation.MockReporter;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class JSONSyntaxValidatorHelperTest {
    private static final ISeverityProvider PROVIDER = new ISeverityProvider(){

        public int getSeverity(String preferenceName) {
            return 1;
        }
    };

    @Test
    public void noErrorsWithObject() throws Exception {
        IReporter reporter = this.validate("{}");
        List messages = reporter.getMessages();
        Assert.assertEquals((long)0L, (long)messages.size());
    }

    @Test
    public void missingEndObject() throws Exception {
        IReporter reporter = this.validate("{");
        List messages = reporter.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        LocalizedMessage msg = (LocalizedMessage)messages.get(0);
        this.assertMessage(msg, "Missing end object", 1, 1);
    }

    @Test
    public void noErrorsWithArray() throws Exception {
        IReporter reporter = this.validate("[]");
        List messages = reporter.getMessages();
        Assert.assertEquals((long)0L, (long)messages.size());
    }

    @Test
    public void missingEndArray() throws Exception {
        IReporter reporter = this.validate("[");
        List messages = reporter.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        LocalizedMessage msg = (LocalizedMessage)messages.get(0);
        this.assertMessage(msg, "Missing end array", 1, 1);
    }

    @Test
    public void unexpectedColonInArray() throws Exception {
        IReporter reporter = this.validate("[\"a\":]");
        List messages = reporter.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        LocalizedMessage msg = (LocalizedMessage)messages.get(0);
        this.assertMessage(msg, "Unexpected token", 1, 1);
    }

    @Test
    public void objectsInArray() throws Exception {
        IReporter reporter = this.validate("[{},{}]");
        List messages = reporter.getMessages();
        Assert.assertEquals((long)0L, (long)messages.size());
    }

    @Test
    @Ignore
    public void badObjectKey() throws Exception {
        IReporter reporter = this.validate("{aa}");
        List messages = reporter.getMessages();
        Assert.assertEquals((long)1L, (long)messages.size());
        LocalizedMessage msg = (LocalizedMessage)messages.get(0);
        this.assertMessage(msg, "Expected object key but found undefined", 1, 1);
    }

    @Test
    @Ignore
    public void missingEndObjectAndBadObjectKey() throws Exception {
        IReporter reporter = this.validate("{aa");
        List messages = reporter.getMessages();
        Assert.assertEquals((long)2L, (long)messages.size());
        LocalizedMessage msg = (LocalizedMessage)messages.get(0);
        this.assertMessage(msg, "Expected object key but found undefined", 1, 1);
        msg = (LocalizedMessage)messages.get(1);
        this.assertMessage(msg, "Missing end object", 1, 1);
    }

    private void assertMessage(LocalizedMessage msg, String message, int lineNumber, int length) {
        Assert.assertEquals((Object)message, (Object)msg.getLocalizedMessage());
        Assert.assertEquals((long)lineNumber, (long)msg.getLineNumber());
        Assert.assertEquals((long)length, (long)msg.getLength());
    }

    public IReporter validate(String json) {
        MockReporter reporter = new MockReporter();
        JSONLineTokenizer tokenizer = new JSONLineTokenizer((Reader)new StringReader(json));
        JSONSyntaxValidatorHelper.validate((JSONLineTokenizer)tokenizer, (IReporter)reporter, null, (ISeverityProvider)PROVIDER);
        return reporter;
    }
}

