/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jpt.common.core.internal.utility.PathTools;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResourceProvider;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class AbstractJptFileCreationOperation
extends AbstractDataModelOperation {
    protected IContainer container;
    protected IFile file;

    protected AbstractJptFileCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        this.createContainer((IProgressMonitor)sm.newChild(1));
        this.createFile((IProgressMonitor)sm.newChild(4));
        return OK_STATUS;
    }

    protected IContainer getContainer() throws ExecutionException {
        IPath containerPath = (IPath)this.getDataModel().getProperty("JptFileCreationDataModelProperties.CONTAINER_PATH");
        IContainer container = PathTools.getContainer(containerPath);
        if (container == null) {
            throw new ExecutionException("No container path specified");
        }
        return container;
    }

    protected IProject getProject() throws ExecutionException {
        return this.getContainer().getProject();
    }

    protected void createContainer(IProgressMonitor monitor) throws ExecutionException {
        IContainer container = this.getContainer();
        if (!container.exists()) {
            if (container.getType() == 4) {
                throw new ExecutionException("Project does not exist");
            }
            if (container.getType() == 2) {
                try {
                    ((IFolder)container).create(true, true, monitor);
                }
                catch (CoreException e) {
                    throw new ExecutionException("Could not create folder", (Throwable)e);
                }
            } else {
                throw new ExecutionException("Container is not a project or folder");
            }
        }
        this.container = container;
    }

    protected void createFile(IProgressMonitor monitor) throws ExecutionException {
        String fileName = this.getDataModel().getStringProperty("JptFileCreationDataModelProperties.FILE_NAME");
        IFile newFile = this.container.getFile((IPath)new Path(fileName));
        JptXmlResourceProvider resourceProvider = this.getXmlResourceProvider(newFile);
        try {
            resourceProvider.createFileAndResource(this.getDataModel(), monitor);
        }
        catch (CoreException e) {
            throw new ExecutionException("Could not create file", (Throwable)e);
        }
        this.file = newFile;
    }

    public ISchedulingRule getSchedulingRule() {
        try {
            return this.getProject();
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract JptXmlResourceProvider getXmlResourceProvider(IFile var1);
}

