/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.wst.jsdt.chromium.JsArray;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ExpressionTracker;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StackFrame;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;

public class ArrayValue
extends Value
implements IIndexedValue {
    private final AtomicReference<IVariable[]> elementsRef = new AtomicReference<Object>(null);
    private static final Set<String> ARRAY_HIDDEN_PROPERTY_NAMES = Collections.singleton("length");

    public ArrayValue(EvaluateContext evaluateContext, JsArray array, ExpressionTracker.Node expressionTrackerNode) {
        super(evaluateContext, (JsValue)array, expressionTrackerNode);
    }

    private IVariable[] createElements() {
        JsArray jsArray = (JsArray)this.getJsValue();
        return StackFrame.wrapVariables(this.getEvaluateContext(), jsArray.getProperties(), ARRAY_HIDDEN_PROPERTY_NAMES, null, null, this.getExpressionTrackerNode());
    }

    private IVariable[] getElements() {
        IVariable[] result = this.elementsRef.get();
        if (result == null) {
            result = this.createElements();
            this.elementsRef.compareAndSet(null, result);
            return this.elementsRef.get();
        }
        return result;
    }

    public int getInitialOffset() {
        return 0;
    }

    public int getSize() throws DebugException {
        return this.getElements().length;
    }

    public IVariable getVariable(int offset) throws DebugException {
        return this.getElements()[offset];
    }

    public IVariable[] getVariables(int offset, int length) throws DebugException {
        IVariable[] result = new IVariable[length];
        System.arraycopy(this.getElements(), offset, result, 0, length);
        return result;
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.getElements();
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return true;
    }
}

