/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.BlockBox;
import org.eclipse.jst.pagedesigner.css2.layout.BoxUtil;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.CSSLayout;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigure;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSPainter2;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;
import org.eclipse.jst.pagedesigner.css2.property.ICSSPropertyMeta;
import org.eclipse.jst.pagedesigner.css2.style.ITagEditInfo;
import org.eclipse.jst.pagedesigner.css2.value.Length;
import org.eclipse.jst.pagedesigner.css2.widget.BorderUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;

public class CSSBlockFlowLayout
extends CSSLayout
implements ICSSPainter2 {
    private LineBox _previousLine = null;
    protected BlockBox _blockBox = null;
    protected FontMetrics _fontMetrices;
    int _userSpecifiedWidth;
    int _userSpecifiedHeight;
    boolean _needHScroll = false;
    boolean _needVScroll = false;

    public CSSBlockFlowLayout(CSSFigure cssfigure) {
        super(cssfigure);
    }

    protected boolean hasMoreThanOneLine() {
        return this._previousLine != null;
    }

    public boolean isInlineBlock() {
        String obj = this.getCSSStyle().getDisplay();
        return "inline-block".equals(obj) || "inline-table".equals(obj);
    }

    public boolean shouldExpand() {
        ICSSStyle style = this.getCSSStyle();
        if (style == null) {
            return false;
        }
        return "block".equalsIgnoreCase(style.getDisplay()) || "list-item".equalsIgnoreCase(style.getDisplay());
    }

    protected void setupBlock() {
        LineBox lineBox;
        this._blockBox.clear();
        if (!this.isInlineBlock() && (lineBox = this.getFlowContext().getCurrentLine()) != null && !lineBox.isEmptyStringLine()) {
            this.getFlowContext().endLine();
        }
        ICSSStyle style = this.getCSSStyle();
        int marginTop = style.getMarginInsets().top;
        LineBox line = this.getFlowContext().getCurrentLine(marginTop);
        this._userSpecifiedWidth = 0;
        this._userSpecifiedHeight = 0;
        int width = this.getLengthValue(style, "width");
        int availableWidth = line.getAvailableWidth() - style.getMarginInsets().getWidth();
        if (width <= 0) {
            if (this.isCalculatingMaxWidth()) {
                this._blockBox.setRecommendedWidth(Integer.MAX_VALUE);
            } else {
                this._blockBox.setRecommendedWidth(availableWidth);
                if (this.shouldExpand()) {
                    this._blockBox.setWidth(availableWidth);
                }
            }
        } else {
            int w = width;
            if (!style.isSizeIncludeBorderPadding()) {
                w += style.getBorderInsets().getWidth() + style.getPaddingInsets().getWidth();
            }
            this._userSpecifiedWidth = w;
            this._blockBox.setWidth(w);
            this._blockBox.setRecommendedWidth(w);
        }
        int height = this.getLengthValue(style, "height");
        if (height <= 0) {
            this._blockBox.setHeight(0);
            this._blockBox.setRecommendedHeight(0);
        } else {
            int h = height;
            if (this.handlingBorderForBlock() && !style.isSizeIncludeBorderPadding()) {
                h += style.getBorderInsets().getHeight() + style.getPaddingInsets().getHeight();
            }
            this._userSpecifiedHeight = h;
            this._blockBox.setHeight(h);
            this._blockBox.setRecommendedHeight(h);
        }
        this._blockBox.setMarginInsets(new Insets(style.getMarginInsets()));
        if (this.handlingBorderForBlock()) {
            BoxUtil.setupBorderPaddingMargin(this._blockBox, this.getCSSStyle());
        }
        this._blockBox._y = line._y;
        this._blockBox._x = line._x;
        this.setBlockVerticalAlign(this._blockBox);
    }

    protected int getLengthValue(ICSSStyle style, String property) {
        int lengthValue = 0;
        if (style != null) {
            Length lengthObj;
            Object object = style.getStyleProperty(property);
            Length length = lengthObj = object instanceof Length ? (Length)object : null;
            if (lengthObj != null) {
                lengthValue = lengthObj.getValue();
                if (lengthObj.isPercentage()) {
                    if ("width".equalsIgnoreCase(property) || "min-width".equalsIgnoreCase(property)) {
                        lengthValue = this.getFlowContext().getCurrentLine().getRecommendedContentWidth() * lengthValue / 100;
                    } else if ("height".equalsIgnoreCase(property) || "min-height".equalsIgnoreCase(property)) {
                        lengthValue = 0;
                    }
                }
            }
        }
        return lengthValue;
    }

    private void setBlockVerticalAlign(BlockBox box) {
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            box.setVerticalAlignData(style.getStyleProperty("vertical-align"));
        }
    }

    protected void preLayout() {
        super.preLayout();
        this._blockBox = new BlockBox();
        this.setupBlock();
    }

    protected void layoutLines() {
        List lines = this._blockBox.getFragments();
        if (lines != null) {
            int i = 0;
            while (i < lines.size()) {
                if (lines.get(i) instanceof LineBox) {
                    this.layoutLine((LineBox)lines.get(i));
                }
                ++i;
            }
        }
    }

    protected void endBlock() {
        this.layoutLines();
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            int width;
            int height;
            int minWidth = 0;
            int minHeight = 0;
            ITagEditInfo info = (ITagEditInfo)style.getAdapter(ITagEditInfo.class);
            if (info != null) {
                minWidth = info.getMinWidth();
                minHeight = info.getMinHeight();
            }
            if ((height = this.getLengthValue(style, "min-height")) > minHeight) {
                minHeight = height;
            }
            if ((width = this.getLengthValue(style, "min-width")) > minWidth) {
                minWidth = width;
            }
            if (minHeight > this._blockBox.getHeight()) {
                this._blockBox.setHeight(minHeight);
            }
            if (minWidth > this._blockBox.getWidth()) {
                this._blockBox.setWidth(minWidth);
            }
        }
        this._needVScroll = false;
        this._needHScroll = false;
        if (style != null) {
            Object overflow = style.getStyleProperty("overflow");
            if ("hidden".equals(overflow)) {
                if (this._userSpecifiedWidth > 0) {
                    this._blockBox.setWidth(this._userSpecifiedWidth);
                }
                if (this._userSpecifiedHeight > 0) {
                    this._blockBox.setHeight(this._userSpecifiedHeight);
                }
            } else if ("scroll".equals(overflow) || "auto".equals(overflow)) {
                if (this._userSpecifiedWidth > 0 && this._userSpecifiedWidth < this._blockBox.getWidth()) {
                    this._needHScroll = true;
                }
                if (this._userSpecifiedHeight > 0 && this._userSpecifiedHeight < this._blockBox.getHeight()) {
                    this._needVScroll = true;
                }
                if (this._needHScroll && !this._needVScroll && this._userSpecifiedHeight > 0 && this._blockBox.getInternalContentHeight() >= 0 && this._userSpecifiedHeight < this._blockBox.getInternalContentHeight() + this._blockBox.getPaddingInsets().getHeight() + 16) {
                    this._needVScroll = true;
                }
                if (!this._needHScroll && this._needVScroll && this._userSpecifiedWidth > 0 && this._blockBox.getInternalContentWidth() >= 0 && this._userSpecifiedWidth < this._blockBox.getInternalContentWidth() + this._blockBox.getPaddingInsets().getWidth() + 16) {
                    this._needHScroll = true;
                }
                if (this._userSpecifiedWidth > 0) {
                    this._blockBox.setWidth(this._userSpecifiedWidth);
                }
                if (this._userSpecifiedHeight > 0) {
                    this._blockBox.setHeight(this._userSpecifiedHeight);
                }
            }
        }
        if (this.getFlowContext().isCurrentLineOccupied() && this.getFlowContext().getCurrentLine().getAvailableWidth() < this._blockBox._width + this._blockBox.getMarginInsets().getWidth()) {
            this.getFlowContext().endLine();
        }
        if (!this.isInlineBlock()) {
            LineBox line = this.getFlowContext().getCurrentLine();
            line.setHorizonalData(this.getCSSStyle().getStyleProperty("horizontal-align"));
            line.setHtmlInitData(this.getCSSStyle().getHTMLelementInitValue("horizontal-align"));
            line.add(this._blockBox);
        } else {
            this.getFlowContext().addToCurrentLine(this._blockBox);
        }
        this.getFlowContext().getCurrentLine().getMarginInsets().bottom = this.getCSSStyle().getMarginInsets().bottom;
        if (!this.isInlineBlock()) {
            this.getFlowContext().endLine();
        }
    }

    protected void layoutLine(LineBox line) {
        Object textalign = line.getHorizonalData();
        if (textalign == null || ICSSPropertyMeta.NOT_SPECIFIED.equals(textalign)) {
            textalign = this.getCSSStyle().getStyleProperty("text-align");
        }
        if (textalign == null || ICSSPropertyMeta.NOT_SPECIFIED.equals(textalign)) {
            textalign = line.getHtmlInitData();
        }
        if ("right".equals(textalign)) {
            line._x = this._blockBox.getContentWidth() - line.getWidth();
        } else if ("center".equals(textalign)) {
            line._x = (this._blockBox.getContentWidth() - line.getWidth()) / 2;
        }
        if (line._x < 0) {
            line._x = 0;
        }
        line.commit();
    }

    protected void addCurrentLine() {
        this._blockBox.add(this._currentLine);
    }

    protected void flush() {
        if (this._currentLine != null && this._currentLine.isOccupied()) {
            this.addCurrentLine();
        }
        this.endBlock();
    }

    protected void cleanup() {
        this._previousLine = null;
        this._currentLine = null;
        this._fontMetrices = null;
    }

    protected void setupLine(LineBox line, int topMargin) {
        line.clear();
        line._x = 0;
        line.setRecommendedWidth(this._blockBox.getRecommendedContentWidth());
        if (this._previousLine == null) {
            line._y = 0;
            if (topMargin != Integer.MIN_VALUE) {
                line._y += topMargin;
            }
        } else {
            line._y = topMargin == Integer.MIN_VALUE ? this._previousLine._y + this._previousLine.getHeight() + this.getLinePadding() + this._previousLine.getMarginInsets().bottom : this._previousLine._y + this._previousLine.getHeight() + Math.max(topMargin, this._previousLine.getMarginInsets().bottom);
        }
        this.setFontinfoForLine(line);
    }

    private void setFontinfoForLine(LineBox line) {
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            if (this._fontMetrices == null) {
                this._fontMetrices = FigureUtilities.getFontMetrics((Font)style.getCSSFont().getSwtFont());
            }
            line.setFontMetrics(this._fontMetrices);
        }
    }

    protected void createNewLine() {
        this._currentLine = new LineBox();
        this.setupLine(this._currentLine, Integer.MIN_VALUE);
    }

    protected void createNewLine(int topmargin) {
        this._currentLine = new LineBox();
        this.setupLine(this._currentLine, topmargin);
    }

    public void endLine() {
        LineBox box;
        if (this._currentLine == null) {
            return;
        }
        if (!this._currentLine.isOccupied()) {
            this._currentLine = null;
            return;
        }
        this.addCurrentLine();
        this._previousLine = box = this._currentLine;
        this._currentLine = null;
    }

    public int getCurrentY() {
        return this.getCurrentLine()._y;
    }

    int getLinePadding() {
        return 0;
    }

    public boolean useLocalCoordinates() {
        return true;
    }

    public void dispose() {
    }

    public List getFragmentsForRead() {
        ArrayList<BlockBox> r = new ArrayList<BlockBox>(1);
        r.add(this._blockBox);
        return r;
    }

    public void postValidate() {
        Rectangle r = new Rectangle(this._blockBox._x, this._blockBox._y, this._blockBox.getWidth(), this._blockBox.getHeight());
        this.getCSSFigure().setBounds(r);
        List list = this.getCSSFigure().getChildren();
        int i = 0;
        while (i < list.size()) {
            ((FlowFigure)((Object)list.get(i))).postValidate();
            ++i;
        }
    }

    public int getContainerWidth() {
        int width = Math.max(0, Math.max(this._blockBox.getWidth(), this._blockBox.getRecommendedWidth()));
        return width;
    }

    public void paintFigurePostClientArea(Graphics g) {
        Object overflow;
        ICSSStyle style = this.getCSSStyle();
        if (style != null && ("scroll".equals(overflow = style.getStyleProperty("overflow")) || "auto".equals(overflow)) && (this._needHScroll || this._needVScroll)) {
            g.translate(-this._blockBox.getBorderPaddingInsets().left, -this._blockBox.getBorderPaddingInsets().top);
            Rectangle rect = new Rectangle(0, 0, this._blockBox.getWidth(), this._blockBox.getHeight());
            rect.crop(this._blockBox.getBorderInsets());
            if (this._needHScroll && this._needVScroll) {
                BorderUtil.drawScrollBar(g, 16, rect, 2);
            } else if (this._needHScroll) {
                BorderUtil.drawScrollBar(g, 16, rect, 1);
            } else if (this._needVScroll) {
                BorderUtil.drawScrollBar(g, 16, rect, 0);
            }
        }
    }
}

