/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.refactor.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.wst.common.ui.internal.dialogs.SaveDirtyFilesDialog;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.impl.WSDLElementImpl;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.refactor.actions.WSDLSelectionDispatchAction;
import org.eclipse.wst.wsdl.ui.internal.util.NodeAssociationManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringComponent;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.XMLRefactoringComponent;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameComponentProcessor;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RenameRefactoringWizard;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Element;

public class RenameComponentAction
extends WSDLSelectionDispatchAction {
    private RefactoringComponent selectedComponent;

    public RenameComponentAction(ISelection selection, Definition model) {
        super(selection);
        this.setModel(model);
    }

    protected boolean doCanEnableXSDSelection(XSDNamedComponent selectedObject) {
        this.selectedComponent = null;
        if (selectedObject != null) {
            XSDElementDeclaration element;
            this.selectedComponent = new XMLRefactoringComponent((Object)selectedObject, (IDOMElement)selectedObject.getElement(), selectedObject.getName(), selectedObject.getTargetNamespace());
            if (selectedObject instanceof XSDElementDeclaration && (element = (XSDElementDeclaration)selectedObject).isElementDeclarationReference()) {
                this.selectedComponent = null;
            }
            if (selectedObject instanceof XSDTypeDefinition) {
                XSDAttributeDeclaration element2;
                XSDTypeDefinition type = (XSDTypeDefinition)selectedObject;
                XSDConcreteComponent parent = type.getContainer();
                if (parent instanceof XSDElementDeclaration) {
                    XSDElementDeclaration element3 = (XSDElementDeclaration)parent;
                    if (element3.getAnonymousTypeDefinition().equals(type)) {
                        this.selectedComponent = null;
                    }
                } else if (parent instanceof XSDAttributeDeclaration && (element2 = (XSDAttributeDeclaration)parent).getAnonymousTypeDefinition().equals(type)) {
                    this.selectedComponent = null;
                }
            }
        }
        return this.canRun();
    }

    protected boolean doCanEnableWSDLSelection(WSDLElement selectedObject) {
        this.selectedComponent = null;
        String localName = null;
        String namespace = null;
        if (selectedObject instanceof Binding) {
            localName = ((Binding)selectedObject).getQName().getLocalPart();
            namespace = ((Binding)selectedObject).getQName().getNamespaceURI();
        } else if (selectedObject instanceof PortType) {
            localName = ((PortType)selectedObject).getQName().getLocalPart();
            namespace = ((PortType)selectedObject).getQName().getNamespaceURI();
        } else if (selectedObject instanceof Message) {
            localName = ((Message)selectedObject).getQName().getLocalPart();
            namespace = ((Message)selectedObject).getQName().getNamespaceURI();
        }
        if (localName != null) {
            this.selectedComponent = new XMLRefactoringComponent((Object)selectedObject, (IDOMElement)selectedObject.getElement(), localName, namespace);
        }
        return this.canRun();
    }

    protected boolean canEnable(Object selectedObject) {
        if (selectedObject instanceof XSDNamedComponent) {
            return this.doCanEnableXSDSelection((XSDNamedComponent)selectedObject);
        }
        if (selectedObject instanceof WSDLElementImpl) {
            return this.doCanEnableWSDLSelection((WSDLElement)((WSDLElementImpl)selectedObject));
        }
        if (selectedObject instanceof Element) {
            Element node = (Element)selectedObject;
            if (this.getDefinition() != null) {
                Object concreteComponent = new NodeAssociationManager().getModelObjectForNode(this.getDefinition(), node);
                return this.canEnable(concreteComponent);
            }
        }
        return false;
    }

    public boolean canRun() {
        return this.selectedComponent != null;
    }

    public void run(ISelection selection) {
        boolean rc = SaveDirtyFilesDialog.saveDirtyFiles();
        if (!rc) {
            return;
        }
        RenameComponentProcessor processor = new RenameComponentProcessor(this.selectedComponent, this.selectedComponent.getName());
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        try {
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)refactoring, RefactoringMessages.getString((String)"RenameComponentWizard.defaultPageTitle"), RefactoringMessages.getString((String)"RenameComponentWizard.inputPage.description"), null){

                public boolean performFinish() {
                    boolean rc = super.performFinish();
                    return rc;
                }
            };
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            op.run(WSDLEditorPlugin.getShell(), wizard.getDefaultPageTitle());
            RenameComponentAction.triggerBuild();
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ((DefinitionImpl)RenameComponentAction.this.getDefinition()).reconcileReferences(true);
                }
            });
        }
        catch (InterruptedException interruptedException) {}
        if (this.getModel() instanceof DefinitionImpl) {
            ((DefinitionImpl)this.getModel()).reconcileReferences(true);
        }
    }

    public static void triggerBuild() {
        if (ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(WSDLEditorPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow(), 10).run();
        }
    }
}

