/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaGeneratorContainer
extends AbstractJavaContextModel<JavaGeneratorContainer.Parent>
implements JavaGeneratorContainer {
    protected JavaSequenceGenerator sequenceGenerator = this.buildSequenceGenerator();
    protected JavaTableGenerator tableGenerator = this.buildTableGenerator();

    public GenericJavaGeneratorContainer(JavaGeneratorContainer.Parent parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.syncSequenceGenerator(monitor);
        this.syncTableGenerator(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        if (this.sequenceGenerator != null) {
            this.sequenceGenerator.update(monitor);
        }
        if (this.tableGenerator != null) {
            this.tableGenerator.update(monitor);
        }
    }

    @Override
    public JavaSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    @Override
    public JavaSequenceGenerator addSequenceGenerator() {
        if (this.sequenceGenerator != null) {
            throw new IllegalStateException("sequence generator already exists: " + this.sequenceGenerator);
        }
        SequenceGeneratorAnnotation annotation = this.buildSequenceGeneratorAnnotation();
        JavaSequenceGenerator generator = this.buildSequenceGenerator(annotation);
        this.setSequenceGenerator(generator);
        return generator;
    }

    protected SequenceGeneratorAnnotation buildSequenceGeneratorAnnotation() {
        return (SequenceGeneratorAnnotation)((JavaGeneratorContainer.Parent)this.parent).getResourceAnnotatedElement().addAnnotation("javax.persistence.SequenceGenerator");
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.sequenceGenerator == null) {
            throw new IllegalStateException("sequence generator does not exist");
        }
        ((JavaGeneratorContainer.Parent)this.parent).getResourceAnnotatedElement().removeAnnotation("javax.persistence.SequenceGenerator");
        this.setSequenceGenerator(null);
    }

    protected JavaSequenceGenerator buildSequenceGenerator() {
        SequenceGeneratorAnnotation annotation = this.getSequenceGeneratorAnnotation();
        return annotation == null ? null : this.buildSequenceGenerator(annotation);
    }

    protected SequenceGeneratorAnnotation getSequenceGeneratorAnnotation() {
        return (SequenceGeneratorAnnotation)((JavaGeneratorContainer.Parent)this.parent).getResourceAnnotatedElement().getAnnotation("javax.persistence.SequenceGenerator");
    }

    protected JavaSequenceGenerator buildSequenceGenerator(SequenceGeneratorAnnotation sequenceGeneratorAnnotation) {
        return ((JavaGeneratorContainer.Parent)this.parent).supportsGenerators() ? this.getJpaFactory().buildJavaSequenceGenerator(this, sequenceGeneratorAnnotation) : null;
    }

    protected void syncSequenceGenerator(IProgressMonitor monitor) {
        SequenceGeneratorAnnotation annotation = this.getSequenceGeneratorAnnotation();
        if (annotation == null) {
            if (this.sequenceGenerator != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.sequenceGenerator != null && this.sequenceGenerator.getGeneratorAnnotation() == annotation) {
            this.sequenceGenerator.synchronizeWithResourceModel(monitor);
        } else {
            this.setSequenceGenerator(this.buildSequenceGenerator(annotation));
        }
    }

    protected void setSequenceGenerator(JavaSequenceGenerator sequenceGenerator) {
        JavaSequenceGenerator old = this.sequenceGenerator;
        this.sequenceGenerator = sequenceGenerator;
        this.firePropertyChanged("sequenceGenerator", old, sequenceGenerator);
    }

    @Override
    public JavaTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    @Override
    public JavaTableGenerator addTableGenerator() {
        if (this.tableGenerator != null) {
            throw new IllegalStateException("table generator already exists: " + this.tableGenerator);
        }
        TableGeneratorAnnotation annotation = this.buildTableGeneratorAnnotation();
        JavaTableGenerator generator = this.buildTableGenerator(annotation);
        this.setTableGenerator(generator);
        return generator;
    }

    protected TableGeneratorAnnotation buildTableGeneratorAnnotation() {
        return (TableGeneratorAnnotation)((JavaGeneratorContainer.Parent)this.parent).getResourceAnnotatedElement().addAnnotation("javax.persistence.TableGenerator");
    }

    @Override
    public void removeTableGenerator() {
        if (this.tableGenerator == null) {
            throw new IllegalStateException("table generator does not exist");
        }
        ((JavaGeneratorContainer.Parent)this.parent).getResourceAnnotatedElement().removeAnnotation("javax.persistence.TableGenerator");
        this.setTableGenerator(null);
    }

    protected JavaTableGenerator buildTableGenerator() {
        TableGeneratorAnnotation annotation = this.getTableGeneratorAnnotation();
        return annotation == null ? null : this.buildTableGenerator(annotation);
    }

    protected TableGeneratorAnnotation getTableGeneratorAnnotation() {
        return (TableGeneratorAnnotation)((JavaGeneratorContainer.Parent)this.parent).getResourceAnnotatedElement().getAnnotation("javax.persistence.TableGenerator");
    }

    protected JavaTableGenerator buildTableGenerator(TableGeneratorAnnotation tableGeneratorAnnotation) {
        return ((JavaGeneratorContainer.Parent)this.parent).supportsGenerators() ? this.getJpaFactory().buildJavaTableGenerator(this, tableGeneratorAnnotation) : null;
    }

    protected void syncTableGenerator(IProgressMonitor monitor) {
        TableGeneratorAnnotation annotation = this.getTableGeneratorAnnotation();
        if (annotation == null) {
            if (this.tableGenerator != null) {
                this.setTableGenerator(null);
            }
        } else if (this.tableGenerator != null && this.tableGenerator.getGeneratorAnnotation() == annotation) {
            this.tableGenerator.synchronizeWithResourceModel(monitor);
        } else {
            this.setTableGenerator(this.buildTableGenerator(annotation));
        }
    }

    protected void setTableGenerator(JavaTableGenerator tableGenerator) {
        JavaTableGenerator old = this.tableGenerator;
        this.tableGenerator = tableGenerator;
        this.firePropertyChanged("tableGenerator", old, tableGenerator);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.tableGenerator != null && (result = this.tableGenerator.getCompletionProposals(pos)) != null) {
            return result;
        }
        if (this.sequenceGenerator != null && (result = this.sequenceGenerator.getCompletionProposals(pos)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getResourceTextRange();
        return textRange != null ? textRange : ((JavaGeneratorContainer.Parent)this.parent).getValidationTextRange();
    }

    protected TextRange getResourceTextRange() {
        return ((JavaGeneratorContainer.Parent)this.parent).getResourceAnnotatedElement().getTextRange();
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return IterableTools.removeNulls(this.getGenerators_());
    }

    protected Iterable<Generator> getGenerators_() {
        return IterableTools.iterable((Object[])new Generator[]{this.sequenceGenerator, this.tableGenerator});
    }
}

