/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.archive.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEArtifactImportOperation;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class WebComponentImportOperation
extends J2EEArtifactImportOperation {
    protected final int LINK_COMPONENTS_WORK = 10;
    protected final int LIB_FOLDER_WORK = 2;

    public WebComponentImportOperation(IDataModel model) {
        super(model);
    }

    protected int computeTotalWork() {
        int baseWork = super.computeTotalWork() + 2;
        List selectedLibs = (List)this.model.getProperty("WARImportDataModel.WEB_LIB_ARCHIVES_SELECTED");
        List libProjects = (List)this.model.getProperty("WARImportDataModel.WEB_LIB_MODELS");
        IDataModel importModel = null;
        Archive libArchive = null;
        int i = 0;
        while (libProjects != null && i < libProjects.size()) {
            importModel = (IDataModel)libProjects.get(i);
            libArchive = (Archive)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
            if (selectedLibs.contains(libArchive)) {
                baseWork += 40 + libArchive.getFiles().size();
            }
            ++i;
        }
        return baseWork;
    }

    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        super.doExecute(monitor);
        IVirtualFolder libFolder = this.virtualComponent.getRootFolder().getFolder(WebArtifactEdit.WEBLIB);
        if (!libFolder.exists()) {
            try {
                libFolder.create(1, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        } else {
            monitor.worked(2);
        }
        try {
            this.importWebLibraryProjects(monitor);
        }
        catch (InvocationTargetException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        catch (InterruptedException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    private void importWebLibraryProjects(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, ExecutionException {
        List selectedLibs = (List)this.model.getProperty("WARImportDataModel.WEB_LIB_ARCHIVES_SELECTED");
        List libProjects = (List)this.model.getProperty("WARImportDataModel.WEB_LIB_MODELS");
        IDataModel importModel = null;
        IVirtualComponent nestedComponent = null;
        Archive libArchive = null;
        ArrayList<IVirtualComponent> targetComponents = new ArrayList<IVirtualComponent>();
        HashMap<IVirtualComponent, String> compToURIMap = new HashMap<IVirtualComponent, String>();
        int i = 0;
        while (libProjects != null && i < libProjects.size()) {
            importModel = (IDataModel)libProjects.get(i);
            libArchive = (Archive)importModel.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
            if (selectedLibs.contains(libArchive)) {
                importModel.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor(monitor, 30 + libArchive.getFiles().size()), this.info);
                nestedComponent = (IVirtualComponent)importModel.getProperty("IJ2EEComponentImportDataModelProperties.COMPONENT");
                targetComponents.add(nestedComponent);
                String archiveURI = libArchive.getURI();
                int lastIndex = archiveURI.lastIndexOf(47);
                if (-1 != lastIndex && lastIndex + 1 < archiveURI.length()) {
                    archiveURI = archiveURI.substring(++lastIndex);
                }
                compToURIMap.put(nestedComponent, archiveURI);
            }
            ++i;
        }
        if (targetComponents.size() > 0) {
            IDataModel createRefComponentsModel = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
            createRefComponentsModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.virtualComponent);
            createRefComponentsModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)"/WEB-INF/lib/");
            createRefComponentsModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", targetComponents);
            createRefComponentsModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", compToURIMap);
            createRefComponentsModel.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor(monitor, 10 * targetComponents.size()), this.info);
        }
    }

    protected SaveStrategy createSaveStrategy(IVirtualComponent aVirtualComponent) {
        return new WebComponentSaveStrategyImpl(aVirtualComponent);
    }
}

