/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMAccessibleObjectProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

final class REMMethodProxy
extends REMAccessibleObjectProxy
implements IREMMethodProxy {
    private IBeanTypeProxy fDeclaringType;
    private String fMethodName;
    private IBeanTypeProxy[] fParameterTypes;
    private IBeanTypeProxy fReturnType;

    REMMethodProxy(REMProxyFactoryRegistry aRegistry, Integer anID) {
        super(aRegistry, anID);
    }

    public IBeanTypeProxy getClassType() {
        if (this.fDeclaringType == null) {
            this.fDeclaringType = (IBeanTypeProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodDeclaringClassMessage().invokeCatchThrowableExceptions(this);
        }
        return this.fDeclaringType;
    }

    public String getName() {
        if (this.fMethodName == null) {
            IStringBeanProxy proxy = (IStringBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodMethodNameMessage().invokeCatchThrowableExceptions(this);
            this.fMethodName = proxy != null ? proxy.stringValue() : "";
        }
        return this.fMethodName;
    }

    public synchronized IBeanTypeProxy[] getParameterTypes() {
        if (this.fParameterTypes == null) {
            IArrayBeanProxy parmTypes = (IArrayBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodParameterTypesMessage().invokeCatchThrowableExceptions(this);
            if (parmTypes == null) {
                this.fParameterTypes = new IBeanTypeProxy[0];
            } else {
                int len = parmTypes.getLength();
                this.fParameterTypes = new IBeanTypeProxy[len];
                int i = 0;
                while (i < len) {
                    try {
                        this.fParameterTypes[i] = (IBeanTypeProxy)parmTypes.get(i);
                    }
                    catch (ThrowableProxy throwableProxy) {}
                    ++i;
                }
                this.fFactory.releaseProxy(parmTypes);
            }
        }
        return this.fParameterTypes;
    }

    public IBeanTypeProxy getReturnType() {
        if (this.fReturnType == null) {
            this.fReturnType = (IBeanTypeProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodReturnTypeMessage().invokeCatchThrowableExceptions(this);
        }
        return this.fReturnType;
    }

    public IBeanProxy invoke(IBeanProxy subject) throws ThrowableProxy {
        return this.invoke(subject, (IBeanProxy[])null);
    }

    public IBeanProxy invoke(IBeanProxy subject, IBeanProxy[] parms) throws ThrowableProxy {
        return this.invokeWithParms(subject, parms);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBeanProxy invokeWithParms(IBeanProxy subject, Object[] parms) throws ThrowableProxy {
        connect = this.fFactory.getFreeConnection();
        proxyFactory = (REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory();
        proxyFactory.startTransaction();
        try {
            subjectValue = new Commands.ValueObject();
            if (subject != null) {
                ((IREMBeanProxy)subject).renderBean(subjectValue);
            }
            parmsValue = new Commands.ValueObject();
            retriever = null;
            if (parms != null) {
                retriever = new .Retriever(this, parms);
                parmsValue.setArrayIDS(retriever, parms.length, 23);
            }
            returnValue = new Commands.ValueObject();
            try {
                this.invoke(connect, proxyFactory, subjectValue, parmsValue, returnValue);
                var13_9 = proxyFactory.getBeanProxy(returnValue);
                ** GOTO lbl42
            }
            catch (CommandException e) {
                block11: {
                    if (!e.isRecoverable()) {
                        this.fFactory.closeConnection(connect);
                        connect = null;
                        connect = this.fFactory.getFreeConnection();
                        try {
                            if (retriever != null) {
                                retriever.reset();
                            }
                            this.invoke(connect, proxyFactory, subjectValue, parmsValue, returnValue);
                            var13_10 = proxyFactory.getBeanProxy(returnValue);
                        }
                        catch (CommandException eAgain) {
                            this.fFactory.closeConnection(connect);
                            connect = null;
                            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)eAgain));
lbl35:
                            // 2 sources

                            while (true) {
                                var11_13 = null;
                                proxyFactory.stopTransaction();
                                if (connect == null) return null;
                                this.fFactory.returnConnection(connect);
                                return null;
                            }
                        }
                    }
                    break block11;
lbl42:
                    // 1 sources

                    var11_11 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return var13_9;
                    this.fFactory.returnConnection(connect);
                    return var13_9;
                    var11_12 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return var13_10;
                    this.fFactory.returnConnection(connect);
                    return var13_10;
                }
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                ** continue;
            }
        }
        catch (Throwable var12_17) {
            var11_14 = null;
            proxyFactory.stopTransaction();
            if (connect == null) throw var12_17;
            this.fFactory.returnConnection(connect);
            throw var12_17;
        }
    }

    private void invoke(IREMConnection connect, REMStandardBeanProxyFactory proxyFactory, Commands.ValueObject subjectValue, Commands.ValueObject parmsValue, Commands.ValueObject returnValue) throws ThrowableProxy, CommandException {
        try {
            connect.invokeMethod(this.getID(), subjectValue, parmsValue, returnValue);
        }
        catch (CommandErrorException e) {
            proxyFactory.processErrorReturn(e);
        }
    }

    public IBeanProxy invoke(IBeanProxy subject, IBeanProxy parm) throws ThrowableProxy {
        return this.invoke(subject, new IBeanProxy[]{parm});
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject) {
        try {
            return this.invoke(subject);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy(e);
            return null;
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject, IBeanProxy[] parms) {
        try {
            return this.invoke(subject, parms);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy(e);
            return null;
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject, IBeanProxy parm) {
        try {
            return this.invoke(subject, parm);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy(e);
            return null;
        }
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((REMMethodProxyFactory)this.fFactory.getMethodProxyFactory()).methodType;
    }

    public void release() {
        this.fDeclaringType = null;
        this.fParameterTypes = null;
        this.fReturnType = null;
        super.release();
    }
}

