1;

## offset until carrier tracking PLL has settled
global _offset_ = 0;
global _dir_ = "."

function rp (n)
  global _offset_;
  global _dir_;
  name = sprintf ("%s/m%d", _dir_, n);
  out=read_float_binary (name, 100e3 + _offset_);
  x = out(_offset_+1:length(out)-_offset_);
  plot (x(1:5000),'@');
endfunction

function rpe (n)
  global _offset_;
  global _dir_;
  name = sprintf ("%s/m%d", _dir_, n);
  out=read_float_binary (name, 100e3+_offset_);
  x = out(_offset_+1:length(out)-_offset_);
  plot (x(40000:44999),'@');
endfunction

function npe (n)
  global _offset_;
  global _dir_;
  name = sprintf ("/home/eb/tmp/atsc/m%d", n);
  out=read_float_binary (name, 100e3+_offset_);
  x = out(_offset_+1:length(out)-_offset_);
  plot (x(40000:44999),'@');
endfunction

function v = loadloop (n, count)
  global _offset_;
  global _dir_;
  if ((m = nargchk (1, 2, nargin)))
    usage (m);
  endif;
  if (nargin < 2)
    count = Inf;
  endif;

  name = sprintf ("%s/loop%d", _dir_, n);
  f = fopen (name, "r");
  if (f < 0)
    error ("can't open: %s", name);
  endif
  
  t = fread (f, [8, count+_offset_], "float");
  v = t(:,_offset_+1:length(t)-_offset_);
  fclose (f);
endfunction

function v = loadps (n, count)
  global _offset_;
  global _dir_;
  if ((m = nargchk (1, 2, nargin)))
    usage (m);
  endif;
  if (nargin < 2)
    count = Inf;
  endif;

  name = sprintf ("%s/ps%d", _dir_, n);
  f = fopen (name, "r");
  if (f < 0)
    error ("can't open: %s", name);
  endif
  
  t = fread (f, [4, count+_offset_], "float");
  v = t(:,_offset_+1:length(t)-_offset_);
  fclose (f);
endfunction

function v = loadfpll (n, count)
  global _offset_;
  global _dir_;
  if ((m = nargchk (1, 2, nargin)))
    usage (m);
  endif;
  if (nargin < 2)
    count = Inf;
  endif;

  name = sprintf ("/tmp/fpll%d", n);
  f = fopen (name, "r");
  if (f < 0)
    error ("can't open: %s", name);
  endif
  
  t = fread (f, [8, count+_offset_], "float");
  v = t(:,_offset_+1:length(t)-_offset_);
  fclose (f);
endfunction


function loadloops()
  global loop0
  global loop1
  global loop2
  global loop3
  global loop4
  global loop5
  global loop6
  global loop7
  global loop8
  global loop9
  global loop10

  loop0 = loadloop (0, 100e3);
  loop1 = loadloop (1, 100e3);
  loop2 = loadloop (2, 100e3);
  loop3 = loadloop (3, 100e3);
  loop4 = loadloop (4, 100e3);
  loop5 = loadloop (5, 100e3);
  loop6 = loadloop (6, 100e3);
  loop7 = loadloop (7, 100e3);
  loop8 = loadloop (8, 100e3);
  loop9 = loadloop (9, 100e3);
  loop10 = loadloop (10, 100e3);

endfunction

function loadpss()
  global ps0
  global ps1
  global ps2
  global ps3
  global ps4
  global ps5
  global ps6
  global ps7
  global ps8
  global ps9
  global ps10

  ps0 = loadps (0, 100e3);
  ps1 = loadps (1, 100e3);
  ps2 = loadps (2, 100e3);
  ps3 = loadps (3, 100e3);
  ps4 = loadps (4, 100e3);
  ps5 = loadps (5, 100e3);
  ps6 = loadps (6, 100e3);
  ps7 = loadps (7, 100e3);
  ps8 = loadps (8, 100e3);
  ps9 = loadps (9, 100e3);
  ps10 = loadps (10, 100e3);

endfunction

function loadfplls()
  global fpll0
  len = 250e3;
  fpll0 = loadfpll (0, len);

endfunction

function timing = loopstuff()
  global loop0
  global loop1
  global loop2
  global loop3
  global loop4
  global loop5
  global loop6
  global loop7
  global loop8
  global loop9
  global loop10

  t = zeros (11,1);
  t(1) = mean(loop0(4,:));
  t(2) = mean(loop1(4,:));
  t(3) = mean(loop2(4,:));
  t(4) = mean(loop3(4,:));
  t(5) = mean(loop4(4,:));
  t(6) = mean(loop5(4,:));
  t(7) = mean(loop6(4,:));
  t(8) = mean(loop7(4,:));
  t(9) = mean(loop8(4,:));
  t(10) = mean(loop9(4,:));
  t(11) = mean(loop10(4,:));
  timing = t;
endfunction

function timing = loopfct(f)
  global loop0
  global loop1
  global loop2
  global loop3
  global loop4
  global loop5
  global loop6
  global loop7
  global loop8
  global loop9
  global loop10
  t = zeros (11,1);
  t(1) = mean(feval (f, loop0));
  t(2) = mean(feval (f, loop1));
  t(3) = mean(feval (f, loop2));
  t(4) = mean(feval (f, loop3));
  t(5) = mean(feval (f, loop4));
  t(6) = mean(feval (f, loop5));
  t(7) = mean(feval (f, loop6));
  t(8) = mean(feval (f, loop7));
  t(9) = mean(feval (f, loop8));
  t(10) = mean(feval (f, loop9));
  t(11) = mean(feval (f, loop10));
  timing = t;
endfunction


function te = tf1 (loopx)
  te = (loopx(3,:) - loopx(1,:)).* loopx(2,:);
endfunction

function te = m2l (loopx)
  te = (loopx(2,:) ./ loopx(1,:));
endfunction

function te = m2r (loopx)
  te = (loopx(2,:) ./ loopx(3,:));
endfunction

function te = abs_m2l (loopx)
  te = abs ((loopx(2,:) ./ loopx(1,:)));
endfunction

function te = abs_m2r (loopx)
  te = abs ((loopx(2,:) ./ loopx(3,:)));
endfunction

function te = tf2 (loopx)
  p1 = abs (loopx(2,:)) < ((abs (loopx(1,:)) + abs (loopx(3,:))) * 8);
  sum (p1)
  p2 = abs (loopx(1,:)) < abs (loopx(3,:));
  left  =   ones (1, length (loopx));
  right =  -ones (1, length (loopx));
  other = (loopx(3,:) - loopx(1,:)) .* loopx(2,:);

  ## te = ((p1 .* ((p2 .* left) + (!p2 .* right))) + (!p1 .* other));
  ## te = ((p1 .* ((p2 .* left) + (!p2 .* right))) + (!p1 .* 10));
  te = ((p1 .* ((p2 .* left) + (!p2 .* right))));

endfunction

function s = runsum (v)
  o = zeros (1, length(v));
  o(1) = v(1);
  for i = 2:length(v)
    o(i) = o(i-1) + v(i);
  endfor
  s = o;
endfunction

function s = runmean (v)
  o = runsum (v);
  s = o ./ (1:length(v));
endfunction

function s = quantmu (v)
  nsteps = 64;
  inv_nsteps = 1.0 / nsteps;
  s = round (v .* nsteps) .* inv_nsteps;
endfunction


function v = nloadloop (n, count)
  global _offset_;
  if ((m = nargchk (1, 2, nargin)))
    usage (m);
  endif;
  if (nargin < 2)
    count = Inf;
  endif;

  name = sprintf ("/home/eb/tmp/atsc/loop%d", n);
  f = fopen (name, "r");
  if (f < 0)
    error ("can't open: %s", name);
  endif
  
  t = fread (f, [8, count+_offset_], "float");
  v = t(:,_offset_+1:length(t)-_offset_);
  fclose (f);
endfunction

function v = bestloop
  x = zeros(1,360);
  for i = 0:359
    t = nloadloop (i, 100e3);
    tt = t(2,:);
    x(i+1) = sum (abs (abs (tt) - 5));
  endfor
  v = x;
endfunction

function v = loadsssr (count)
  global _offset_;
  global _dir_;
  if ((m = nargchk (0, 1, nargin)))
    usage (m);
  endif;
  if (nargin < 1)
    count = Inf;
  endif;

  name = "sssr.ssout";
  f = fopen (name, "r");
  if (f < 0)
    error ("can't open: %s", name);
  endif
  
  t = fread (f, [7, count+_offset_], "float");
  v = t(:,_offset_+1:length(t)-_offset_);
  fclose (f);
endfunction

function v = loadinterp (count)
  global _offset_;
  global _dir_;
  if ((m = nargchk (0, 1, nargin)))
    usage (m);
  endif;
  if (nargin < 1)
    count = Inf;
  endif;

  name = "interp.ssout";
  f = fopen (name, "r");
  if (f < 0)
    error ("can't open: %s", name);
  endif
  
  t = fread (f, [6, count+_offset_], "float");
  v = t(:,_offset_+1:length(t)-_offset_);
  fclose (f);
endfunction
