/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <GrFileDescriptorSink.h>
#include <unistd.h>
#include <errno.h>
#include <stdexcept>


GrFileDescriptorSink::GrFileDescriptorSink (size_t itemsize, int file_descriptor)
  : GrSink (itemsize), d_itemsize (itemsize), d_fd (file_descriptor)
{
}

GrFileDescriptorSink::~GrFileDescriptorSink ()
{
  close (d_fd);
}

int
GrFileDescriptorSink::work3 (VrSampleRange output,
			     VrSampleRange inputs[], void *i[])
{
  sync (output.index);		// force in-order execution

  if (getNumberInputs () != 1){
    throw std::runtime_error ("GrFileDescriptorSink: number of inputs must be 1");
  }
  
  char *inbuf = ((char **)i)[0];
  unsigned long	byte_size = output.size * d_itemsize;

  while (byte_size > 0){
    ssize_t	r;

    r = write (d_fd, inbuf, byte_size);
    if (r == -1){
      if (errno == EINTR)
	continue;
      else {
	perror ("GrFileDescriptorSink");
	throw std::runtime_error ("GrFileDescriptorSink: write");
      }
    }
    else {
      byte_size -= r;
      inbuf += r;
    }
  }
  return output.size;
}
