#!/usr/bin/python

import sys
sys.path.append ('.')
sys.path.append ('/usr/local/gnuradio/python')

import GnuRadio
from math import pi

#modes = [ "USB","LSB","CW","AM","FM" ]

class rig(GnuRadio.gr_FlowGraph):
    """Build Field Day flow graph"""
    radio=GnuRadio.sdr_1000()

    def change_filt(self):
        self.channel_coeffs = GnuRadio.gr_firdes_low_pass (1.0,          # gain
                                                      self.sampling_freq,   # sampling rate
                                                      self.bw/2,        # low pass cutoff freq
                                                      300,      # width of trans. band
                                                      GnuRadio.gr_firdes.WIN_HAMMING)

    def __init__(self):
        GnuRadio.gr_FlowGraph.__init__(self)
        self.if_freq = -10000
        self.sampling_freq = 48000
        self.mode = "AM"

        self.srcRX = GnuRadio.GrAudioSourceC (self.sampling_freq, 1, 1, "/dev/dsp1")

        if(self.mode == "AM"):
            self.bw = 6000
            self.change_filt()
            self.centerfreq = self.if_freq
            self.demod = GnuRadio.GrMagnitudeCF()

        if(self.mode == "LSB"):
            self.low_cutoff = 300
            self.high_cutoff = 2700
            self.bw = self.high_cutoff - self.low_cutoff
            self.centerfreq = self.if_freq - self.low_cutoff - self.bw/2
            self.demod = GnuRadio.GrSSBModCF(-2*pi*(self.low_cutoff+self.bw/2)/self.sampling_freq,1)

        if(self.mode == "USB"):
            self.low_cutoff = 300
            self.high_cutoff = 2700
            self.bw = self.high_cutoff - self.low_cutoff
            self.centerfreq = self.if_freq + self.low_cutoff + self.bw/2
            self.demod = GnuRadio.GrSSBModCF(2*pi*(self.low_cutoff+self.bw/2)/self.sampling_freq,1)

        self.change_filt()
        self.mixer = GnuRadio.GrFreqXlatingFIRfilterCCF (1, self.channel_coeffs,self.centerfreq)

        self.gainstage = GnuRadio.VrAmpFF(1)
        self.sinkRX = GnuRadio.GrAudioSinkF (1, "/dev/dsp")

        self.connect(self.srcRX,self.mixer)
        self.connect(self.mixer,self.demod)
        self.connect(self.demod,self.gainstage)
        self.connect(self.gainstage,self.sinkRX)

        # TX
        #        self.srcTX = GnuRadio.GrAudioSourceF (sampling_freq, 1, 1, "/dev/dsp")
        #        self.make_complex = GnuRadio.GrHilbertFC(63)
        #        self.ssbmod = GnuRadio.GrSSBModCF
        #        self.sinkTX = GnuRadio.GrAudioSinkC (1, "/dev/dsp")
        
        #        self.ssbdemod = GnuRadio.GrSSBModCF(0,1)
        #        self.ssbdemod = GnuRadio.GrMagnitudeCF()


    def set_mode(self,mode):
        pass
        
    def set_freq(self,newfreq):
        self.radio.set_freq(newfreq-self.if_freq)

    def set_bpf(self,lp,hp):
        print "BPF setting"

    def set_volume(self,gain):
        self.gainstage.setGain(10**(gain/20))



if(__name__ == "__main__"):
    myflowgraph = rig()
    myflowgraph.start()
    raw_input('Press Enter to quit')
    myflowgraph.stop()

