/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRAR5000SOURCE_H_
#define _VRAR5000SOURCE_H_

extern "C" {
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
}

#include <VrSource.h>
#include <VrGuppiSource.h>

template<class oType> 
class VrAR5000Source: public VrGuppiSource<oType> {
protected:
  int serialfd;
  int rxFrequency;
public:
  void on() {write(serialfd, "X\r\n",3); sleep(2);}
  void off() {write(serialfd, "QP\r\n",4);}
  void setRxFrequency(float f);
  VrAR5000Source(double sampling_freq);
  virtual ~VrAR5000Source();  
};

template<class oType> void
VrAR5000Source<oType>::setRxFrequency(float f)
{
  char cmd[20];
  int len;

  sprintf(cmd, "RF%f\r\n", f);
  len = strlen(cmd);
  if ((write(serialfd,cmd,len)) < 0) {
    fprintf(stderr, "write to serial port returned errno %d\n", errno);
  }
  return;
}


template<class oType> 
VrAR5000Source<oType>::VrAR5000Source(double sampling_freq)
  :VrGuppiSource<oType>(sampling_freq)
{
  if ((serialfd = open("/dev/ttyS1", O_RDWR)) < 0) {
    fprintf(stderr, "Error openeing serial port, errno %d\n", errno);
    exit(1);
  }
  on();
}

template<class oType>
VrAR5000Source<oType>::~VrAR5000Source()
{
  off();
  close(serialfd);
}

#endif
