/* -*- Mode: c++ -*- 
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VrSQUELCH_H_
#define _VrSQUELCH_H_

#include <VrHistoryProc.h>

template<class T>
class VrSquelch : public VrHistoryProc<T, T>
{
protected:
  float thresh;
  float duration;

  bool squelching;
  int bufferCount;

  T *zeroBuf;
  
public:
  VrSquelch(float th, float d) : 
    thresh(th), duration(d), squelching(false), bufferCount(0) {}

  virtual void work(timestamp ts, unsigned int size, T *i[], T *o[]);
  virtual void initialize()
    {
      int h= ((int)(duration*getInputSamplingFrequencyN(0)));
      history=h;
      setOutputSize (h);
      zeroBuf = new T[h];
      for(int i=0;i<h;i++) zeroBuf[i]=0;
    }
  void setThresh(float th) { thresh = th; }
  float getThresh() { return thresh; }
  void setDuration(float d) 
    { 
      duration = d;
      delete[] zeroBuf;
      int h = (int)(duration*getInputSamplingFrequencyN(0));
      history=h;
      setOutputSize (h);
      zeroBuf = new T[h];
    }
  float getDuration() { return duration; }
};

template<class T>
void
VrSquelch<T>::work(timestamp ts, unsigned int size, T *i[], T *o[])
{
  while (size > 0)
    {
      float total = 0;
      T *buf=i[0];
      for (unsigned int ii=0; ii<history; ii++)
	{
	  total += abs(buf[ii]);
	}
      if (squelching)
	{
	  if (total/history > thresh)
	    {
	      squelching = false;
	      bufferCount = 0;
	      memcpy(o[0],buf,history*sizeof(T));
	    }
	  else
	    memcpy(o[0],zeroBuf,history*sizeof(T));
	}
      else 
	{
	  if (total/history < thresh)
	    bufferCount++;
	  if (bufferCount > 2)
	    {
	      squelching = true;
	      memcpy(o[0],zeroBuf,history*sizeof(T));
	    }
	  else
	    memcpy(o[0],buf,history*sizeof(T));
	}
      size -= history;
      i[0]+=history;
      o[0]+=history;
    }
}

#endif
