#ifndef _AMFMRECEIVER_H_
#define _AMFMRECEIVER_H_

#include <qwidget.h>
#include <VrTypes.h>

class QLabel;
class QLCDNumber;
class QButtonGroup;
class QButton;
class QPushButton;
class QString;
class QDoubleValidator;
class Tuner;

template<class oType> class VrAR5000Source;
template<class iType> class VrComplexFIRfilter;
template<class oType> class VrQuadratureDemod;
template<class oType> class VrAmplitudeDemod;
template<class iType,class oType> class VrRealFIRfilter;
template<class iType> class VrAudioSink;

class AMFMReceiver : public QWidget
{
  Q_OBJECT

public:
  AMFMReceiver(VrAR5000Source<char> *source, 
	       QWidget *p = 0, const char *name = 0);
  ~AMFMReceiver();
  
private:
  VrAR5000Source<char> *source;
  VrComplexFIRfilter<char> *chanFilter;
  VrQuadratureDemod<float> *FMdemod;
  VrAmplitudeDemod<float> *AMdemod;
  VrRealFIRfilter<float,short> *ifFilter;
  VrAudioSink<short> *audio;

  QButton *tuneup;
  QButton *tunedown;
  QLCDNumber *LCDFreq;
  QButtonGroup *presets;
  QPushButton *modeButton;
  QLabel *modeLabel;
  QPushButton *memButton;
  
  int savedSF;

  bool savePreset;
  int presetFMChannel[6];
  int presetAMChannel[6];
  void updateFreq();
  enum { AM, FM } mode;
  int volume;

  Tuner *fmtuner;
  Tuner *amtuner;
  Tuner *tuner;
  int *presetChannel;

private slots:
  void memToggled(bool on);
  void presetClicked(int id);
  void changeMode();
  void channelChanged(int channel);
  void incVolume();
  void decVolume();
  void run();
  
};

#endif


