/* -*- c++ -*- */
/*
 * Copyright 2005 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <usrp_prims.h>
#include <usrp_daughterboards.h>
#include <stdio.h>

#define NELEM(x) sizeof(x)/sizeof(x[0])

static struct {
  unsigned short	dbid;
  const char	       *name;
} dbid_map[] = {
  { USRP_DBID_BASIC_TX,		"Basic Tx" },
  { USRP_DBID_BASIC_RX,		"Basic Rx" },
  { USRP_DBID_EXPERIMENTAL_TX,	"Experimental Tx" },
  { USRP_DBID_EXPERIMENTAL_RX,	"Experimental Rx" }
};

const std::string
usrp_dbid_to_string (unsigned short dbid)
{
  for (unsigned i = 0; i < NELEM (dbid_map); i++)
    if (dbid == dbid_map[i].dbid)
      return dbid_map[i].name;

  char tmp[64];
  snprintf (tmp, sizeof (tmp), "Unknown (0x%04x)", dbid);
  return tmp;
}
