/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.HeadingMap;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Misc;

public class InlineConverter
extends ConverterHelper {
    private boolean bIncludeOriginalCitations = false;
    private String sTabstop = "\\ \\ ";
    private boolean bHasPdfannotation = false;

    public InlineConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.bIncludeOriginalCitations = config.includeOriginalCitations();
        if (config.getTabstop().length() > 0) {
            this.sTabstop = config.getTabstop();
        }
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bHasPdfannotation) {
            decl.append("\\newcommand\\pdfannotation[1]").append("{\\ifx\\pdfoutput\\undefined\\marginpar{#1}\\else").append("\\pdfstringdef\\tempstring{#1}\\marginpar{").append("\\pdfannot width 5cm height 12pt depth 4cm ").append("{ /Subtype /Text /Open false /Contents(\\tempstring) /Color [1 0 0]}").append("}\\fi}").nl();
        }
    }

    public void handleTextSpan(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (oc.isMathMode()) {
            this.handleTextSpanMath(node, ldp, oc);
        } else {
            this.handleTextSpanText(node, ldp, oc);
        }
    }

    private void handleTextSpanMath(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sPos;
        String sStyleName = node.getAttribute("text:style-name");
        StyleWithProperties style = this.ofr.getTextStyle(sStyleName);
        this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(style));
        BeforeAfter ba = new BeforeAfter();
        if (style != null && (sPos = style.getProperty("style:text-position", true)) != null) {
            if (sPos.startsWith("sub") || sPos.startsWith("-")) {
                ba.add("_{", "}");
            } else if (sPos.startsWith("super") || !sPos.startsWith("0%")) {
                ba.add("^{", "}");
            }
        }
        ldp.append(ba.getBefore());
        this.traverseInlineMath(node, ldp, oc);
        ldp.append(ba.getAfter());
        this.palette.getI18n().popSpecialTable();
    }

    private void handleTextSpanText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String styleName = node.getAttribute("text:style-name");
        String sDisplayName = this.ofr.getTextStyles().getDisplayName(styleName);
        if (this.config.otherStyles() != 1 && !this.config.getTextStyleMap().contains(sDisplayName)) {
            if (this.config.otherStyles() == 2) {
                System.err.println("Warning: Text with style " + sDisplayName + " was ignored");
            } else if (this.config.otherStyles() == 3) {
                ldp.append("% Error in source document: Text with style ").append(this.palette.getI18n().convert(sDisplayName, false, oc.getLang())).append(" was ignored").nl();
            }
            return;
        }
        boolean styled = true;
        if (this.onlyNote(node) || OfficeReader.getCharacterCount(node) == 0) {
            styled = false;
        }
        if (oc.isVerbatim()) {
            styled = false;
        }
        boolean bNoFootnotes = false;
        this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(this.ofr.getTextStyle(styleName)));
        BeforeAfter ba = new BeforeAfter();
        Context ic = (Context)oc.clone();
        if (styled) {
            this.palette.getCharSc().applyTextStyle(styleName, ba, ic);
        }
        if (styled && !ic.isInFootnote()) {
            bNoFootnotes = true;
        }
        StyleWithProperties style = this.ofr.getTextStyle(styleName);
        if (this.ofr.isPackageFormat() && style != null && style.isAutomatic() && ic.isInHeaderFooter()) {
            styled = false;
        }
        if (styled) {
            if (bNoFootnotes) {
                ic.setNoFootnotes(true);
            }
            ldp.append(ba.getBefore());
        }
        this.traverseInlineText(node, ldp, ic);
        if (styled) {
            ldp.append(ba.getAfter());
            ic.setNoFootnotes(false);
            if (!ic.isInFootnote()) {
                this.palette.getNoteCv().flushFootnotes(ldp, oc);
            }
        }
        this.palette.getFieldCv().flushReferenceMarks(ldp, oc);
        this.palette.getIndexCv().flushIndexMarks(ldp, oc);
        this.palette.getI18n().popSpecialTable();
    }

    public void traverseInlineText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (oc.isVerbatim()) {
            this.traverseVerbatimInlineText(node, ldp, oc);
        } else if (oc.isMathMode()) {
            this.traverseInlineMath(node, ldp, oc);
        } else {
            this.traverseOrdinaryInlineText(node, ldp, oc);
        }
    }

    private void traverseOrdinaryInlineText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        block4: for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            short nodeType = childNode.getNodeType();
            switch (nodeType) {
                case 3: {
                    String s = childNode.getNodeValue();
                    if (s.length() <= 0) continue block4;
                    if (oc.isInZoteroJabRefText()) {
                        if (!this.bIncludeOriginalCitations) continue block4;
                        ldp.append("%").append(this.palette.getI18n().convert(s, false, oc.getLang())).nl();
                        continue block4;
                    }
                    ldp.append(this.palette.getI18n().convert(s, false, oc.getLang()));
                    continue block4;
                }
                case 1: {
                    Element child = (Element)childNode;
                    String sName = child.getTagName();
                    if (sName.equals("text:span")) {
                        String sStyleName = child.getAttribute("text:style-name");
                        boolean bIsMathSpan = "OOoLaTeX".equals(this.ofr.getTextStyles().getDisplayName(sStyleName));
                        if (bIsMathSpan) {
                            Node remember;
                            Context ic = (Context)oc.clone();
                            ic.setMathMode(true);
                            ldp.append("$");
                            boolean bContinue = false;
                            do {
                                this.handleTextSpanMath((Element)childNode, ldp, ic);
                                remember = childNode;
                                childNode = childNode.getNextSibling();
                                bContinue = false;
                                if (childNode == null || childNode.getNodeType() != 1 || !childNode.getNodeName().equals("text:span")) continue;
                                sStyleName = Misc.getAttribute(childNode, "text:style-name");
                                if (!"OOoLaTeX".equals(this.ofr.getTextStyles().getDisplayName(sStyleName))) continue;
                                bContinue = true;
                            } while (bContinue);
                            childNode = remember;
                            ldp.append("$");
                            continue block4;
                        }
                        this.handleTextSpan(child, ldp, oc);
                        continue block4;
                    }
                    if (child.getNodeName().startsWith("draw:")) {
                        this.palette.getDrawCv().handleDrawElement(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:s")) {
                        if (this.config.ignoreDoubleSpaces()) {
                            ldp.append(" ");
                            continue block4;
                        }
                        for (int count = Misc.getPosInteger(child.getAttribute("text:c"), 1); count > 0; --count) {
                            ldp.append("\\ ");
                        }
                        continue block4;
                    }
                    if (sName.equals("text:tab-stop") || sName.equals("text:tab")) {
                        if (oc.isInHeaderFooter()) {
                            ldp.append("\\hfill ");
                            continue block4;
                        }
                        ldp.append(this.sTabstop);
                        continue block4;
                    }
                    if (sName.equals("text:line-break")) {
                        if (!oc.isInHeaderFooter() && !this.config.ignoreHardLineBreaks()) {
                            ldp.append("\\newline").nl();
                            continue block4;
                        }
                        ldp.append(" ");
                        continue block4;
                    }
                    if (sName.equals("text:a")) {
                        this.palette.getFieldCv().handleAnchor(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("office:annotation")) {
                        this.handleOfficeAnnotation(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:page-number")) {
                        this.palette.getFieldCv().handlePageNumber(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:page-count")) {
                        this.palette.getFieldCv().handlePageCount(child, ldp, oc);
                        continue block4;
                    }
                    if (oc.isInHeaderFooter()) {
                        if (sName.equals("text:chapter")) {
                            this.handleChapterField(child, ldp, oc);
                            continue block4;
                        }
                        if (!sName.startsWith("text:")) continue block4;
                        this.traverseInlineText(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:footnote")) {
                        this.palette.getNoteCv().handleFootnote(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:endnote")) {
                        this.palette.getNoteCv().handleEndnote(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:note")) {
                        if ("endnote".equals(child.getAttribute("text:note-class"))) {
                            this.palette.getNoteCv().handleEndnote(child, ldp, oc);
                            continue block4;
                        }
                        this.palette.getNoteCv().handleFootnote(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:sequence")) {
                        this.palette.getFieldCv().handleSequence(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:sequence-ref")) {
                        this.palette.getFieldCv().handleSequenceRef(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:footnote-ref")) {
                        this.palette.getNoteCv().handleFootnoteRef(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:endnote-ref")) {
                        this.palette.getNoteCv().handleEndnoteRef(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:note-ref")) {
                        this.palette.getNoteCv().handleNoteRef(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:reference-mark")) {
                        this.palette.getFieldCv().handleReferenceMark(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:reference-mark-start")) {
                        this.palette.getFieldCv().handleReferenceMark(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:reference-mark-end")) {
                        this.palette.getFieldCv().handleReferenceMarkEnd(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:reference-ref")) {
                        this.palette.getFieldCv().handleReferenceRef(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:bookmark")) {
                        this.palette.getFieldCv().handleBookmark(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:bookmark-start")) {
                        this.palette.getFieldCv().handleBookmark(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:bookmark-ref")) {
                        this.palette.getFieldCv().handleBookmarkRef(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:bibliography-mark")) {
                        this.palette.getBibCv().handleBibliographyMark(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:alphabetical-index-mark")) {
                        this.palette.getIndexCv().handleAlphabeticalIndexMark(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:alphabetical-index-mark-start")) {
                        this.palette.getIndexCv().handleAlphabeticalIndexMark(child, ldp, oc);
                        continue block4;
                    }
                    if (!sName.startsWith("text:")) continue block4;
                    this.traverseInlineText(child, ldp, oc);
                    continue block4;
                }
            }
        }
    }

    public void traversePlainInlineText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String styleName = node.getAttribute("text:style-name");
        this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(this.ofr.getTextStyle(styleName)));
        block4: for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            short nodeType = childNode.getNodeType();
            switch (nodeType) {
                case 3: {
                    String s = childNode.getNodeValue();
                    if (s.length() <= 0) continue block4;
                    for (int j = 0; j < s.length(); ++j) {
                        if (s.charAt(j) != ']') {
                            ldp.append(this.palette.getI18n().convert(Character.toString(s.charAt(j)), false, oc.getLang()));
                            continue;
                        }
                        ldp.append("{]}");
                    }
                    continue block4;
                }
                case 1: {
                    Element child = (Element)childNode;
                    String sName = child.getTagName();
                    if (sName.equals("text:span")) {
                        this.traversePlainInlineText(child, ldp, oc);
                        continue block4;
                    }
                    if (sName.equals("text:s")) {
                        for (int count = Misc.getPosInteger(child.getAttribute("text:c"), 1); count > 0; --count) {
                            ldp.append("\\ ");
                        }
                        continue block4;
                    }
                    if (sName.equals("text:tab-stop") || sName.equals("text:tab")) {
                        ldp.append(this.sTabstop);
                        continue block4;
                    }
                    if (OfficeReader.isNoteElement(child) || !OfficeReader.isTextElement(child)) continue block4;
                    this.traversePlainInlineText(child, ldp, oc);
                    continue block4;
                }
            }
        }
        this.palette.getI18n().popSpecialTable();
    }

    public void traverseInlineMath(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String styleName = node.getAttribute("text:style-name");
        this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(this.ofr.getTextStyle(styleName)));
        block4: for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            short nodeType = childNode.getNodeType();
            switch (nodeType) {
                case 3: {
                    String s = childNode.getNodeValue();
                    ldp.append(this.palette.getI18n().convert(s, true, oc.getLang()));
                    continue block4;
                }
                case 1: {
                    Element child = (Element)childNode;
                    String sName = child.getTagName();
                    if (sName.equals("text:s")) {
                        for (int count = Misc.getPosInteger(child.getAttribute("text:c"), 1); count > 0; --count) {
                            ldp.append("\\ ");
                        }
                        continue block4;
                    }
                    if (sName.equals("text:tab-stop") || sName.equals("text:tab")) {
                        ldp.append(" ");
                        continue block4;
                    }
                    if (OfficeReader.isNoteElement(child) || !OfficeReader.isTextElement(child)) continue block4;
                    this.traversePlainInlineText(child, ldp, oc);
                    continue block4;
                }
            }
        }
        this.palette.getI18n().popSpecialTable();
    }

    private void traverseVerbatimInlineText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            block4: for (int i = 0; i < len; ++i) {
                Node childNode = nList.item(i);
                short nodeType = childNode.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = childNode.getNodeValue();
                        if (s.length() <= 0) continue block4;
                        ldp.append(s);
                        continue block4;
                    }
                    case 1: {
                        Element child = (Element)childNode;
                        String sName = child.getTagName();
                        if (sName.equals("text:s")) {
                            for (int count = Misc.getPosInteger(child.getAttribute("text:c"), 1); count > 0; --count) {
                                ldp.append(" ");
                            }
                            continue block4;
                        }
                        if (sName.equals("text:tab-stop") || sName.equals("text:tab")) {
                            ldp.append(this.sTabstop);
                            continue block4;
                        }
                        if (sName.equals("text:line-break")) {
                            if (oc.isNoLineBreaks()) continue block4;
                            ldp.nl();
                            continue block4;
                        }
                        if (sName.equals("text:note") || sName.equals("text:footnote") || sName.equals("text:endnote")) continue block4;
                        if (sName.equals("text:alphabetical-index-mark")) {
                            this.palette.getIndexCv().handleAlphabeticalIndexMark(child, ldp, oc);
                            continue block4;
                        }
                        if (sName.equals("text:alphabetical-index-mark-start")) {
                            this.palette.getIndexCv().handleAlphabeticalIndexMark(child, ldp, oc);
                            continue block4;
                        }
                        if (sName.equals("text:reference-mark")) {
                            this.palette.getFieldCv().handleReferenceMark(child, ldp, oc);
                            continue block4;
                        }
                        if (sName.equals("text:reference-mark-start")) {
                            this.palette.getFieldCv().handleReferenceMark(child, ldp, oc);
                            continue block4;
                        }
                        if (sName.equals("text:bookmark")) {
                            this.palette.getFieldCv().handleBookmark(child, ldp, oc);
                            continue block4;
                        }
                        if (sName.equals("text:bookmark-start")) {
                            this.palette.getFieldCv().handleBookmark(child, ldp, oc);
                            continue block4;
                        }
                        if (!sName.startsWith("text:")) continue block4;
                        this.traverseVerbatimInlineText(child, ldp, oc);
                        continue block4;
                    }
                }
            }
        }
    }

    public void traversePCDATA(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            for (int i = 0; i < nLen; ++i) {
                if (nl.item(i).getNodeType() != 3) continue;
                ldp.append(this.palette.getI18n().convert(nl.item(i).getNodeValue(), false, oc.getLang()));
            }
        }
    }

    private void handleChapterField(Element node, LaTeXDocumentPortion ldp, Context oc) {
        HeadingMap hm = this.config.getHeadingMap();
        int nLevel = Misc.getPosInteger(node.getAttribute("text:outline-level"), 1);
        if (nLevel <= hm.getMaxLevel()) {
            int nLaTeXLevel = hm.getLevel(nLevel);
            if (nLaTeXLevel == 1) {
                this.palette.getPageSc().setChapterField1(node.getAttribute("text:display"));
                ldp.append("{\\leftmark}");
            } else if (nLaTeXLevel == 2) {
                this.palette.getPageSc().setChapterField2(node.getAttribute("text:display"));
                ldp.append("{\\rightmark}");
            }
        }
    }

    private void handleOfficeAnnotation(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sCommand = null;
        switch (this.config.notes()) {
            case 0: {
                return;
            }
            case 1: {
                Element creator = null;
                Element date = null;
                ldp.append("%").nl();
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (Misc.isElement(child, "text:p")) {
                        ldp.append("%");
                        this.traversePlainInlineText((Element)child, ldp, oc);
                        ldp.nl();
                        continue;
                    }
                    if (Misc.isElement(child, "dc:creator")) {
                        creator = (Element)child;
                        continue;
                    }
                    if (!Misc.isElement(child, "dc:date")) continue;
                    date = (Element)child;
                }
                if (creator != null) {
                    ldp.append("%");
                    this.traversePlainInlineText(creator, ldp, oc);
                    ldp.nl();
                }
                if (date != null) {
                    ldp.append("%").append(Misc.formatDate(this.ofr.getTextContent(date), this.palette.getI18n().getDefaultLanguage(), null)).nl();
                }
                return;
            }
            case 2: {
                this.bHasPdfannotation = true;
                sCommand = "\\pdfannotation";
                break;
            }
            case 3: {
                sCommand = "\\marginpar";
                break;
            }
            case 4: {
                sCommand = this.config.getNotesCommand();
            }
        }
        ldp.append(sCommand).append("{");
        Element creator = null;
        Element date = null;
        boolean bFirst = true;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (Misc.isElement(child, "text:p")) {
                if (!bFirst) {
                    ldp.append(" ");
                }
                this.traversePlainInlineText((Element)child, ldp, oc);
                bFirst = false;
                continue;
            }
            if (Misc.isElement(child, "dc:creator")) {
                creator = (Element)child;
                continue;
            }
            if (!Misc.isElement(child, "dc:date")) continue;
            date = (Element)child;
        }
        if (creator != null) {
            if (!bFirst) {
                ldp.append(" - ");
            }
            this.traversePlainInlineText(creator, ldp, oc);
        }
        if (date != null) {
            if (creator != null) {
                ldp.append(", ");
            } else if (!bFirst) {
                ldp.append(" ");
            }
            ldp.append(Misc.formatDate(this.ofr.getTextContent(date), this.palette.getI18n().getDefaultLanguage(), null));
        }
        ldp.append("}");
    }

    private boolean onlyNote(Node node) {
        if (!node.hasChildNodes()) {
            return false;
        }
        NodeList nList = node.getChildNodes();
        int nLen = nList.getLength();
        block4: for (int i = 0; i < nLen; ++i) {
            Node child = nList.item(i);
            short nType = child.getNodeType();
            switch (nType) {
                case 3: {
                    return false;
                }
                case 1: {
                    if (OfficeReader.isNoteElement(child)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }
}

