/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xmerge;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.xmerge.DOMDocument;

public class NewDOMDocument
extends DOMDocument {
    public NewDOMDocument(String sFileName, String sExtension) {
        super(sFileName, sExtension);
    }

    public void write(OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        this.write(this.getContentDOM().getDocumentElement(), 0, osw);
        osw.flush();
        osw.close();
    }

    private void write(Node node, int nLevel, OutputStreamWriter osw) throws IOException {
        short nType = node.getNodeType();
        switch (nType) {
            case 1: {
                if (node.hasChildNodes()) {
                    int i;
                    NodeList list = node.getChildNodes();
                    int nLen = list.getLength();
                    boolean bBlockPrettyPrint = false;
                    if (nLevel >= 0) {
                        for (i = 0; i < nLen; ++i) {
                            bBlockPrettyPrint |= list.item(i).getNodeType() == 3;
                        }
                    }
                    if (nLevel >= 0) {
                        this.writeSpaces(nLevel, osw);
                    }
                    osw.write("<" + node.getNodeName());
                    this.writeAttributes(node, osw);
                    osw.write(">");
                    if (nLevel >= 0 && !bBlockPrettyPrint) {
                        osw.write("\n");
                    }
                    for (i = 0; i < nLen; ++i) {
                        int nNextLevel = bBlockPrettyPrint || nLevel < 0 ? -1 : nLevel + 1;
                        this.write(list.item(i), nNextLevel, osw);
                    }
                    if (nLevel >= 0 && !bBlockPrettyPrint) {
                        this.writeSpaces(nLevel, osw);
                    }
                    osw.write("</" + node.getNodeName() + ">");
                    if (nLevel < 0) break;
                    osw.write("\n");
                    break;
                }
                if (nLevel >= 0) {
                    this.writeSpaces(nLevel, osw);
                }
                osw.write("<" + node.getNodeName());
                this.writeAttributes(node, osw);
                osw.write(" />");
                if (nLevel < 0) break;
                osw.write("\n");
                break;
            }
            case 3: {
                this.write(node.getNodeValue(), osw);
                break;
            }
            case 8: {
                if (nLevel >= 0) {
                    this.writeSpaces(nLevel, osw);
                }
                osw.write("<!-- ");
                this.write(node.getNodeValue(), osw);
                osw.write(" -->");
                if (nLevel < 0) break;
                osw.write("\n");
            }
        }
    }

    private void writeAttributes(Node node, OutputStreamWriter osw) throws IOException {
        NamedNodeMap attr = node.getAttributes();
        int nLen = attr.getLength();
        for (int i = 0; i < nLen; ++i) {
            Node item = attr.item(i);
            osw.write(" ");
            this.write(item.getNodeName(), osw);
            osw.write("=\"");
            this.write(item.getNodeValue(), osw);
            osw.write("\"");
        }
    }

    private void writeSpaces(int nCount, OutputStreamWriter osw) throws IOException {
        for (int i = 0; i < nCount; ++i) {
            osw.write("  ");
        }
    }

    private void write(String s, OutputStreamWriter osw) throws IOException {
        int nLen = s.length();
        block7: for (int i = 0; i < nLen; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    osw.write("&lt;");
                    continue block7;
                }
                case '>': {
                    osw.write("&gt;");
                    continue block7;
                }
                case '&': {
                    osw.write("&amp;");
                    continue block7;
                }
                case '\"': {
                    osw.write("&quot;");
                    continue block7;
                }
                case '\'': {
                    osw.write("&apos;");
                    continue block7;
                }
                default: {
                    osw.write(c);
                }
            }
        }
    }
}

