# This file is part of lyx2lyx
# -*- coding: utf-8 -*-
# Copyright (C) 2004 José Matos <jamatos@lyx.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

""" Convert files to the file format generated by lyx 1.0"""

import re
from parser_tools import find_token, find_re

def obsolete_latex_title(document):
    " Replace LatexTitle layout with Title. "

    body = document.body
    i = 0
    while True:
        i = find_token(body, '\\layout', i)
        if i == -1:
            return

        if body[i].lower().find('latex title') != -1:
            body[i] = '\\layout Title'

        i = i + 1


def update_tabular(document):
    " Update from tabular format 3 to 4 if necessary."

    lines = document.body
    lyxtable_re = re.compile(r".*\\LyXTable$")
    i = 0
    while True:
        i = find_re(lines, lyxtable_re, i)
        if i == -1:
            break
        i = i + 1
        format = lines[i][8:]

        if format != '3':
            continue

        lines[i] = 'multicol4'
        i = i + 1
        rows = int(lines[i].split()[0])
        columns = int(lines[i].split()[1])

        lines[i] = lines[i] + ' 0 0 -1 -1 -1 -1'
        i = i + 1

        for j in range(rows):
            lines[i] = lines[i] + ' 0 0'
            i = i + 1

        for j in range(columns):
            lines[i] = lines[i] + ' '
            i = i + 1

        while lines[i].strip():
            lines[i] = lines[i] + ' 0 0 0'
            i = i + 1

        lines[i] = lines[i].strip()


supported_versions = ["1.0.%d" % i for i in range(5)] + ["1.0"]
convert = [[215, [obsolete_latex_title, update_tabular]]]
revert  = []


if __name__ == "__main__":
    pass

