/*
 * Decompiled with CFR 0.152.
 */
package org.miv.mbox.net;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.miv.mbox.net.MBoxLocator;
import org.miv.mbox.net.Packet;
import org.miv.mbox.net.Sender;

public class SenderPool {
    protected HashMap<String, Sender> senders = new HashMap();
    protected boolean debug;

    public SenderPool() {
    }

    public SenderPool(boolean debug) {
        this.debug = debug;
    }

    public boolean hasSender(MBoxLocator locator) {
        return this.senders.get(locator.getHostId()) != null;
    }

    public Sender getSender(MBoxLocator locator) {
        return this.senders.get(locator.getHostId());
    }

    public Sender getSender(String hostname, int port) {
        String id = "//" + hostname + ":" + port;
        return this.senders.get(id);
    }

    public Sender connect(String hostname, int port) throws IOException, UnknownHostException {
        String id = "//" + hostname + ":" + port;
        Sender sender = this.senders.get(id);
        if (sender == null) {
            sender = new Sender(new MBoxLocator(hostname, port), this.debug);
            this.senders.put(id, sender);
        }
        return sender;
    }

    public Sender connect(MBoxLocator locator) throws IOException, UnknownHostException {
        String id = locator.getHostId();
        Sender sender = this.senders.get(id);
        if (sender == null) {
            sender = new Sender(new MBoxLocator(locator.getHostname(), locator.getPort()), this.debug);
            this.senders.put(id, sender);
        }
        return sender;
    }

    public void send(String from, String hostname, int port, String to, Object ... messages) throws IOException, UnknownHostException {
        Sender sender = this.connect(hostname, port);
        sender.send(from, to, messages);
    }

    public void send(String from, MBoxLocator to, Object ... messages) throws IOException, UnknownHostException {
        Sender sender = this.connect(to);
        sender.send(from, to.getName(), messages);
    }

    public void send(MBoxLocator to, Packet packet) throws IOException, UnknownHostException {
        Sender sender = this.connect(to);
        sender.send(packet);
    }
}

