/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph;

import java.util.Iterator;
import java.util.stream.Stream;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;

public interface Node
extends Element,
Iterable<Edge> {
    public Graph getGraph();

    public int getDegree();

    public int getOutDegree();

    public int getInDegree();

    public Edge getEdgeToward(String var1);

    public Edge getEdgeFrom(String var1);

    public Edge getEdgeBetween(String var1);

    default public Stream<Node> neighborNodes() {
        return this.edges().map(edge -> edge.getOpposite(this));
    }

    public Edge getEdge(int var1);

    public Edge getEnteringEdge(int var1);

    public Edge getLeavingEdge(int var1);

    public Iterator<Node> getBreadthFirstIterator();

    public Iterator<Node> getBreadthFirstIterator(boolean var1);

    public Iterator<Node> getDepthFirstIterator();

    public Iterator<Node> getDepthFirstIterator(boolean var1);

    public Stream<Edge> edges();

    default public Stream<Edge> leavingEdges() {
        return this.edges().filter(e -> e.getSourceNode() == this);
    }

    default public Stream<Edge> enteringEdges() {
        return this.edges().filter(e -> e.getTargetNode() == this);
    }

    @Override
    default public Iterator<Edge> iterator() {
        return this.edges().iterator();
    }

    public String toString();

    default public boolean hasEdgeToward(String id) {
        return this.getEdgeToward(id) != null;
    }

    default public boolean hasEdgeToward(Node node) {
        return this.getEdgeToward(node) != null;
    }

    default public boolean hasEdgeToward(int index) throws IndexOutOfBoundsException {
        return this.getEdgeToward(index) != null;
    }

    default public boolean hasEdgeFrom(String id) {
        return this.getEdgeFrom(id) != null;
    }

    default public boolean hasEdgeFrom(Node node) {
        return this.getEdgeFrom(node) != null;
    }

    default public boolean hasEdgeFrom(int index) throws IndexOutOfBoundsException {
        return this.getEdgeFrom(index) != null;
    }

    default public boolean hasEdgeBetween(String id) {
        return this.getEdgeBetween(id) != null;
    }

    default public boolean hasEdgeBetween(Node node) {
        return this.getEdgeBetween(node) != null;
    }

    default public boolean hasEdgeBetween(int index) throws IndexOutOfBoundsException {
        return this.getEdgeBetween(index) != null;
    }

    public Edge getEdgeToward(Node var1);

    public Edge getEdgeToward(int var1) throws IndexOutOfBoundsException;

    public Edge getEdgeFrom(Node var1);

    public Edge getEdgeFrom(int var1) throws IndexOutOfBoundsException;

    public Edge getEdgeBetween(Node var1);

    public Edge getEdgeBetween(int var1) throws IndexOutOfBoundsException;
}

