/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.view;

import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.StyleGroupListener;
import org.graphstream.ui.view.GraphRenderer;
import org.graphstream.ui.view.Selection;

public abstract class GraphRendererBase<S, G>
implements GraphRenderer<S, G>,
StyleGroupListener {
    protected GraphicGraph graph;
    protected Selection selection = null;
    protected S renderingSurface;

    @Override
    public void open(GraphicGraph graph, S renderingSurface) {
        if (this.graph != null) {
            throw new RuntimeException("renderer already open, cannot open twice");
        }
        this.graph = graph;
        this.renderingSurface = renderingSurface;
        this.graph.getStyleGroups().addListener(this);
    }

    @Override
    public void close() {
        if (this.graph != null) {
            this.graph.getStyleGroups().removeListener(this);
            this.graph = null;
        }
    }

    public S getRenderingSurface() {
        return this.renderingSurface;
    }

    @Override
    public void beginSelectionAt(double x1, double y1) {
        if (this.selection == null) {
            this.selection = new Selection();
        }
        this.selection.x1 = x1;
        this.selection.y1 = y1;
        this.selection.x2 = x1;
        this.selection.y2 = y1;
    }

    @Override
    public void selectionGrowsAt(double x, double y) {
        this.selection.x2 = x;
        this.selection.y2 = y;
    }

    @Override
    public void endSelectionAt(double x2, double y2) {
        this.selection = null;
    }
}

