/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import ancestris.modules.editors.aries.models.SexComboBoxModel;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class IndividualReferencesTableModel
extends AbstractTableModel {
    private final List<PropertyXRef> individualsList = new ArrayList<PropertyXRef>();
    private final String[] columnsName = new String[]{NbBundle.getMessage(IndividualReferencesTableModel.class, (String)"IndividualsTableModel.column.ID.title"), NbBundle.getMessage(IndividualReferencesTableModel.class, (String)"IndividualsTableModel.column.Name.title"), NbBundle.getMessage(IndividualReferencesTableModel.class, (String)"IndividualsTableModel.column.Sex.title"), NbBundle.getMessage(IndividualReferencesTableModel.class, (String)"IndividualsTableModel.column.BirthDate.title"), NbBundle.getMessage(IndividualReferencesTableModel.class, (String)"IndividualsTableModel.column.DeathDate.title")};
    private final String[] sex = new String[]{NbBundle.getMessage(SexComboBoxModel.class, (String)"SexComboBoxModel.SexType.UNKNOWN"), NbBundle.getMessage(SexComboBoxModel.class, (String)"SexComboBoxModel.SexType.MALE"), NbBundle.getMessage(SexComboBoxModel.class, (String)"SexComboBoxModel.SexType.FEMALE")};

    @Override
    public int getRowCount() {
        return this.individualsList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return switch (column) {
            case 0 -> String.class;
            case 1 -> String.class;
            case 2 -> String.class;
            case 3 -> PropertyDate.class;
            case 4 -> PropertyDate.class;
            default -> String.class;
        };
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.individualsList.size()) {
            PropertyXRef individualReference = this.individualsList.get(row);
            Entity oIndividual = individualReference.getTargetEntity().orElse(null);
            if (oIndividual instanceof Indi) {
                Indi individual = (Indi)oIndividual;
                return switch (column) {
                    case 0 -> (PropertyDate)individual.getId();
                    case 1 -> (PropertyDate)individual.getName();
                    case 2 -> (PropertyDate)this.sex[individual.getSex()];
                    case 3 -> individual.getBirthDate();
                    case 4 -> individual.getDeathDate();
                    default -> (PropertyDate)"";
                };
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public void add(PropertyXRef individual) {
        this.individualsList.add(individual);
        this.fireTableDataChanged();
    }

    public void addAll(List<? extends PropertyXRef> individualsList) {
        this.individualsList.addAll(individualsList);
        this.fireTableDataChanged();
    }

    public PropertyXRef remove(int row) {
        PropertyXRef individual = this.individualsList.remove(row);
        this.fireTableDataChanged();
        return individual;
    }

    public PropertyXRef getValueAt(int row) {
        return this.individualsList.get(row);
    }

    public void clear() {
        this.individualsList.clear();
        this.fireTableDataChanged();
    }
}

