/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertySharedNote;
import genj.gedcom.PropertyXRef;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class NoteCitationsTableModel
extends AbstractTableModel {
    List<Property> notesList = new ArrayList<Property>();
    private final String[] columnsName = new String[]{NbBundle.getMessage(NoteCitationsTableModel.class, (String)"NoteCitationsTableModel.column.ID.title"), NbBundle.getMessage(NoteCitationsTableModel.class, (String)"NoteCitationsTableModel.column.noteText.title")};

    @Override
    public int getRowCount() {
        return this.notesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.notesList.size()) {
            Property note = this.notesList.get(row);
            if (note instanceof PropertyXRef) {
                Optional oNote = Optional.empty();
                if (note instanceof PropertyNote) {
                    PropertyNote pNote = (PropertyNote)note;
                    oNote = pNote.getTargetEntity();
                } else if (note instanceof PropertySharedNote) {
                    PropertySharedNote pNote = (PropertySharedNote)note;
                    oNote = pNote.getTargetEntity();
                }
                if (oNote.isPresent()) {
                    if (column == 0) {
                        return ((Entity)oNote.get()).getId();
                    }
                    return ((Entity)oNote.get()).getValue();
                }
                return "";
            }
            if (column == 0) {
                return "";
            }
            return note.getValue();
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public void add(Property notes) {
        this.notesList.add(notes);
        this.fireTableDataChanged();
    }

    public void addAll(List<Property> notesList) {
        this.notesList.addAll(notesList);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.notesList.clear();
        this.fireTableDataChanged();
    }

    public Property getValueAt(int row) {
        return this.notesList.get(row);
    }

    public Property remove(int row) {
        Property note = this.notesList.remove(row);
        this.fireTableDataChanged();
        return note;
    }

    public int getRowOf(Property p) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            Property pList = this.getValueAt(row);
            if (pList instanceof PropertyXRef) {
                pList = ((PropertyXRef)pList).getTargetEntity().orElse(null);
            }
            if (pList != p) continue;
            return row;
        }
        return -1;
    }
}

