/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.report.svgtree.FamBox;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.build.CountBoxes;
import ancestris.report.svgtree.build.NoSpouseFilter;
import ancestris.report.svgtree.build.RemoveDuplicates;
import ancestris.report.svgtree.build.RemoveDuplicatesPrepare;
import ancestris.report.svgtree.build.RemoveFamboxes;
import ancestris.report.svgtree.build.RemoveFamboxesWhereNoSpouse;
import ancestris.report.svgtree.build.RemoveOtherMarriages;
import ancestris.report.svgtree.build.TreeBuilder;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.report.Translator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public class BasicTreeBuilder
implements TreeBuilder {
    private static final Logger LOG = Logger.getLogger("ancestris.report.svgtree.BasicTreeBuilder", null);
    public int gen_ancestors = 3;
    public String[] gen_ancestorss = new String[]{"nolimit", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public int gen_ancestor_descendants = 3;
    public String[] gen_ancestor_descendantss = new String[]{"nolimit", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public int gen_descendants = 3;
    public String[] gen_descendantss = new String[]{"nolimit", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public boolean show_duplicates = false;
    public boolean display_other_marriages = true;
    public boolean show_spouses = true;
    public boolean display_fambox = true;
    public boolean display_singleparentfamily = true;
    private boolean husband_first = true;
    private Set<String> seenIndis = new HashSet<String>();
    private String seenId = "";
    private int seenCounter = 0;
    private static final String WHITE_BULLET_SYMBOL = "\u25e6";
    private static final String TICKMARK_SYMBOL = "\u2713";
    private static final String BALLOTBOX_SYMBOL = "\u2717";

    public BasicTreeBuilder(Translator translator) {
        this.gen_ancestorss[0] = translator.translate(this.gen_ancestorss[0]);
        this.gen_ancestor_descendantss[0] = translator.translate(this.gen_ancestor_descendantss[0]);
        this.gen_descendantss[0] = translator.translate(this.gen_descendantss[0]);
    }

    public void setHusbandFirst(boolean set) {
        this.husband_first = set;
    }

    @Override
    public IndiBox build(Indi indi) {
        IndiBox indiBox = new IndiBox(indi, 0);
        this.seenIndis.clear();
        this.seenId = "";
        this.seenCounter = 0;
        this.buildTree(indiBox, this.gen_ancestors == 0 ? 999 : this.gen_ancestors - 1, this.gen_descendants == 0 ? 999 : this.gen_descendants - 1, this.gen_ancestor_descendants == 0 ? 999 : this.gen_ancestor_descendants - 1, 0, 0, true);
        RemoveDuplicatesPrepare rdp = new RemoveDuplicatesPrepare();
        rdp.filter(indiBox);
        this.sortSosa(rdp.getMap());
        IndiBox.netTotalBoxes = 0;
        new RemoveDuplicates(this.show_duplicates).filter(indiBox);
        if (!this.show_spouses) {
            new NoSpouseFilter(!this.display_fambox && !this.display_other_marriages).filter(indiBox);
        }
        if (!this.display_fambox) {
            new RemoveFamboxes().filter(indiBox);
        }
        if (!this.display_singleparentfamily) {
            new RemoveFamboxesWhereNoSpouse().filter(indiBox);
        }
        if (!this.display_other_marriages) {
            new RemoveOtherMarriages().filter(indiBox);
        }
        new CountBoxes().filter(indiBox);
        return indiBox;
    }

    private void buildTree(IndiBox deCujusBox, int maxAncGen, int maxDesGen, int maxAncDesGen, int currentAncGen, int currentDesGen, boolean mainSosaLine) {
        BigInteger sosaStart = BigInteger.ONE.add(BigInteger.ONE);
        HashMap<BigInteger, IndiBox> sosaIndiBoxesMap = new HashMap<BigInteger, IndiBox>();
        sosaIndiBoxesMap.put(sosaStart, deCujusBox);
        if (currentAncGen <= maxAncGen) {
            this.buildSosaTree(sosaIndiBoxesMap, deCujusBox, maxAncGen, sosaStart, mainSosaLine);
        }
        for (BigInteger sosa : sosaIndiBoxesMap.keySet()) {
            this.buildDescendantsTree((IndiBox)sosaIndiBoxesMap.get(sosa), sosa.equals(BigInteger.ONE.shiftLeft(1)) ? maxDesGen : maxAncDesGen, currentDesGen + 1, mainSosaLine);
        }
        for (BigInteger sosa : sosaIndiBoxesMap.keySet()) {
            IndiBox last = (IndiBox)sosaIndiBoxesMap.get(sosa);
            if (last.spouse != null && last.spouse.nextMarriage != null) {
                this.buildTree(last.spouse.nextMarriage, maxAncGen, sosa.equals(BigInteger.ONE.shiftLeft(1)) ? maxDesGen : maxAncDesGen, maxAncDesGen, sosa.bitLength() - 2, currentDesGen, false);
            }
            if (last.nextMarriage == null) continue;
            this.buildTree(last.nextMarriage, maxAncGen, sosa.equals(BigInteger.ONE.shiftLeft(1)) ? maxDesGen : maxAncDesGen, maxAncDesGen, sosa.bitLength() - 2, currentDesGen, false);
        }
    }

    private void buildSosaTree(Map<BigInteger, IndiBox> map, IndiBox indiBox, int maxGen, BigInteger sosa, boolean mainSosaLine) {
        BigInteger sosaStart = BigInteger.ONE.add(BigInteger.ONE);
        if (this.seenLimitReached(indiBox.individual.getId())) {
            return;
        }
        this.setLinks(indiBox, sosa, mainSosaLine);
        if (indiBox.gen < maxGen) {
            BigInteger bi;
            Indi parent = this.getParent(indiBox.individual);
            if (parent != null && (mainSosaLine || !sosaStart.equals(sosa))) {
                IndiBox parentBox = new IndiBox(parent, indiBox, indiBox.gen + 1);
                parentBox.family = new FamBox(this.getFamily(indiBox.individual), parentBox.gen);
                indiBox.parent = parentBox;
                bi = sosa.shiftLeft(1);
                map.put(bi, parentBox);
                this.buildSosaTree(map, parentBox, maxGen, bi, mainSosaLine);
            }
            if (indiBox.spouse != null && (parent = this.getParent(indiBox.spouse.individual)) != null) {
                IndiBox parentSpouseBox = new IndiBox(parent, indiBox.spouse, indiBox.spouse.gen + 1);
                parentSpouseBox.family = new FamBox(this.getFamily(indiBox.spouse.individual), parentSpouseBox.gen);
                indiBox.spouse.parent = parentSpouseBox;
                bi = sosa.add(BigInteger.ONE).shiftLeft(1);
                map.put(bi, parentSpouseBox);
                this.buildSosaTree(map, parentSpouseBox, maxGen, bi, mainSosaLine);
            }
        }
    }

    private void buildDescendantsTree(IndiBox indiBox, int maxGen, int currentGen, boolean mainSosaLine) {
        if (currentGen > maxGen || indiBox.getFamily() == null) {
            return;
        }
        ArrayList<Indi> children = new ArrayList<Indi>(Arrays.asList(indiBox.getFamily().getChildren(true)));
        if (indiBox.prev != null) {
            children.remove(indiBox.prev.individual);
        }
        indiBox.children = new IndiBox[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            IndiBox childBox = new IndiBox((Indi)children.get(i), indiBox, indiBox.gen - 1);
            this.setLinks(childBox, indiBox.family.sosa, mainSosaLine);
            indiBox.children[i] = childBox;
            this.buildDescendantsTree(childBox, maxGen, currentGen + 1, mainSosaLine);
            IndiBox nextMarriage = this.getNextMarriageFromIndiBox(childBox);
            while (nextMarriage != null) {
                this.buildDescendantsTree(nextMarriage, maxGen, currentGen + 1, mainSosaLine);
                nextMarriage = this.getNextMarriageFromIndiBox(nextMarriage);
            }
        }
    }

    private boolean seenLimitReached(String id) {
        if (!this.seenIndis.contains(id)) {
            this.seenIndis.add(id);
        } else if (this.seenId.isEmpty() || this.seenId.equals(id)) {
            ++this.seenCounter;
            this.seenId = id;
            LOG.fine("duplicate = " + id + " - nb=" + this.seenCounter);
        }
        return this.seenCounter > 30;
    }

    private void setLinks(IndiBox indiBox, BigInteger sosa, boolean mainSosaLine) {
        if (indiBox.family != null && indiBox.spouse != null) {
            return;
        }
        ArrayList<Fam> families = new ArrayList<Fam>(Arrays.asList(indiBox.individual.getFamiliesWhereSpouse(true)));
        if (!families.isEmpty()) {
            Fam indiboxFamily = (Fam)families.get(0);
            if (!this.display_other_marriages) {
                indiboxFamily = indiBox.individual.getPreferredFamily();
            }
            if (indiBox.family == null) {
                indiBox.family = new FamBox(indiboxFamily, indiBox.gen);
            } else {
                indiboxFamily = indiBox.family.family;
            }
            indiBox.family.sosa = mainSosaLine ? sosa : null;
            Indi spouse = indiboxFamily.getOtherSpouse(indiBox.individual);
            if (indiBox.spouse == null && spouse != null) {
                indiBox.spouse = new IndiBox(spouse, indiBox, indiBox.gen);
            }
            if (indiBox.spouse == null && indiBox.nextMarriage == null || indiBox.spouse != null && indiBox.spouse.nextMarriage == null) {
                IndiBox last = indiBox.spouse;
                if (last == null) {
                    last = indiBox;
                }
                if (spouse != null) {
                    families.remove(indiboxFamily);
                    families.addAll(Arrays.asList(spouse.getFamiliesWhereSpouse()));
                }
                families.remove(indiboxFamily);
                for (Fam f : families) {
                    if (this.marriageChainIncludesFamily(indiBox, f)) continue;
                    Indi indi = indiBox.individual;
                    if (indiBox.individual != f.getHusband() && indiBox.individual != f.getWife()) {
                        indi = spouse;
                    }
                    IndiBox box = new IndiBox(indi, last, last.gen);
                    BigInteger bigInteger = (box.family = new FamBox((Fam)f, (int)indiBox.gen)).sosa = mainSosaLine ? sosa : null;
                    if (f.getOtherSpouse(indi) != null) {
                        box.spouse = new IndiBox(f.getOtherSpouse(indi), box, box.gen);
                    }
                    last.nextMarriage = box;
                    last = box.spouse;
                    if (last != null) continue;
                    last = box;
                }
            }
        }
    }

    private Indi getParent(Indi i) {
        Fam f = this.getFamily(i);
        if (f == null) {
            return null;
        }
        if (this.husband_first) {
            if (f.getHusband() != null) {
                return f.getHusband();
            }
            return f.getWife();
        }
        if (f.getWife() != null) {
            return f.getWife();
        }
        return f.getHusband();
    }

    private Fam getFamily(Indi i) {
        Fam[] fs = i.getFamiliesWhereChild();
        if (fs.length == 0) {
            return null;
        }
        return fs[0];
    }

    private void sortSosa(Map<Fam, List<FamBox>> map) {
        for (Fam fam : map.keySet()) {
            List<FamBox> list = map.get(fam);
            if (list.size() == 1) continue;
            Collections.sort(list, (o1, o2) -> {
                BigInteger bi1 = ((FamBox)o1).sosa;
                BigInteger bi2 = ((FamBox)o2).sosa;
                if (bi1 == null && bi2 == null) {
                    return 0;
                }
                if (bi1 == null && bi2 != null) {
                    return 1;
                }
                if (bi1 != null && bi2 == null) {
                    return -1;
                }
                return ((FamBox)o1).sosa.compareTo(((FamBox)o2).sosa);
            });
            int i = 1;
            for (FamBox fb : list) {
                fb.index = i++;
                fb.indexTotal = list.size();
            }
        }
    }

    private boolean marriageChainIncludesFamily(IndiBox indiBox, Fam f) {
        boolean ret = false;
        IndiBox.Direction dir = indiBox.getDir();
        IndiBox prev = indiBox.prev;
        while (dir == IndiBox.Direction.NEXTMARRIAGE || dir == IndiBox.Direction.SPOUSE) {
            if (prev.family != null && prev.family.family == f) {
                ret = true;
                break;
            }
            dir = prev == null ? IndiBox.Direction.NONE : prev.getDir();
            prev = prev.prev;
        }
        return ret;
    }

    private IndiBox getNextMarriageFromIndiBox(IndiBox indibox) {
        return indibox.spouse != null && indibox.spouse.nextMarriage != null ? indibox.spouse.nextMarriage : (indibox.spouse == null && indibox.nextMarriage != null ? indibox.nextMarriage : null);
    }

    public List<String> getLegendData() {
        ArrayList<String> legendData = new ArrayList<String>();
        legendData.add(NbBundle.getMessage(this.getClass(), (String)"builder"));
        legendData.add(WHITE_BULLET_SYMBOL + NbBundle.getMessage(this.getClass(), (String)"number_of_individuals") + ": " + IndiBox.netTotalBoxes);
        legendData.add(WHITE_BULLET_SYMBOL + NbBundle.getMessage(this.getClass(), (String)"gen_ancestors") + ": " + this.gen_ancestorss[this.gen_ancestors]);
        legendData.add(WHITE_BULLET_SYMBOL + NbBundle.getMessage(this.getClass(), (String)"gen_ancestor_descendants") + ": " + this.gen_ancestor_descendantss[this.gen_ancestor_descendants]);
        legendData.add(WHITE_BULLET_SYMBOL + NbBundle.getMessage(this.getClass(), (String)"gen_descendants") + ": " + this.gen_descendantss[this.gen_descendants]);
        legendData.add(WHITE_BULLET_SYMBOL + NbBundle.getMessage(this.getClass(), (String)"show_duplicates") + ": " + this.getSymbol(this.show_duplicates));
        legendData.add(WHITE_BULLET_SYMBOL + NbBundle.getMessage(this.getClass(), (String)"display_other_marriages") + ": " + this.getSymbol(this.display_other_marriages));
        legendData.add(WHITE_BULLET_SYMBOL + NbBundle.getMessage(this.getClass(), (String)"show_spouses") + ": " + this.getSymbol(this.show_spouses));
        legendData.add(WHITE_BULLET_SYMBOL + NbBundle.getMessage(this.getClass(), (String)"display_fambox") + ": " + this.getSymbol(this.display_fambox));
        legendData.add(WHITE_BULLET_SYMBOL + NbBundle.getMessage(this.getClass(), (String)"display_singleparentfamily") + ": " + this.getSymbol(this.display_singleparentfamily));
        return legendData;
    }

    private String getSymbol(boolean isOn) {
        return isOn ? TICKMARK_SYMBOL : BALLOTBOX_SYMBOL;
    }
}

