/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.viewer;

import java.io.Serializable;

public class GeoPosition
implements Serializable {
    private double latitude;
    private double longitude;

    public GeoPosition(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public GeoPosition(double[] coords) {
        this.latitude = coords[0];
        this.longitude = coords[1];
    }

    public GeoPosition(int latDegrees, int latMinutes, int latSeconds, int lonDegrees, int lonMinutes, int lonSeconds) {
        this((double)latDegrees + ((double)latMinutes + (double)latSeconds / 60.0) / 60.0, (double)lonDegrees + ((double)lonMinutes + (double)lonSeconds / 60.0) / 60.0);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoPosition)) {
            return false;
        }
        GeoPosition other = (GeoPosition)obj;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude);
    }

    public String toString() {
        return "[" + this.latitude + ", " + this.longitude + "]";
    }
}

