/*
 * Decompiled with CFR 0.152.
 */
package swingx.docking.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class EclipseDockUI
extends BasicTabbedPaneUI {
    private boolean activated = false;
    private boolean focused = false;
    protected ColorSchema selectedColors;
    protected ColorSchema activeColors;
    protected ColorSchema inactiveColors;
    private FocusHandler focusHandler = new FocusHandler();

    protected void installListeners() {
        super.installListeners();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.focusHandler);
    }

    protected void uninstallListeners() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.focusHandler);
        super.uninstallListeners();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.tabInsets = new Insets(4, 4, 4, 4);
        this.tabAreaInsets = new Insets(0, 0, 0, 20);
        this.contentBorderInsets = new Insets(3, 3, 3, 3);
        this.selectedTabPadInsets = new Insets(0, 0, 0, 0);
        this.selectedColors = new ColorSchema(UIManager.getColor("TabbedPane.foreground"), UIManager.getColor("TabbedPane.highlight"), UIManager.getColor("Panel.background"));
        this.activeColors = new ColorSchema(UIManager.getColor("InternalFrame.activeTitleForeground"), UIManager.getColor("InternalFrame.activeTitleBackground"), UIManager.getColor("InternalFrame.activeTitleGradient"));
        this.inactiveColors = new ColorSchema(UIManager.getColor("InternalFrame.inactiveTitleForeground"), UIManager.getColor("InternalFrame.inactiveTitleBackground"), UIManager.getColor("InternalFrame.inactiveTitleGradient"));
    }

    protected LayoutManager createLayoutManager() {
        return new EclipseLayout();
    }

    protected boolean shouldRotateTabRuns(int tabPlacement, int selectedRun) {
        return false;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return false;
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        Rectangle selRect;
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int tabAreaHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        g.setColor(this.getSelectionColors().getBackground2());
        g.fillRect(x, y + tabAreaHeight, w, h - tabAreaHeight);
        g.setColor(this.tabPane.getBackground().darker());
        g.drawLine(x, y + 2, x, y + h - 1);
        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + 2, y, x + w - 3, y);
        g.drawLine(x + 1, y + 1, x + 1, y + 1);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
        Rectangle rectangle = selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        if (selRect == null) {
            g.drawLine(x, y + tabAreaHeight, x + w - 1, y + tabAreaHeight);
        } else {
            g.drawLine(x, y + tabAreaHeight, selRect.x, y + tabAreaHeight);
            g.drawLine(selRect.x + selRect.width - 1, y + tabAreaHeight, x + w - 1, y + tabAreaHeight);
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            Graphics2D g2 = (Graphics2D)g;
            Paint savePaint = g2.getPaint();
            ColorSchema colors = this.getSelectionColors();
            GradientPaint titleGradient = new GradientPaint(0.0f, 0.0f, colors.getBackground1(), 0.0f, h, colors.getBackground2());
            g2.setPaint(titleGradient);
            g.fillRect(x + 1, y + 1, w - 2, h);
            g2.setPaint(savePaint);
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.tabPane.getBackground().darker());
        if (isSelected) {
            g.drawLine(x, y + 2, x, y + h - 1);
            g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
            g.drawLine(x + 2, y, x + w - 3, y);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
        } else if (tabIndex != this.tabPane.getSelectedIndex() - 1) {
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
        }
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected ColorSchema getSelectionColors() {
        if (this.focused && this.activated) {
            return this.activeColors;
        }
        if (this.focused) {
            return this.inactiveColors;
        }
        return this.selectedColors;
    }

    protected void setFocused(boolean focused) {
        if (focused != this.focused) {
            this.focused = focused;
            this.tabPane.repaint();
        }
    }

    protected void setActive(boolean active) {
        if (active != this.activated) {
            this.activated = active;
            this.tabPane.repaint();
        }
    }

    private class ColorSchema {
        private Color foreground;
        private Color background1;
        private Color background2;

        public ColorSchema(Color foreground, Color background1, Color background2) {
            this.foreground = foreground;
            this.background1 = background1;
            this.background2 = background2 == null ? background1 : background2;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public Color getBackground1() {
            return this.background1;
        }

        public Color getBackground2() {
            return this.background2;
        }
    }

    protected class EclipseLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected EclipseLayout() {
            super(EclipseDockUI.this);
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            FontMetrics metrics = EclipseDockUI.this.getFontMetrics();
            Dimension size = EclipseDockUI.this.tabPane.getSize();
            Insets insets = EclipseDockUI.this.tabPane.getInsets();
            Insets tabAreaInsets = EclipseDockUI.this.getTabAreaInsets(tabPlacement);
            int x = insets.left + tabAreaInsets.left;
            int y = insets.top + tabAreaInsets.top;
            int w = size.width - insets.left - tabAreaInsets.left - insets.right - tabAreaInsets.right;
            EclipseDockUI.this.runCount = 1;
            EclipseDockUI.this.maxTabHeight = EclipseDockUI.this.calculateMaxTabHeight(tabPlacement);
            EclipseDockUI.this.maxTabWidth = tabCount == 0 ? 0 : w / tabCount;
            int t = 0;
            while (t < tabCount) {
                Rectangle rect = EclipseDockUI.this.rects[t];
                rect.x = x;
                rect.y = y;
                rect.width = Math.min(EclipseDockUI.this.maxTabWidth, EclipseDockUI.this.calculateTabWidth(tabPlacement, t, metrics));
                rect.height = EclipseDockUI.this.maxTabHeight;
                x += rect.width;
                ++t;
            }
        }
    }

    private class FocusHandler
    implements PropertyChangeListener {
        private FocusHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (focusOwner == null) {
                EclipseDockUI.this.setFocused(false);
            } else {
                EclipseDockUI.this.setFocused(focusOwner == EclipseDockUI.this.tabPane || SwingUtilities.isDescendingFrom(focusOwner, EclipseDockUI.this.tabPane));
            }
            Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (activeWindow == null) {
                EclipseDockUI.this.setActive(false);
            } else {
                EclipseDockUI.this.setActive(activeWindow == SwingUtilities.getWindowAncestor(EclipseDockUI.this.tabPane));
            }
        }
    }
}

