/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util.swing;

import ancestris.util.swing.ColorChangedListener;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import org.openide.util.NbBundle;

public class ColorChooserButton
extends JButton {
    private Color current;
    private final List<ColorChangedListener> listeners = new ArrayList<ColorChangedListener>();

    public ColorChooserButton() {
        this(Color.GREEN);
    }

    public ColorChooserButton(Color c) {
        this.setSelectedColor(c);
        this.addActionListener(arg0 -> {
            Color newColor = JColorChooser.showDialog(null, NbBundle.getMessage(ColorChooserButton.class, (String)"ColorChooser.title"), this.current);
            this.setSelectedColor(newColor);
        });
    }

    public final Color getSelectedColor() {
        return this.current;
    }

    public final void setSelectedColor(Color newColor) {
        this.setSelectedColor(newColor, true);
    }

    public void setSelectedColor(Color newColor, boolean notify) {
        if (newColor == null) {
            return;
        }
        this.current = newColor;
        this.setIcon(ColorChooserButton.createIcon(this.current, 16, 16));
        this.repaint();
        if (notify) {
            this.listeners.forEach(l -> l.colorChanged(newColor));
        }
    }

    public void addColorChangedListener(ColorChangedListener toAdd) {
        this.listeners.add(toAdd);
    }

    public static ImageIcon createIcon(Color main, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(main);
        graphics.fillRect(0, 0, width, height);
        graphics.setXORMode(Color.DARK_GRAY);
        graphics.drawRect(0, 0, width - 1, height - 1);
        image.flush();
        ImageIcon icon = new ImageIcon(image);
        return icon;
    }
}

