/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.view.ViewContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import spin.Spin;

public class ContextListWidget
extends JList<Context> {
    private Gedcom gedcom;
    private final Callback callback = new Callback();
    private final MouseManager mouseManager = new MouseManager();
    private final List<Context> contexts = new ArrayList<Context>();

    public ContextListWidget(List<Context> list) {
        this.setModel(new Model(list));
        this.setSelectionMode(2);
        this.setCellRenderer(this.callback);
        this.addListSelectionListener(this.callback);
        this.addMouseListener(this.mouseManager);
    }

    public List<Context> getContexts() {
        return this.contexts;
    }

    private ViewContext getContext() {
        List selection = this.getSelectedValuesList();
        if (selection.size() == 1 && selection.get(0) instanceof ViewContext) {
            return (ViewContext)selection.get(0);
        }
        ArrayList<? extends Property> props = new ArrayList<Property>(16);
        ArrayList<? extends Entity> ents = new ArrayList<Entity>(16);
        for (Context context : selection) {
            props.addAll(context.getProperties());
            ents.addAll(context.getEntities());
        }
        return new ViewContext(new Context(this.gedcom, ents, props));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.gedcom.addGedcomListener((GedcomListener)Spin.over(this.getModel()));
    }

    @Override
    public void removeNotify() {
        this.gedcom.removeGedcomListener((GedcomListener)Spin.over(this.getModel()));
        super.removeNotify();
    }

    private class Callback
    extends DefaultListCellRenderer
    implements ListSelectionListener {
        private Callback() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ViewContext context = ContextListWidget.this.getContext();
            if (context != null) {
                SelectionDispatcher.fireSelection(context);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
            if (value instanceof ViewContext) {
                ViewContext ctx = (ViewContext)value;
                this.setIcon(ctx.getImage());
                this.setText(ctx.getText());
                Color c = ctx.getColor();
                if (c != null) {
                    this.setForeground(c);
                }
            } else {
                this.setIcon(Gedcom.getImage());
                this.setText(value.toString());
            }
            return this;
        }
    }

    private class MouseManager
    extends MouseAdapter {
        private MouseManager() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                ViewContext ctx;
                Action action;
                int r = ContextListWidget.this.locationToIndex(e.getPoint());
                Object object = ContextListWidget.this.getModel().getElementAt(r);
                if (object instanceof ViewContext && (action = (ctx = (ViewContext)object).getAction()) != null) {
                    ContextListWidget.this.setSelectedIndex(r);
                    action.actionPerformed(new ActionEvent(this, 1001, null){});
                }
            }
        }
    }

    private class Model
    extends AbstractListModel<Context>
    implements GedcomListener {
        private final List<Context> list = new ArrayList<Context>();

        private Model(List<? extends Context> set) {
            for (Context context : set) {
                this.list.add(context);
                if (ContextListWidget.this.gedcom == null) {
                    ContextListWidget.this.gedcom = context.getGedcom();
                    continue;
                }
                if (ContextListWidget.this.gedcom == context.getGedcom()) continue;
                throw new IllegalArgumentException(ContextListWidget.this.gedcom + "!=" + context.getGedcom());
            }
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        @Override
        public Context getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        @Override
        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            ListIterator<Context> it = this.list.listIterator();
            while (it.hasNext()) {
                Context context = it.next();
                if (!context.getEntities().contains(entity)) continue;
                it.remove();
            }
            this.fireContentsChanged(this, 0, this.list.size());
        }

        @Override
        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        }

        @Override
        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            this.fireContentsChanged(this, 0, this.list.size());
        }

        @Override
        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
            ListIterator<Context> it = this.list.listIterator();
            while (it.hasNext()) {
                Context context = it.next();
                if (!context.getProperties().contains(property)) continue;
                if (context instanceof ViewContext) {
                    ViewContext viewContext = (ViewContext)context;
                    it.set(new ViewContext(viewContext.getText(), viewContext.getImage(), new Context(context.getGedcom())));
                    continue;
                }
                it.set(new Context(context.getGedcom()));
            }
            this.fireContentsChanged(this, 0, this.list.size());
        }
    }
}

