/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyVisitor;
import genj.gedcom.PropertyXRef;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;

public class TagPath
implements Comparable {
    private String name = null;
    private String[] tags;
    private int[] qualifiers;
    private boolean[] last;
    private int len;
    private int hash = 0;
    public static final char SEPARATOR = ':';
    public static final String SEPARATOR_STRING = String.valueOf(':');
    public static final char SELECTOR = '?';
    public static final String STAY_TAG = ".";
    public static final String MOVEUP_TAG = "..";
    public static final String FOLLOW_TAG = "*";
    private static final String LAST = "last";
    private static Map<String, TagPath> tagCache = new HashMap<String, TagPath>(5);

    public TagPath(String path) throws IllegalArgumentException {
        this(path, null);
    }

    public TagPath(String path, boolean calque) throws IllegalArgumentException {
        this(path.split(SEPARATOR_STRING), null, calque);
    }

    public TagPath(String[] path, String name) throws IllegalArgumentException {
        this(path, name, false);
    }

    public TagPath(String[] path, String name, boolean calque) throws IllegalArgumentException {
        this.name = name;
        this.len = path.length;
        if (this.len == 0) {
            throw new IllegalArgumentException("No valid path '" + Arrays.toString(path) + "'");
        }
        this.tags = new String[this.len];
        this.qualifiers = new int[this.len];
        this.last = new boolean[this.len];
        for (int i = 0; i < this.len; ++i) {
            String tag = path[i];
            if (tag.length() == 0) {
                throw new IllegalArgumentException("Empty tag in '" + Arrays.toString(path) + "' is not valid");
            }
            this.set(i, tag, calque);
        }
    }

    public TagPath(String path, String name) throws IllegalArgumentException {
        this(path.split(SEPARATOR_STRING), name, false);
    }

    public static TagPath valueOf(String path) {
        TagPath result = tagCache.get(path);
        if (result == null) {
            result = new TagPath(path);
            tagCache.put(path, result);
        }
        return result;
    }

    private void set(int pos, String tag, boolean calque) {
        this.last[pos] = false;
        int qualifier = -1;
        int separator = tag.indexOf(63);
        if (separator > 0) {
            if (LAST.equals(tag.substring(separator + 1).toLowerCase())) {
                this.last[pos] = true;
            } else {
                try {
                    qualifier = Integer.parseInt(tag.substring(separator + 1));
                    if (calque) {
                        // empty if block
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal tag qualifier in '" + tag + "'");
                }
            }
            tag = tag.substring(0, separator);
        }
        this.tags[pos] = tag;
        this.qualifiers[pos] = --qualifier;
        this.hash += tag.hashCode();
    }

    public TagPath(TagPath other) {
        this(other, other.len);
    }

    public TagPath(TagPath other, int length) {
        this.len = length;
        this.tags = other.tags;
        this.qualifiers = other.qualifiers;
        this.last = other.last;
        for (int i = 0; i < this.len; ++i) {
            this.hash += this.tags[i].hashCode();
        }
    }

    public TagPath(TagPath other, String tag) {
        this.len = other.len + 1;
        this.tags = new String[this.len];
        this.qualifiers = new int[this.len];
        this.last = new boolean[this.len];
        System.arraycopy(other.tags, 0, this.tags, 0, other.len);
        System.arraycopy(other.qualifiers, 0, this.qualifiers, 0, other.len);
        System.arraycopy(other.last, 0, this.last, 0, other.len);
        this.tags[this.len - 1] = tag;
        this.qualifiers[this.len - 1] = -1;
        this.last[this.len - 1] = false;
        this.hash = other.hash + tag.hashCode();
    }

    TagPath(Stack<String> path) throws IllegalArgumentException {
        this.len = path.size();
        this.tags = new String[this.len];
        this.qualifiers = new int[this.len];
        this.last = new boolean[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.set(i, path.pop(), false);
        }
    }

    public boolean startsWith(TagPath prefix) {
        if (prefix.len > this.len) {
            return false;
        }
        for (int i = 0; i < prefix.len; ++i) {
            if (this.tags[i].equals(prefix.tags[i]) && this.qualifiers[i] == prefix.qualifiers[i] && this.last[i] == prefix.last[i]) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(TagPath suffix) {
        if (suffix.len > this.len) {
            return false;
        }
        int offset = this.len - suffix.len;
        for (int i = suffix.len - 1; i >= 0; --i) {
            if (this.tags[i + offset].equals(suffix.tags[i]) && this.qualifiers[i + offset] == suffix.qualifiers[i] && this.last[i + offset] == suffix.last[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TagPath)) {
            return false;
        }
        TagPath other = (TagPath)obj;
        if (other.len != this.len) {
            return false;
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.tags[i].equals(other.tags[i]) && this.qualifiers[i] == other.qualifiers[i] && this.last[i] == other.last[i]) continue;
            return false;
        }
        return true;
    }

    public String get(int which) {
        if (which < 0) {
            which += this.len;
        }
        if (which < 0) {
            return null;
        }
        return this.tags[which];
    }

    public String getFirst() {
        return this.get(0);
    }

    public String getLast() {
        return this.get(this.len - 1);
    }

    public TagPath getParent() {
        return new TagPath(this, this.len - 1);
    }

    public TagPath getRight() {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < this.len - 1; ++i) {
            result.append(this.get(i) + ":");
        }
        result.append(this.get(this.len - 1));
        return new TagPath(result.toString());
    }

    public int length() {
        return this.len;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.len; ++i) {
            if (i > 0) {
                result.append(':');
            }
            result.append(this.tags[i]);
            if (this.qualifiers[i] >= 0) {
                result.append('?');
                result.append(this.qualifiers[i]);
            }
            if (!this.last[i]) continue;
            result.append('?');
            result.append(LAST);
        }
        return result.toString();
    }

    public String[] toArray() {
        return this.tags;
    }

    public int[] getQualifiers() {
        return this.qualifiers;
    }

    public int hashCode() {
        return this.hash;
    }

    public String getName() {
        if (this.name == null) {
            String up;
            int i = this.length() - 1;
            String tag = this.get(i);
            while (i > 1 && !Character.isJavaIdentifierPart(tag.charAt(0))) {
                tag = this.get(--i);
            }
            this.name = Gedcom.getName(tag);
            if (i > 1 && Character.isLetter(this.get(i - 1).charAt(0)) && !Pattern.compile(".*" + (up = Gedcom.getName(this.get(i - 1))) + ".*", 2).matcher(this.name).find()) {
                this.name = this.name + " - " + up;
            }
        }
        return this.name;
    }

    public String getShortName() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.len; ++i) {
            if (i > 0) {
                result.append(':');
            }
            result.append(this.tags[i]);
            if (this.qualifiers[i] >= 0 && this.qualifiers[i] != 0) {
                result.append("(");
                result.append(this.qualifiers[i] + 1);
                result.append(")");
            }
            if (!this.last[i]) continue;
            result.append("(");
            result.append(LAST);
            result.append(")");
        }
        return result.toString();
    }

    public static TagPath get(Property prop) {
        Object p = prop.getTag();
        while (!(prop instanceof Entity)) {
            prop = prop.getParent();
            p = prop.getTag() + SEPARATOR_STRING + (String)p;
        }
        return new TagPath((String)p);
    }

    public static TagPath[] toArray(Collection<TagPath> c) {
        return c.toArray(new TagPath[c.size()]);
    }

    public static TagPath[] toArray(String[] paths) {
        TagPath[] result = new TagPath[paths.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new TagPath(paths[i]);
        }
        return result;
    }

    public void iterate(Property root, PropertyVisitor visitor) {
        this.iterate(root, visitor, true);
    }

    public void iterate(Property root, PropertyVisitor visitor, boolean backtrack) {
        String tag = this.get(0);
        char c = tag.charAt(0);
        if (c == '.' || c == '*') {
            this.iterate(0, root, visitor, backtrack);
        } else if (tag.equals(root.getTag())) {
            this.iterate(1, root, visitor, backtrack);
        }
    }

    protected boolean iterate(int pos, Property prop, PropertyVisitor visitor, boolean backtrack) {
        String tag;
        while (true) {
            if (pos == this.length()) {
                return visitor.leaf(prop);
            }
            tag = this.get(pos);
            if (tag.equals(MOVEUP_TAG)) {
                if (prop.getParent() != null) {
                    prop = prop.getParent();
                }
            } else if (!tag.equals(STAY_TAG)) {
                if (!tag.equals(FOLLOW_TAG)) break;
                if (!(prop instanceof PropertyXRef) || ((PropertyXRef)prop).getTarget() == null) {
                    return false;
                }
                prop = ((PropertyXRef)prop).getTarget();
            }
            ++pos;
        }
        return this.recurse(visitor, prop, tag, pos, backtrack);
    }

    protected boolean recurse(PropertyVisitor visitor, Property prop, String tag, int pos, boolean backtrack) {
        if (!visitor.recursion(prop, tag)) {
            return false;
        }
        if (this.last[pos]) {
            for (int i = prop.getNoOfProperties() - 1; i > -1; --i) {
                Property child = prop.getProperty(i);
                if (!backtrack && prop.getProperty(child.getTag()) != child || !tag.equals(child.getTag()) || this.iterate(pos + 1, child, visitor, backtrack)) continue;
                return false;
            }
        }
        int qualifier = this.qualifiers[pos];
        int c = 0;
        for (int i = 0; i < prop.getNoOfProperties(); ++i) {
            Property child = prop.getProperty(i);
            if (!backtrack && prop.getProperty(child.getTag()) != child || !tag.equals(child.getTag()) || qualifier >= 0 && qualifier != c++ || this.iterate(pos + 1, child, visitor, backtrack)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String tag) {
        for (int i = 0; i < this.len; ++i) {
            if (!this.tags[i].equals(tag)) continue;
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }
}

