/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import genj.io.FileAssociation;
import genj.option.Option;
import genj.option.PropertyOption;
import genj.print.PrintRegistry;
import genj.print.PrintRenderer;
import genj.renderer.DPI;
import genj.renderer.EmptyHintKey;
import genj.util.Dimension2d;
import genj.util.EnvironmentChecker;
import genj.util.Resources;
import genj.util.Trackable;
import genj.util.WordBuffer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

class PrintTask
implements Printable,
Trackable {
    static final DocFlavor FLAVOR = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
    static final Resources RESOURCES = Resources.get(PrintTask.class);
    static final Logger LOG = Logger.getLogger("ancestris.print");
    private PrintService service;
    private PrintRenderer renderer;
    private int page = 0;
    private Throwable throwable;
    private String title;
    private PrintRegistry registry;
    private String progress;
    private PrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
    private Dimension pages;
    private double zoomx = 1.0;
    private double zoomy = 1.0;
    private boolean printEmpties = false;

    public PrintTask(String title, PrintRenderer renderer) throws PrintException {
        this.renderer = renderer;
        this.title = title;
        this.registry = PrintRegistry.get(renderer);
        PrintService service = this.registry.get(this.getDefaultService());
        if (!service.isDocFlavorSupported(FLAVOR)) {
            service = this.getDefaultService();
        }
        this.setService(service);
        this.attributes.add(new JobName("GenJ", null));
        this.registry.get(this.attributes);
        String file = EnvironmentChecker.getProperty("ancestris.print.file", null, "Print file output");
        if (file != null) {
            this.attributes.add(new Destination(new File(file).toURI()));
        }
    }

    String getTitle() {
        return this.title;
    }

    protected PrintService getDefaultService() throws PrintException {
        PrintService service = PrintServiceLookup.lookupDefaultPrintService();
        if (service != null) {
            if (service.isDocFlavorSupported(FLAVOR)) {
                return service;
            }
            LOG.info("Default print service not supported");
        } else {
            LOG.info("No default print service available (are you running CUPS?)");
        }
        PrintService[] suitables = PrintServiceLookup.lookupPrintServices(FLAVOR, null);
        if (suitables.length == 0) {
            throw new PrintException("Couldn't find any suitable printer");
        }
        return suitables[0];
    }

    protected PrintService[] getServices() {
        return PrintServiceLookup.lookupPrintServices(FLAVOR, null);
    }

    PrintRequestAttributeSet getAttributes() {
        return this.attributes;
    }

    void setService(PrintService set) {
        this.service = set;
        this.registry.put(this.service);
    }

    PrintService getService() {
        return this.service;
    }

    DPI getResolution() {
        return new DPI(72, 72);
    }

    Rectangle2D getPrintable() {
        OrientationRequested orientation = (OrientationRequested)this.getAttribute(OrientationRequested.class);
        MediaPrintableArea printable = (MediaPrintableArea)this.getAttribute(MediaPrintableArea.class);
        Rectangle2D.Float result = new Rectangle2D.Float();
        if (orientation == OrientationRequested.LANDSCAPE || orientation == OrientationRequested.REVERSE_LANDSCAPE) {
            Dimension2D size = this.getPageSize();
            ((Rectangle2D)result).setRect(size.getWidth() - (double)printable.getHeight(25400) - (double)printable.getY(25400), printable.getX(25400), printable.getHeight(25400), printable.getWidth(25400));
        } else {
            ((Rectangle2D)result).setRect(printable.getX(25400), printable.getY(25400), printable.getWidth(25400), printable.getHeight(25400));
        }
        return result;
    }

    Rectangle2D getPrintable(Rectangle2D page) {
        Rectangle2D printable = this.getPrintable();
        return new Rectangle2D.Double(page.getMinX() + printable.getX(), page.getMinY() + printable.getY(), printable.getWidth(), printable.getHeight());
    }

    Dimension2D getPageSize() {
        OrientationRequested orientation = (OrientationRequested)this.getAttribute(OrientationRequested.class);
        Media media = (Media)this.getAttribute(Media.class);
        MediaSize size = null;
        if (media instanceof MediaSizeName) {
            size = MediaSize.getMediaSizeForName((MediaSizeName)media);
        }
        if (size == null) {
            try {
                size = MediaSize.getMediaSizeForName((MediaSizeName)media.getClass().getMethod("getStandardMedia", new Class[0]).invoke((Object)media, new Object[0]));
                LOG.fine("Got MediaSize " + size + " from " + media + ".getStandardMedia()");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (size == null) {
            LOG.warning("Need MediaSize, got unknown MediaSizeName, MediaTray or MediaName '" + media + "' - using A4");
            this.attributes.add(MediaSizeName.ISO_A4);
            size = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        }
        Dimension2d result = new Dimension2d();
        if (orientation == OrientationRequested.LANDSCAPE || orientation == OrientationRequested.REVERSE_LANDSCAPE) {
            ((Dimension2D)result).setSize(size.getY(25400), size.getX(25400));
        } else {
            ((Dimension2D)result).setSize(size.getX(25400), size.getY(25400));
        }
        return result;
    }

    void setPages(Dimension pages, boolean fit) {
        if (pages.width == 0 || pages.height == 0) {
            throw new IllegalArgumentException("0 not allowed");
        }
        this.pages = pages;
        Rectangle2D printable = this.getPrintable();
        Dimension2D size = this.getSize();
        this.zoomx = (double)pages.width * printable.getWidth() / size.getWidth();
        this.zoomy = (double)pages.height * printable.getHeight() / size.getHeight();
        if (!fit) {
            if (this.zoomx > this.zoomy) {
                this.zoomx = this.zoomy;
            }
            if (this.zoomy > this.zoomx) {
                this.zoomy = this.zoomx;
            }
        }
    }

    boolean isPrintEmpties() {
        return this.printEmpties;
    }

    void setPrintEmpties(boolean set) {
        this.printEmpties = set;
    }

    void setZoom(double zoom) {
        this.zoomx = zoom;
        this.zoomy = zoom;
        this.pages = null;
    }

    Dimension2D getSize() {
        return this.renderer.getSize();
    }

    Dimension getPages() {
        if (this.pages != null) {
            return this.pages;
        }
        Rectangle2D printable = this.getPrintable();
        gj.awt.geom.Dimension2D dim = this.renderer.getSize();
        return new Dimension((int)Math.ceil(dim.getWidth() * this.zoomx / printable.getWidth()), (int)Math.ceil(dim.getHeight() * this.zoomy / printable.getHeight()));
    }

    private String toString(PrintRequestAttributeSet atts) {
        WordBuffer buf = new WordBuffer(",");
        Attribute[] array = this.attributes.toArray();
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i].getClass().getName() + "=" + array[i].toString());
        }
        return buf.toString();
    }

    private PrintRequestAttribute getAttribute(Class<? extends PrintRequestAttribute> category) {
        Object result = this.attributes.get(category);
        if (result instanceof PrintRequestAttribute) {
            return (PrintRequestAttribute)result;
        }
        if (!Media.class.isAssignableFrom(category)) {
            this.getAttribute(Media.class);
        }
        if ((result = this.service.getDefaultAttributeValue(category)) == null) {
            LOG.finer("Couldn't find default PrintRequestAttribute for category " + category);
            result = this.service.getSupportedAttributeValues(category, null, this.attributes);
            if (result == null) {
                LOG.warning("Couldn't find supported PrintRequestAttribute for category " + category + " with " + this.toString(this.attributes));
            } else if (result.getClass().isArray()) {
                LOG.fine("Got PrintRequestAttribute values " + Arrays.toString((Object[])result) + " for category " + category);
                Object[] os = (Object[])result;
                result = null;
                for (int i = 0; result == null && i < os.length; ++i) {
                    if (os[i] == null || !category.isAssignableFrom(os[i].getClass())) continue;
                    result = os[i];
                    break;
                }
            }
        }
        if (result == null && category == Media.class) {
            result = MediaSizeName.ISO_A4;
            LOG.warning("fallback media is " + result);
            this.attributes.add((Media)result);
        }
        if (result == null && category == MediaPrintableArea.class) {
            Dimension2D page = this.getPageSize();
            result = new MediaPrintableArea(1.0f, 1.0f, (float)page.getWidth() - 2.0f, (float)page.getHeight() - 2.0f, 25400);
            LOG.warning("Using fallback MediaPrintableArea " + result);
        }
        if (result != null) {
            this.attributes.add((PrintRequestAttribute)result);
            LOG.fine("PrintRequestAttribute for category " + category + " is " + result + " with " + this.toString(this.attributes));
        } else {
            LOG.warning("Couldn't find any PrintRequestAttribute for category " + category + " with " + this.toString(this.attributes));
        }
        return (PrintRequestAttribute)result;
    }

    List<? extends Option> getOptions() {
        return PropertyOption.introspect(this.renderer);
    }

    @Override
    public void cancelTrackable() {
    }

    @Override
    public int getProgress() {
        return (int)((float)this.page / (float)(this.getPages().width * this.getPages().height) * 100.0f);
    }

    @Override
    public String getState() {
        return RESOURCES.getString("progress", this.page + 1, this.getPages().width * this.getPages().height);
    }

    void print() {
        this.registry.put(this.attributes);
        try {
            this.service.createPrintJob().print(new SimpleDoc(this, FLAVOR, null), this.attributes);
        }
        catch (PrintException e) {
            LOG.log(Level.WARNING, "print failed", e);
        }
        String file = EnvironmentChecker.getProperty("ancestris.print.file", null, "Print file output");
        if (file != null) {
            FileAssociation.getDefault().execute(new File(file).getAbsolutePath());
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Dimension pages = this.getPages();
        int row = pageIndex / pages.width;
        int col = pageIndex % pages.width;
        if (col >= pages.width || row >= pages.height) {
            return 1;
        }
        this.page = pageIndex;
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(DPI.KEY, this.getResolution());
        this.print((Graphics2D)graphics, row, col);
        return 0;
    }

    void print(Graphics2D graphics, int row, int col) {
        DPI dpi = DPI.get(graphics);
        Rectangle2D pixels = dpi.toPixel(this.getPrintable());
        graphics.translate(pixels.getX() - (double)col * pixels.getWidth(), pixels.getY() - (double)row * pixels.getHeight());
        Rectangle2D.Double box = new Rectangle2D.Double((double)col * pixels.getWidth(), (double)row * pixels.getHeight(), pixels.getWidth(), pixels.getHeight());
        graphics.clip(box);
        graphics.scale(this.zoomx, this.zoomy);
        graphics.setRenderingHint(EmptyHintKey.KEY, true);
        this.renderer.render(graphics);
    }

    @Override
    public String getTaskName() {
        return RESOURCES.getString("printer.title");
    }
}

