/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import ancestris.core.actions.AbstractAncestrisAction;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableWidget<ROW>
extends JTable {
    private List<Column> columns = new ArrayList<Column>();
    private Mouser mouser = new Mouser();

    public TableWidget() {
        super(new DefaultTableModel(), new DefaultTableColumnModel());
        this.setModel(new Model());
        this.setPreferredScrollableViewportSize(new Dimension(32, 32));
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setFillsViewportHeight(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(this.mouser);
        this.addMouseMotionListener(this.mouser);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Object val = this.getValueAt(row, column);
        if (val instanceof AbstractAncestrisAction) {
            return new ActionRenderer();
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int col = this.columnAtPoint(event.getPoint());
        int row = this.rowAtPoint(event.getPoint());
        if (col < 0 || row < 0) {
            return null;
        }
        Object val = this.getValueAt(row, col);
        if (!(val instanceof AbstractAncestrisAction)) {
            return null;
        }
        AbstractAncestrisAction action = (AbstractAncestrisAction)val;
        String tip = action.getTip();
        if (tip != null) {
            return tip;
        }
        return action.getText();
    }

    public void setRows(List<ROW> rows) {
        this.model().setRows(rows);
    }

    public void addRow(ROW row) {
        this.model().addRow(row);
    }

    public void deleteRow(ROW row) {
        this.model().delRow(row);
    }

    private Model model() {
        return (Model)this.getModel();
    }

    private class Mouser
    extends MouseAdapter
    implements MouseMotionListener {
        private Mouser() {
        }

        private ROW getRow(MouseEvent e) {
            int row = TableWidget.this.rowAtPoint(e.getPoint());
            return row < 0 ? null : (Object)TableWidget.this.model().getRow(row);
        }

        private Column getColumn(MouseEvent e) {
            int col = TableWidget.this.columnAtPoint(e.getPoint());
            return col < 0 ? null : TableWidget.this.columns.get(col);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Object val;
            Cursor cursor = null;
            Column col = this.getColumn(e);
            Object row = this.getRow(e);
            if (row != null && (val = col.getValue(row)) instanceof Action) {
                cursor = Cursor.getPredefinedCursor(12);
            }
            TableWidget.this.setCursor(cursor);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object val;
            int c = TableWidget.this.columnAtPoint(e.getPoint());
            if (c < 0) {
                return;
            }
            Column col = TableWidget.this.columns.get(c);
            Object row = this.getRow(e);
            if (row != null && (val = col.getValue(row)) instanceof Action) {
                ((Action)val).actionPerformed(new ActionEvent(TableWidget.this, c, ""));
            }
        }
    }

    private class Model
    extends AbstractTableModel {
        private List<ROW> rows = new ArrayList();

        private Model() {
        }

        private void setRows(List<ROW> rows) {
            if (!this.rows.isEmpty()) {
                int n = this.rows.size();
                this.rows.clear();
                this.fireTableRowsDeleted(0, n - 1);
            }
            this.rows.addAll(rows);
            if (!this.rows.isEmpty()) {
                this.fireTableRowsInserted(0, this.rows.size() - 1);
            }
        }

        private void addRow(ROW row) {
            this.rows.add(row);
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        }

        private void delRow(ROW row) {
            int i = this.rows.indexOf(row);
            this.rows.remove(i);
            this.fireTableRowsDeleted(i, i);
        }

        private ROW getRow(int row) {
            return this.rows.get(row);
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return TableWidget.this.columns.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return TableWidget.this.columns.get(columnIndex).getValue(this.rows.get(rowIndex));
        }

        @Override
        public String getColumnName(int column) {
            return TableWidget.this.getColumnModel().getColumn(column).getHeaderValue().toString();
        }
    }

    private static class ActionRenderer
    extends DefaultTableCellRenderer {
        private ActionRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value != null) {
                super.setIcon(((AbstractAncestrisAction)value).getImage());
            }
        }
    }

    public abstract class Column {
        protected Column(String name) {
            this(name, String.class);
        }

        protected Column(String name, Class<?> valueType) {
            TableWidget.this.columns.add(this);
            TableColumn c = new TableColumn(TableWidget.this.columns.size() - 1);
            if (AbstractAncestrisAction.class.isAssignableFrom(valueType)) {
                c.setMaxWidth(16);
            }
            c.setHeaderValue(name);
            TableWidget.this.getColumnModel().addColumn(c);
        }

        public abstract Object getValue(ROW var1);
    }
}

