/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve;

import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.Field;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JuridictionConvertDialog
extends JDialog {
    private final DataManager dataManager;
    private static final String juridictionSeparator = ",";
    static final AbstractRecord.FieldType[] fieldTypes = new AbstractRecord.FieldType[]{AbstractRecord.FieldType.indiBirthPlace, AbstractRecord.FieldType.indiResidence, AbstractRecord.FieldType.indiMarriedResidence, AbstractRecord.FieldType.indiFatherResidence, AbstractRecord.FieldType.indiMotherResidence, AbstractRecord.FieldType.wifeBirthPlace, AbstractRecord.FieldType.wifeResidence, AbstractRecord.FieldType.wifeMarriedResidence, AbstractRecord.FieldType.wifeFatherResidence, AbstractRecord.FieldType.wifeMotherResidence};
    private JButton jButtonConvert;
    private JPanel jPanelCommand;
    private JPanel jPanelResult;
    private JScrollPane jScrollPaneResult;
    private JTable jTableResult;

    public static void show(Frame parent, DataManager dataManager, String sourceTitle) {
        JuridictionConvertDialog dialog = new JuridictionConvertDialog(parent, dataManager);
        dialog.setVisible(true);
    }

    public JuridictionConvertDialog(Frame parent, DataManager dataManager) {
        super(parent, true);
        this.dataManager = dataManager;
        this.initComponents();
        JuridictionTableModel tableModel = new JuridictionTableModel(dataManager);
        this.jTableResult.setModel(tableModel);
        this.jTableResult.getTableHeader().setReorderingAllowed(true);
    }

    private void initComponents() {
        this.jPanelCommand = new JPanel();
        this.jButtonConvert = new JButton();
        this.jPanelResult = new JPanel();
        this.jScrollPaneResult = new JScrollPane();
        this.jTableResult = new JTable();
        this.setDefaultCloseOperation(2);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonConvert, (String)NbBundle.getMessage(JuridictionConvertDialog.class, (String)"JuridictionConvertDialog.jButtonConvert.text"));
        this.jButtonConvert.setHorizontalTextPosition(0);
        this.jButtonConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JuridictionConvertDialog.this.jButtonConvertActionPerformed(evt);
            }
        });
        this.jPanelCommand.add(this.jButtonConvert);
        this.getContentPane().add((Component)this.jPanelCommand, "North");
        this.jPanelResult.setLayout(new BorderLayout());
        this.jTableResult.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTableResult.getTableHeader().setReorderingAllowed(false);
        this.jScrollPaneResult.setViewportView(this.jTableResult);
        this.jPanelResult.add((Component)this.jScrollPaneResult, "Center");
        this.getContentPane().add((Component)this.jPanelResult, "Center");
        this.pack();
    }

    private void jButtonConvertActionPerformed(ActionEvent evt) {
        int nbJuridictions = this.jTableResult.getColumnCount();
        int[] convert = new int[nbJuridictions];
        TableColumnModel columnModel = this.jTableResult.getTableHeader().getColumnModel();
        for (int c = 0; c < columnModel.getColumnCount(); ++c) {
            convert[c] = columnModel.getColumn(c).getModelIndex();
        }
        for (int i = 0; i < this.dataManager.getDataModel().getRowCount(); ++i) {
            AbstractRecord record = this.dataManager.getDataModel().getRecord(i);
            for (AbstractRecord.FieldType fieldType : fieldTypes) {
                Field fieldPlace = record.getField(fieldType);
                if (fieldPlace == null || fieldPlace.isEmpty()) continue;
                String actualPlace = fieldPlace.getValue();
                String[] juridictions = actualPlace.split(juridictionSeparator);
                Object convertedPlace = "";
                for (int j = 0; j < nbJuridictions; ++j) {
                    if (juridictions.length - 1 >= convert[j]) {
                        convertedPlace = (String)convertedPlace + juridictions[convert[j]].trim();
                    }
                    if (j >= nbJuridictions - 1) continue;
                    convertedPlace = (String)convertedPlace + juridictionSeparator;
                }
                fieldPlace.setValue((String)convertedPlace);
                this.dataManager.getCompletionProvider().updatePlaces(fieldPlace.getValue(), actualPlace);
            }
        }
        this.dataManager.getDataModel().fireAllChanged();
    }

    private class JuridictionTableModel
    extends AbstractTableModel {
        private int nbJuridictions;
        private int nbPlaces = 0;
        private final String[][] juridictions;

        public JuridictionTableModel(DataManager dataManager) {
            int i;
            TreeMap<String, String[]> places = new TreeMap<String, String[]>();
            this.nbJuridictions = 0;
            for (i = 0; i < dataManager.getDataModel().getRowCount(); ++i) {
                AbstractRecord record = dataManager.getDataModel().getRecord(i);
                for (AbstractRecord.FieldType fieldType : fieldTypes) {
                    Field fieldPlace = record.getField(fieldType);
                    if (fieldPlace == null || fieldPlace.isEmpty()) continue;
                    String actualPlace = fieldPlace.getValue();
                    String[] splitPlace = actualPlace.split(JuridictionConvertDialog.juridictionSeparator, -1);
                    if (splitPlace.length > this.nbJuridictions) {
                        this.nbJuridictions = splitPlace.length;
                    }
                    places.put(actualPlace, splitPlace);
                }
            }
            this.nbPlaces = places.size();
            this.juridictions = new String[places.size()][this.nbJuridictions];
            i = 0;
            for (String[] place : places.values()) {
                int j = 0;
                for (String field : place) {
                    this.juridictions[i][j] = field.trim();
                    ++j;
                }
                for (int jj = j; jj < this.nbJuridictions; ++jj) {
                    this.juridictions[i][j] = "---";
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.nbJuridictions;
        }

        @Override
        public int getRowCount() {
            return this.nbPlaces;
        }

        @Override
        public String getColumnName(int col) {
            return Integer.toString(col + 1);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        @Override
        public String getValueAt(int row, int col) {
            return this.juridictions[row][col];
        }
    }
}

