/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve;

import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.releve.MainPanelInterface;
import ancestris.modules.releve.MainPanelRegister;
import ancestris.modules.releve.MenuCommandProvider;
import ancestris.modules.releve.RecordTransferHandle;
import ancestris.modules.releve.ReleveSynthesisDialog;
import ancestris.modules.releve.dnd.TransferableRecord;
import ancestris.modules.releve.editor.Bean;
import ancestris.modules.releve.editor.MainPanelTranscriber;
import ancestris.modules.releve.editor.ReleveEditor;
import ancestris.modules.releve.merge.MergeDialog;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.FieldDate;
import ancestris.modules.releve.model.FieldEventTag;
import ancestris.modules.releve.model.RecordInfoPlace;
import ancestris.modules.releve.model.RecordModelListener;
import ancestris.modules.releve.model.Synthesis;
import ancestris.modules.releve.table.ReleveTable;
import ancestris.modules.releve.table.ReleveTableListener;
import ancestris.modules.releve.table.TableModelRecordAbstract;
import ancestris.modules.releve.table.TableModelRecordAll;
import ancestris.modules.releve.table.TableModelRecordBirth;
import ancestris.modules.releve.table.TableModelRecordDeath;
import ancestris.modules.releve.table.TableModelRecordMarriage;
import ancestris.modules.releve.table.TableModelRecordMisc;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.util.swing.ChoiceWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class RelevePanel
extends JPanel
implements ReleveTableListener {
    private boolean standaloneMode = false;
    private MainPanelInterface transcriber;
    private MenuCommandProvider menuCommandProvider;
    private DataManager dataManager = null;
    private PanelType panelType = null;
    private AbstractRecord.RecordType recordType = null;
    private int currentRecordIndex = -1;
    private static final String dialogTitle = NbBundle.getMessage(RelevePanel.class, (String)"DialogTitle");
    private final JPopupMenu popup = new JPopupMenu();
    private final JMenuItem menuItemInsert = new JMenuItem(NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.insert"));
    private final JMenuItem menuItemDelete = new JMenuItem(NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.delete"));
    private final JMenuItem menuItemMakePhotoFileName = new JMenuItem(NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.makePhotoFileName"));
    private final JMenuItem menuItemSwapNext = new JMenuItem(NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.swapnext"));
    private final JMenuItem menuItemSwapPrevious = new JMenuItem(NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.swapprevious"));
    private final JMenuItem menuItemReorder = new JMenuItem(NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.reorder"));
    private final JCheckBoxMenuItem menuItemGedcomLink = new JCheckBoxMenuItem(NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.gedcomLink"));
    private final JMenuItem menuItemSynthesis = new JMenuItem(NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.synthesis"));
    private final JMenuItem menuItemCopyToGedcom = new JMenuItem(NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.copyToGedcom"));
    private JPanel editorBar;
    private JPanel editorPanel;
    private JButton jButtonBrowser;
    private JButton jButtonCopyToGedcom;
    private JButton jButtonDelete;
    private JButton jButtonNew;
    private JButton jButtonNext;
    private JButton jButtonPrevious;
    private JScrollPane jScrollPaneTable;
    private JSplitPane jSplitPane1;
    private JTextField jTextFielRecordNo;
    private ReleveEditor releveEditor;
    private ReleveTable releveTable;
    private JPanel tablePanel;

    public RelevePanel() {
        this.initComponents();
        this.editorBar.setVisible(false);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jButtonPrevious.setVisible(false);
        this.jTextFielRecordNo.setVisible(false);
        this.jButtonNext.setVisible(false);
        this.jButtonBrowser.setVisible(false);
        this.jButtonDelete.setEnabled(false);
        this.jButtonCopyToGedcom.setEnabled(false);
        String shortCut = "PanelShortcut";
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt S"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt Z"), shortCut);
        this.getActionMap().put(shortCut, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRecord record;
                if (actionEvent.getActionCommand().toUpperCase().equals("C")) {
                    RelevePanel.this.jButtonNewActionPerformed(actionEvent);
                } else if (actionEvent.getActionCommand().toUpperCase().equals("S")) {
                    RelevePanel.this.jButtonDeleteActionPerformed(actionEvent);
                } else if (actionEvent.getActionCommand().toUpperCase().equals("Z") && (record = RelevePanel.this.dataManager.getDataModel().undo()) != null) {
                    RelevePanel.this.selectRecord(RelevePanel.this.dataManager.getDataModel().getIndex(record));
                }
            }
        });
        ActionListener popupMouseHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RelevePanel.this.menuItemInsert.equals(e.getSource())) {
                    RelevePanel.this.insertRecord();
                } else if (RelevePanel.this.menuItemDelete.equals(e.getSource())) {
                    RelevePanel.this.removeRecord();
                } else if (RelevePanel.this.menuItemSwapNext.equals(e.getSource())) {
                    RelevePanel.this.swapRecordNext();
                } else if (RelevePanel.this.menuItemSwapPrevious.equals(e.getSource())) {
                    RelevePanel.this.swapRecordPrevious();
                } else if (RelevePanel.this.menuItemReorder.equals(e.getSource())) {
                    RelevePanel.this.renumberRecords();
                } else if (RelevePanel.this.menuItemGedcomLink.equals(e.getSource())) {
                    RelevePanel.this.showGedcomLink(RelevePanel.this.menuItemGedcomLink.isSelected());
                } else if (RelevePanel.this.menuItemMakePhotoFileName.equals(e.getSource())) {
                    RelevePanel.this.makePhotoFileName();
                } else if (RelevePanel.this.menuItemSynthesis.equals(e.getSource())) {
                    RelevePanel.this.showRecordSynthesis();
                } else if (RelevePanel.this.menuItemCopyToGedcom.equals(e.getSource())) {
                    RelevePanel.this.copyToGedcom();
                }
            }
        };
        this.menuItemInsert.addActionListener(popupMouseHandler);
        this.menuItemInsert.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/NewRecord.png")));
        this.popup.add(this.menuItemInsert);
        this.menuItemDelete.addActionListener(popupMouseHandler);
        this.menuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/DeleteRecord.png")));
        this.popup.add(this.menuItemDelete);
        this.menuItemSwapPrevious.addActionListener(popupMouseHandler);
        this.menuItemSwapPrevious.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/arrowup16.png")));
        this.popup.add(this.menuItemSwapPrevious);
        this.menuItemSwapNext.addActionListener(popupMouseHandler);
        this.menuItemSwapNext.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/arrowdown16.png")));
        this.popup.add(this.menuItemSwapNext);
        this.menuItemReorder.addActionListener(popupMouseHandler);
        this.menuItemReorder.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/reorder16.png")));
        this.popup.add(this.menuItemReorder);
        this.popup.addSeparator();
        this.menuItemGedcomLink.addActionListener(popupMouseHandler);
        this.menuItemGedcomLink.setSelected(false);
        this.menuItemGedcomLink.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/GedcomLink.png")));
        this.popup.add(this.menuItemGedcomLink);
        this.popup.addSeparator();
        this.menuItemMakePhotoFileName.addActionListener(popupMouseHandler);
        this.menuItemMakePhotoFileName.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Copy.png")));
        this.popup.add(this.menuItemMakePhotoFileName);
        this.menuItemSynthesis.addActionListener(popupMouseHandler);
        this.menuItemSynthesis.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Releve.png")));
        this.popup.add(this.menuItemSynthesis);
        this.menuItemCopyToGedcom.addActionListener(popupMouseHandler);
        this.menuItemCopyToGedcom.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/CopyToGedcom.png")));
        this.popup.add(this.menuItemCopyToGedcom);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    RelevePanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.releveTable.addMouseListener(mouseAdapter);
        this.jScrollPaneTable.addMouseListener(mouseAdapter);
        this.tablePanel.addMouseListener(mouseAdapter);
    }

    public JComponent[] getMenuComponents() {
        return new JComponent[]{this.jButtonNew, this.jButtonPrevious, this.jTextFielRecordNo, this.jButtonNext, this.jButtonDelete, this.jButtonCopyToGedcom};
    }

    public void setGedcomLinkSelected(boolean selected) {
        this.menuItemGedcomLink.setSelected(selected);
    }

    public void setModel(DataManager dataManager, PanelType panelType, MenuCommandProvider menuComandProvider, MainPanelTranscriber transcriber) {
        this.menuCommandProvider = menuComandProvider;
        this.dataManager = dataManager;
        this.panelType = panelType;
        final TableModelRecordAbstract tableModel = switch (panelType) {
            case PanelType.birth -> new TableModelRecordBirth(dataManager);
            case PanelType.death -> new TableModelRecordDeath(dataManager);
            case PanelType.marriage -> new TableModelRecordMarriage(dataManager);
            case PanelType.misc -> new TableModelRecordMisc(dataManager);
            default -> new TableModelRecordAll(dataManager);
        };
        this.releveTable.setTableSelectionListener(this);
        this.releveTable.setModel(tableModel);
        this.releveTable.setFocusable(true);
        this.releveTable.requestFocus();
        this.releveTable.setDropMode(DropMode.USE_SELECTION);
        this.releveTable.setTransferHandler(new RecordTransferHandle(dataManager));
        this.releveTable.setDragEnabled(true);
        this.releveEditor.initModel(dataManager, transcriber);
        this.releveEditor.selectRecord(-1);
        RecordModelListener listener = new RecordModelListener(){

            @Override
            public void recordInserted(int firstIndex, int lastIndex) {
                tableModel.fireTableRowsInserted(firstIndex, lastIndex);
                if (firstIndex <= RelevePanel.this.currentRecordIndex && RelevePanel.this.currentRecordIndex <= lastIndex) {
                    RelevePanel.this.selectRecord(RelevePanel.this.currentRecordIndex);
                }
                RelevePanel.this.resizeColumns();
            }

            @Override
            public void recordDeleted(int firstIndex, int lastIndex) {
                tableModel.fireTableRowsDeleted(firstIndex, lastIndex);
                if (firstIndex <= RelevePanel.this.currentRecordIndex && RelevePanel.this.currentRecordIndex <= lastIndex) {
                    RelevePanel.this.selectRecord(-1);
                }
                if (tableModel.getRowCount() > 0) {
                    RelevePanel.this.resizeColumns();
                }
            }

            @Override
            public void recordUpdated(int firstIndex, int lastIndex) {
                tableModel.fireTableRowsUpdated(firstIndex, lastIndex);
                if (firstIndex <= RelevePanel.this.currentRecordIndex && RelevePanel.this.currentRecordIndex <= lastIndex) {
                    RelevePanel.this.releveEditor.selectRecord(RelevePanel.this.currentRecordIndex);
                }
                RelevePanel.this.resizeColumns();
            }

            @Override
            public void recordUpdated(int recordIndex, AbstractRecord.FieldType fieldType) {
                tableModel.fireTableRowsUpdated(recordIndex, recordIndex);
                if (recordIndex == RelevePanel.this.currentRecordIndex) {
                    RelevePanel.this.releveEditor.refreshBeanField(fieldType);
                }
                RelevePanel.this.resizeColumns();
            }

            @Override
            public void allChanged() {
                tableModel.fireTableDataChanged();
                RelevePanel.this.releveEditor.selectRecord(-1);
                RelevePanel.this.resizeColumns();
            }
        };
        dataManager.getDataModel().addRecordModelListener(listener);
        String toolTipText = NbBundle.getMessage(ReleveEditor.class, (String)"ReleveEditor.jButtonNew.toolTipText");
        switch (panelType) {
            case birth: {
                this.jButtonNew.setToolTipText(toolTipText + " (ALT-N)");
                this.recordType = AbstractRecord.RecordType.BIRTH;
                this.popup.remove(this.menuItemReorder);
                break;
            }
            case marriage: {
                this.jButtonNew.setToolTipText(toolTipText + " (ALT-M)");
                this.recordType = AbstractRecord.RecordType.MARRIAGE;
                this.popup.remove(this.menuItemReorder);
                break;
            }
            case death: {
                this.jButtonNew.setToolTipText(toolTipText + " (ALT-D)");
                this.recordType = AbstractRecord.RecordType.DEATH;
                this.popup.remove(this.menuItemReorder);
                break;
            }
            case misc: {
                this.jButtonNew.setToolTipText(toolTipText + " (ALT-V)");
                this.recordType = AbstractRecord.RecordType.MISC;
                this.popup.remove(this.menuItemReorder);
                break;
            }
            default: {
                this.jButtonNew.setToolTipText(toolTipText + " (ALT-T)");
                this.recordType = null;
            }
        }
        if (!this.standaloneMode) {
            int editorWidth = Math.max(300, this.getEditorWidth());
            this.jSplitPane1.getRightComponent().setPreferredSize(new Dimension(editorWidth, this.jSplitPane1.getRightComponent().getHeight()));
        }
    }

    public void resizeColumns() {
        this.releveTable.loadColumnLayout(true);
    }

    public void componentClosed() {
        if (!this.standaloneMode) {
            int editorWidth = this.jSplitPane1.getRightComponent().getWidth();
            this.putEditorWidth(editorWidth);
        }
        this.releveEditor.componentClosed();
        this.releveTable.componentClosed();
    }

    public void selectRecord(int recordIndex) {
        this.currentRecordIndex = recordIndex;
        this.updateToolBar();
        this.releveTable.selectRecord(this.currentRecordIndex);
        this.releveEditor.selectRecord(this.currentRecordIndex);
    }

    public int getCurrentRecordIndex() {
        return this.currentRecordIndex;
    }

    public AbstractRecord getCurrentRecord() {
        return this.dataManager != null ? this.dataManager.getRecord(this.currentRecordIndex) : null;
    }

    public int getRowCount() {
        return this.releveTable.getRowCount();
    }

    public void selectRow(int rowIndex) {
        if (this.releveTable.getRowCount() > 0 && rowIndex != -1) {
            this.selectRecord(this.releveTable.convertRowIndexToModel(rowIndex));
        } else {
            this.selectRecord(-1);
        }
    }

    private void updateToolBar() {
        if (this.currentRecordIndex != -1) {
            this.jButtonDelete.setEnabled(true);
            this.jTextFielRecordNo.setText(String.valueOf(this.currentRecordIndex + 1));
            this.jButtonCopyToGedcom.setEnabled(true);
        } else {
            this.jButtonDelete.setEnabled(false);
            this.jTextFielRecordNo.setText("");
            this.jButtonCopyToGedcom.setEnabled(false);
        }
    }

    public void setTranscriberMode(boolean standalone, MainPanelInterface transcriber) {
        this.standaloneMode = standalone;
        this.transcriber = transcriber;
        this.editorBar.setVisible(standalone);
        this.jButtonPrevious.setVisible(true);
        this.jTextFielRecordNo.setVisible(true);
        this.jButtonNext.setVisible(true);
        this.tablePanel.setVisible(false);
        this.jSplitPane1.setDividerSize(0);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.tablePanel = new JPanel();
        this.jScrollPaneTable = new JScrollPane();
        this.releveTable = new ReleveTable();
        this.editorPanel = new JPanel();
        this.editorBar = new JPanel();
        this.jButtonNew = new JButton();
        this.jButtonPrevious = new JButton();
        this.jTextFielRecordNo = new JTextField();
        this.jButtonNext = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonCopyToGedcom = new JButton();
        this.jButtonBrowser = new JButton();
        this.releveEditor = new ReleveEditor();
        this.setPreferredSize(new Dimension(282, 202));
        this.setLayout(new BorderLayout());
        this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RelevePanel.this.jSplitPane1PropertyChange(evt);
            }
        });
        this.tablePanel.setPreferredSize(new Dimension(0, 0));
        this.tablePanel.setLayout(new BorderLayout());
        this.jScrollPaneTable.setViewportView(this.releveTable);
        this.tablePanel.add((Component)this.jScrollPaneTable, "Center");
        this.jSplitPane1.setLeftComponent(this.tablePanel);
        this.editorPanel.setPreferredSize(new Dimension(270, 100));
        this.editorPanel.setLayout(new BorderLayout(4, 4));
        this.editorBar.setBorder(BorderFactory.createBevelBorder(0));
        this.editorBar.setPreferredSize(new Dimension(447, 45));
        this.editorBar.setLayout(new FlowLayout(0));
        this.jButtonNew.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/NewRecord.png")));
        this.jButtonNew.setToolTipText(NbBundle.getMessage(RelevePanel.class, (String)"RelevePanel.jButtonNew.toolTipText"));
        this.jButtonNew.setActionCommand("CreateRecord");
        this.jButtonNew.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonNew.setPreferredSize(new Dimension(44, 31));
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelevePanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.editorBar.add(this.jButtonNew);
        this.jButtonPrevious.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Back.png")));
        this.jButtonPrevious.setToolTipText(NbBundle.getMessage(RelevePanel.class, (String)"RelevePanel.jButtonPrevious.toolTipText"));
        this.jButtonPrevious.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonPrevious.setPreferredSize(new Dimension(44, 31));
        this.jButtonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelevePanel.this.jButtonPreviousActionPerformed(evt);
            }
        });
        this.editorBar.add(this.jButtonPrevious);
        this.jTextFielRecordNo.setEditable(false);
        this.jTextFielRecordNo.setHorizontalAlignment(0);
        this.jTextFielRecordNo.setToolTipText(NbBundle.getMessage(RelevePanel.class, (String)"RelevePanel.jTextFielRecordNo.toolTipText"));
        this.jTextFielRecordNo.setPreferredSize(new Dimension(45, 31));
        this.editorBar.add(this.jTextFielRecordNo);
        this.jButtonNext.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Forward.png")));
        this.jButtonNext.setToolTipText(NbBundle.getMessage(RelevePanel.class, (String)"RelevePanel.jButtonNext.toolTipText"));
        this.jButtonNext.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonNext.setPreferredSize(new Dimension(44, 31));
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelevePanel.this.jButtonNextActionPerformed(evt);
            }
        });
        this.editorBar.add(this.jButtonNext);
        this.jButtonDelete.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/DeleteRecord.png")));
        this.jButtonDelete.setToolTipText(NbBundle.getMessage(RelevePanel.class, (String)"RelevePanel.jButtonDelete.toolTipText"));
        this.jButtonDelete.setActionCommand("RemoveRecord");
        this.jButtonDelete.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonDelete.setPreferredSize(new Dimension(44, 31));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelevePanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.editorBar.add(this.jButtonDelete);
        this.jButtonCopyToGedcom.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/CopyToGedcom.png")));
        this.jButtonCopyToGedcom.setToolTipText(NbBundle.getMessage(RelevePanel.class, (String)"RelevePanel.jButtonCopyToGedcom.toolTipText"));
        this.jButtonCopyToGedcom.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonCopyToGedcom.setPreferredSize(new Dimension(44, 31));
        this.jButtonCopyToGedcom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelevePanel.this.jButtonCopyToGedcomActionPerformed(evt);
            }
        });
        this.editorBar.add(this.jButtonCopyToGedcom);
        this.jButtonBrowser.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Camera.png")));
        this.jButtonBrowser.setToolTipText(NbBundle.getMessage(RelevePanel.class, (String)"RelevePanel.jButtonBrowser.toolTipText"));
        this.jButtonBrowser.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonBrowser.setPreferredSize(new Dimension(44, 31));
        this.jButtonBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RelevePanel.this.jButtonBrowserActionPerformed(evt);
            }
        });
        this.editorBar.add(this.jButtonBrowser);
        this.jButtonBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RelevePanel.class, (String)"RelevePanel.jButtonBrowser.AccessibleContext.accessibleDescription"));
        this.editorPanel.add((Component)this.editorBar, "North");
        this.releveEditor.setFont(new Font("Arial", 2, 11));
        this.releveEditor.setMinimumSize(new Dimension(250, 300));
        this.releveEditor.setPreferredSize(new Dimension(200, 300));
        this.editorPanel.add((Component)this.releveEditor, "Center");
        this.jSplitPane1.setRightComponent(this.editorPanel);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        this.createRecord();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.removeRecord();
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.releveTable.getRowCount() > 0) {
            int rowIndex = this.releveTable.convertRowIndexToView(this.currentRecordIndex);
            if (rowIndex > 0) {
                this.selectRow(rowIndex - 1);
            } else {
                Toolkit.getDefaultToolkit().beep();
                this.selectRow(this.releveTable.getRowCount() - 1);
            }
        } else {
            this.selectRow(-1);
        }
        this.transcriber.recordSelectionChanged();
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.releveTable.getRowCount() > 0) {
            int rowIndex = this.releveTable.convertRowIndexToView(this.currentRecordIndex);
            if (rowIndex < this.releveTable.getRowCount() - 1) {
                this.selectRow(rowIndex + 1);
            } else {
                Toolkit.getDefaultToolkit().beep();
                this.selectRow(0);
            }
        } else {
            this.selectRow(-1);
        }
        this.transcriber.recordSelectionChanged();
    }

    private void jButtonBrowserActionPerformed(ActionEvent evt) {
    }

    private void jSplitPane1PropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dividerLocation")) {
            int editorWidth = this.jSplitPane1.getRightComponent().getWidth();
            this.putEditorWidth(editorWidth);
        }
    }

    private void jButtonCopyToGedcomActionPerformed(ActionEvent evt) {
        this.copyToGedcom();
    }

    void selectField(AbstractRecord.FieldType fieldType) {
        this.releveEditor.selectField(fieldType);
    }

    public Bean getBean(AbstractRecord.FieldType fieldType) {
        return this.releveEditor.getBean(fieldType);
    }

    public void updatePlace(RecordInfoPlace place) {
        this.releveEditor.updatePlace(place);
    }

    public AbstractRecord createRecord() {
        if (this.verifyCurrentRecord()) {
            AbstractRecord record;
            if (this.panelType != PanelType.all) {
                record = this.dataManager.createRecord(this.recordType);
                this.currentRecordIndex = this.dataManager.addRecord(record);
            } else {
                String title = NbBundle.getMessage(MainPanelRegister.class, (String)"RelevePanel.title");
                String message = NbBundle.getMessage(MainPanelRegister.class, (String)"RelevePanel.createRecord.message");
                Object[] options = new String[]{NbBundle.getMessage(AbstractRecord.class, (String)"record.type.birth"), NbBundle.getMessage(AbstractRecord.class, (String)"record.type.marriage"), NbBundle.getMessage(AbstractRecord.class, (String)"record.type.death"), NbBundle.getMessage(AbstractRecord.class, (String)"record.type.misc"), NbBundle.getMessage(MainPanelRegister.class, (String)"RelevePanel.cancel")};
                Toolkit.getDefaultToolkit().beep();
                Object o = DialogManager.create((String)title, (String)message).setDialogId("relevalAllCreateQuestion").setMessageType(3).setOptions(options).show();
                int result = Arrays.asList(options).indexOf(o);
                switch (result) {
                    case 0: {
                        record = this.dataManager.createRecord(AbstractRecord.RecordType.BIRTH);
                        break;
                    }
                    case 1: {
                        record = this.dataManager.createRecord(AbstractRecord.RecordType.MARRIAGE);
                        break;
                    }
                    case 2: {
                        record = this.dataManager.createRecord(AbstractRecord.RecordType.DEATH);
                        break;
                    }
                    case 3: {
                        record = this.dataManager.createRecord(AbstractRecord.RecordType.MISC);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                this.currentRecordIndex = this.dataManager.addRecord(record);
            }
            this.copyFieldsfromPreviousRecord(record);
            this.updateToolBar();
            this.releveTable.selectRecord(this.currentRecordIndex);
            this.releveEditor.selectRecord(this.currentRecordIndex);
            this.releveEditor.selectFirstField();
            return record;
        }
        return null;
    }

    public void insertRecord() {
        if (this.verifyCurrentRecord()) {
            if (this.panelType != PanelType.all) {
                this.dataManager.insertRecord(this.recordType, this.currentRecordIndex);
            } else {
                String title = NbBundle.getMessage(MainPanelRegister.class, (String)"RelevePanel.title");
                String message = NbBundle.getMessage(MainPanelRegister.class, (String)"RelevePanel.createRecord.message");
                Object[] options = new String[]{NbBundle.getMessage(AbstractRecord.class, (String)"record.type.birth"), NbBundle.getMessage(AbstractRecord.class, (String)"record.type.marriage"), NbBundle.getMessage(AbstractRecord.class, (String)"record.type.death"), NbBundle.getMessage(AbstractRecord.class, (String)"record.type.misc"), NbBundle.getMessage(MainPanelRegister.class, (String)"RelevePanel.cancel")};
                Toolkit.getDefaultToolkit().beep();
                int result = JOptionPane.showOptionDialog(this, message, title, -1, 3, null, options, options[4]);
                switch (result) {
                    case 0: {
                        this.dataManager.insertRecord(AbstractRecord.RecordType.BIRTH, this.currentRecordIndex);
                        break;
                    }
                    case 1: {
                        this.dataManager.insertRecord(AbstractRecord.RecordType.MARRIAGE, this.currentRecordIndex);
                        break;
                    }
                    case 2: {
                        this.dataManager.insertRecord(AbstractRecord.RecordType.DEATH, this.currentRecordIndex);
                        break;
                    }
                    case 3: {
                        this.dataManager.insertRecord(AbstractRecord.RecordType.MISC, this.currentRecordIndex);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            this.copyFieldsfromPreviousRecord(this.dataManager.getRecord(this.currentRecordIndex));
            this.updateToolBar();
            this.releveTable.selectRecord(this.currentRecordIndex);
            this.releveEditor.selectRecord(this.currentRecordIndex);
            this.releveEditor.selectFirstField();
        }
    }

    private void copyFieldsfromPreviousRecord(AbstractRecord record) {
        int previousRecordIndex = this.dataManager.getPreviousRecordIndex();
        AbstractRecord previousRecord = this.dataManager.getDataModel().getRecord(previousRecordIndex);
        if (previousRecord == null) {
            previousRecordIndex = this.dataManager.getDataModel().getRowCount() - 1;
            previousRecord = this.dataManager.getDataModel().getRecord(previousRecordIndex);
            if (previousRecord == null) {
                return;
            }
        }
        if (DataManager.getCopyPlaceEnabled()) {
            record.setFieldValue(AbstractRecord.FieldType.place, previousRecord.getFieldValue(AbstractRecord.FieldType.place));
        }
        if (DataManager.getCopyCoteEnabled()) {
            record.setFieldValue(AbstractRecord.FieldType.cote, previousRecord.getFieldValue(AbstractRecord.FieldType.cote));
        }
        if (DataManager.getCopyEventDateEnabled()) {
            record.setFieldValue(AbstractRecord.FieldType.eventDate, previousRecord.getFieldValue(AbstractRecord.FieldType.eventDate));
        }
        if (DataManager.getCopySecondDateEnabled() && record.getType() == AbstractRecord.RecordType.MISC && previousRecord.getType() == AbstractRecord.RecordType.MISC) {
            record.setFieldValue(AbstractRecord.FieldType.secondDate, previousRecord.getFieldValue(AbstractRecord.FieldType.secondDate));
        }
        if (DataManager.getCopyFreeCommentEnabled()) {
            record.setFieldValue(AbstractRecord.FieldType.freeComment, previousRecord.getFieldValue(AbstractRecord.FieldType.freeComment));
        }
        if (DataManager.getCopyNotaryEnabled() && record.getType() == AbstractRecord.RecordType.MISC && previousRecord.getType() == AbstractRecord.RecordType.MISC) {
            record.setFieldValue(AbstractRecord.FieldType.notary, previousRecord.getFieldValue(AbstractRecord.FieldType.notary));
        }
        if (DataManager.getCopyParishEnabled()) {
            record.setFieldValue(AbstractRecord.FieldType.parish, previousRecord.getFieldValue(AbstractRecord.FieldType.parish));
        }
    }

    public void renumberRecords() {
        if (this.panelType == PanelType.all && this.verifyCurrentRecord()) {
            int[] tableIndexList = new int[this.releveTable.getRowCount()];
            for (int i = 0; i < tableIndexList.length; ++i) {
                tableIndexList[i] = this.releveTable.convertRowIndexToView(i);
            }
            this.dataManager.renumberRecords(this.dataManager.getRecord(this.currentRecordIndex), tableIndexList);
        }
    }

    public void showGedcomLink(boolean state) {
        Utilities.setCursorWaiting((JPanel)this);
        try {
            this.dataManager.showGedcomLink(state, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Utilities.setCursorNormal((JPanel)this);
        this.menuCommandProvider.setGedcomLinkSelected(state);
    }

    public void makePhotoFileName() {
        String name;
        String eventTagLabel;
        String dateStr;
        AbstractRecord record = this.dataManager.getRecord(this.currentRecordIndex);
        if (record == null) {
            JOptionPane.showMessageDialog(this, "No selected record", dialogTitle, 0);
            return;
        }
        try {
            PointInTime pit = ((FieldDate)record.getField(AbstractRecord.FieldType.eventDate)).getPropertyDate().getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
            dateStr = pit.getYear() == Integer.MAX_VALUE || pit.getYear() == Integer.MIN_VALUE ? "" : (pit.getMonth() == Integer.MAX_VALUE || pit.getMonth() == Integer.MIN_VALUE ? String.format("%04d", pit.getYear()) : (pit.getDay() == Integer.MAX_VALUE || pit.getDay() == Integer.MIN_VALUE ? String.format("%04d-%02d", pit.getYear(), pit.getMonth() + 1) : String.format("%04d-%02d-%02d", pit.getYear(), pit.getMonth() + 1, pit.getDay() + 1)));
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            JOptionPane.showMessageDialog(this, ex.getMessage() + " date=" + record.getFieldString(AbstractRecord.FieldType.eventDate), dialogTitle, 0);
            return;
        }
        switch (record.getType()) {
            case BIRTH: {
                eventTagLabel = record.getEventTagLabel();
                name = record.getFieldValue(AbstractRecord.FieldType.indiLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.indiFirstName);
                break;
            }
            case DEATH: {
                eventTagLabel = record.getEventTagLabel();
                name = record.getFieldValue(AbstractRecord.FieldType.indiLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.indiFirstName);
                break;
            }
            case MARRIAGE: {
                eventTagLabel = record.getEventTagLabel();
                name = record.getFieldValue(AbstractRecord.FieldType.indiLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.indiFirstName);
                if (record.getFieldValue(AbstractRecord.FieldType.wifeLastName).isEmpty() && record.getFieldValue(AbstractRecord.FieldType.wifeFirstName).isEmpty()) break;
                name = name + " x ";
                name = name + record.getFieldValue(AbstractRecord.FieldType.wifeLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.wifeFirstName);
                break;
            }
            default: {
                eventTagLabel = record.getEventTagLabel();
                String eventTag = "";
                Field field = record.getField(AbstractRecord.FieldType.eventTag);
                if (field instanceof FieldEventTag) {
                    FieldEventTag tag = (FieldEventTag)field;
                    eventTag = tag.toString();
                }
                if ("MARC".equals(eventTag)) {
                    name = record.getFieldValue(AbstractRecord.FieldType.indiLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.indiFirstName);
                    if (record.getFieldValue(AbstractRecord.FieldType.wifeLastName).isEmpty() && record.getFieldValue(AbstractRecord.FieldType.wifeFirstName).isEmpty()) break;
                    name = name + " x ";
                    name = name + record.getFieldValue(AbstractRecord.FieldType.wifeLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.wifeFirstName);
                    break;
                }
                if ("WILL".equals(eventTag)) {
                    name = record.getFieldValue(AbstractRecord.FieldType.indiLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.indiFirstName);
                    break;
                }
                name = record.getFieldValue(AbstractRecord.FieldType.indiLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.indiFirstName);
                if (record.getFieldValue(AbstractRecord.FieldType.wifeLastName).isEmpty() && record.getFieldValue(AbstractRecord.FieldType.wifeFirstName).isEmpty()) break;
                name = name + "_";
                name = name + record.getFieldValue(AbstractRecord.FieldType.wifeLastName) + " " + record.getFieldValue(AbstractRecord.FieldType.wifeFirstName);
            }
        }
        String SEPARATOR = "_";
        Object cote = "";
        if (!record.getCity().isBlank()) {
            if (!((String)cote).isEmpty()) {
                cote = (String)cote + "_ ";
            }
            cote = (String)cote + record.getCity();
        }
        if (!record.getFieldValue(AbstractRecord.FieldType.notary).isEmpty()) {
            if (!((String)cote).isEmpty()) {
                cote = (String)cote + "_ ";
            }
            cote = (String)cote + record.getFieldValue(AbstractRecord.FieldType.notary);
        }
        if (!record.getFieldValue(AbstractRecord.FieldType.cote).isEmpty()) {
            if (!((String)cote).isEmpty()) {
                cote = (String)cote + "_ ";
            }
            cote = (String)cote + record.getFieldValue(AbstractRecord.FieldType.cote);
        }
        if (!record.getFieldValue(AbstractRecord.FieldType.freeComment).isEmpty()) {
            String[] parts;
            for (String part : parts = record.getFieldValue(AbstractRecord.FieldType.freeComment).split(" |-|_")) {
                try {
                    int page = Integer.parseInt(part);
                    if (page == 0) continue;
                    cote = (String)cote + "_" + part;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        String fileName = String.format("%s_%s_%s_%s.jpg", dateStr, eventTagLabel, name, cote);
        fileName = fileName.replace('/', '-');
        Toolkit.getDefaultToolkit().beep();
        int choice = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(MainPanelRegister.class, (String)"ReleveTopComponent.menu.makePhotoFileName") + ":\n\n" + fileName, dialogTitle, 2);
        if (choice == 0) {
            Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
            CLIPBOARD.setContents(new StringSelection(fileName), null);
        }
    }

    public void showRecordSynthesis() {
        AbstractRecord record = this.dataManager.getRecord(this.currentRecordIndex);
        if (record == null) {
            JOptionPane.showMessageDialog(this, "No selected record", dialogTitle, 0);
            return;
        }
        Synthesis synthesis = new Synthesis(record);
        ReleveSynthesisDialog.show(synthesis.getSynthesisTitle(), synthesis.getSynthesis(true));
    }

    public void removeRecord() {
        if (this.releveTable.getRowCount() == 0) {
            this.currentRecordIndex = -1;
            this.updateToolBar();
            return;
        }
        Toolkit.getDefaultToolkit().beep();
        int choice = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(MainPanelRegister.class, (String)"RelevePanel.removeRecord.message"), dialogTitle, 0, 3);
        switch (choice) {
            case 0: {
                break;
            }
            default: {
                return;
            }
        }
        int rowIndex = this.releveTable.convertRowIndexToView(this.currentRecordIndex);
        this.dataManager.removeRecord(this.dataManager.getRecord(this.currentRecordIndex));
        if (rowIndex < this.releveTable.getRowCount()) {
            this.selectRow(rowIndex);
        } else if (rowIndex > 0) {
            this.selectRow(rowIndex - 1);
        } else {
            this.selectRow(-1);
        }
    }

    private Gedcom getGedcom() {
        Context ctx = GedcomDirectory.getDefault().getDefaultContext();
        return ctx == null ? null : ctx.getGedcom();
    }

    public void copyToGedcom() {
        if (this.releveTable.getRowCount() == 0) {
            this.currentRecordIndex = -1;
            this.updateToolBar();
            return;
        }
        RelevePanel sourceComponent = this;
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            String title = NbBundle.getMessage(this.getClass(), (String)"copyToGedcom.chooseGedcom.title");
            String msg = NbBundle.getMessage(this.getClass(), (String)"copyToGedcom.chooseGedcom.openGedcom");
            Object o = DialogManager.createError((String)title, (String)msg).setDialogId("copyToGedcom.chooseGedcom.error").setMessageType(0).setOptionType(10).show();
            return;
        }
        Context[] contexts = (Context[])GedcomDirectory.getDefault().getContexts().toArray(Context[]::new);
        if (gedcom != null && contexts.length > 1) {
            ArrayList<Gedcom> gedcoms = new ArrayList<Gedcom>();
            for (Context context : contexts) {
                gedcoms.add(context.getGedcom());
            }
            ChoiceWidget gedcomChoices = new ChoiceWidget((Object[])gedcoms.toArray(Gedcom[]::new), (Object)gedcom);
            gedcomChoices.setIgnoreCase(true);
            String title = NbBundle.getMessage(this.getClass(), (String)"copyToGedcom.chooseGedcom.title");
            Object o = DialogManager.create((String)title, (JComponent)gedcomChoices).setDialogId("copyToGedcom.chooseGedcom").setMessageType(3).setOptionType(2).show();
            if (o == DialogManager.OK_OPTION) {
                gedcom = (Gedcom)gedcomChoices.getSelectedItem();
            } else {
                return;
            }
        }
        Entity selectedEntity = null;
        TableModelRecordAbstract model = (TableModelRecordAbstract)this.releveTable.getModel();
        AbstractRecord record = model.getRecord(this.releveTable.convertRowIndexToModel(this.releveTable.getSelectedRow()));
        String fileName = this.dataManager.getCurrentFile() != null ? this.dataManager.getCurrentFile().getName() : "";
        TransferableRecord.TransferableData transferableData = RecordTransferHandle.createTransferableData(this, fileName, record);
        try {
            MergeDialog.show(sourceComponent, gedcom, selectedEntity, transferableData);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private int getEditorWidth() {
        int width = Integer.valueOf(NbPreferences.forModule(RelevePanel.class).get(this.panelType.name() + "Width", "270"));
        return width;
    }

    private void putEditorWidth(int width) {
        String widthStr = String.valueOf(width);
        NbPreferences.forModule(RelevePanel.class).put(this.panelType.name() + "Width", widthStr);
    }

    @Override
    public void swapRecordNext() {
        this.dataManager.swapRecordNext(this.dataManager.getRecord(this.currentRecordIndex));
        this.releveTable.selectRecord(this.currentRecordIndex + 1);
    }

    @Override
    public void swapRecordPrevious() {
        this.dataManager.swapRecordPrevious(this.dataManager.getRecord(this.currentRecordIndex));
        this.releveTable.selectRecord(this.currentRecordIndex - 1);
    }

    @Override
    public void tableRecordSelected(int recordIndex, boolean isNew) {
        this.currentRecordIndex = recordIndex;
        this.updateToolBar();
        this.releveEditor.selectRecord(recordIndex);
    }

    @Override
    public boolean verifyCurrentRecord() {
        return this.releveEditor.verifyCurrentRecord(this.currentRecordIndex);
    }

    public static enum PanelType {
        birth,
        marriage,
        death,
        misc,
        all;

    }
}

