/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.releve.MainPanelInterface;
import ancestris.modules.releve.MainPanelRegister;
import ancestris.modules.releve.ReleveOptionsPanelController;
import ancestris.modules.releve.RelevePanel;
import ancestris.modules.releve.editor.MainPanelTranscriber;
import ancestris.modules.releve.imageAligner.MainPanelCropper;
import ancestris.modules.releve.imageBrowser.BrowserOptionsPanel;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import genj.io.FileAssociation;
import genj.util.Registry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ReleveTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static final String PREFERRED_ID = "ReleveTopComponent";
    private static final Logger LOG = Logger.getLogger("ancestris.releve");
    private final Registry registry = Registry.get(MainPanelRegister.class);
    private final MainPanelInterface[] panels;
    private final JToggleButton[] buttons;
    private final List<MainPanelTranscriber> transcribers;
    public static String TAB_CHANGED = "releve_tab_changed";
    public static String SELECT_RECORD_IN_MAIN_TRANSCRIBER = "select_record_in_main_transcriber";
    public static String OUTPUT_DIR_CHANGED = "output_dir_changed";
    public static String IMAGE_CROPPED = "image_cropped";
    public static String FILE_CHANGED = "file_changed";
    public static String RELOAD_FILE = "reload_file";
    public static String SETTINGS_CHANGED = "settings_changed";
    public static String EXTRACT_INFO = "extract_information";
    private JButton buttonHelp;
    private JButton buttonInfo;
    private JButton buttonSettings;
    private JButton buttonStandaloneEditor;
    private JPanel containerPanel;
    private JToggleButton cropperToggleButton;
    private JLabel infoLabel;
    private JPanel infoPanel;
    private JToolBar mainToolBar;
    private JToggleButton registerToggleButton;
    private JToolBar.Separator separatorFirst;
    private JToolBar.Separator separatorLast;
    private JToggleButton transcriberToggleButton;
    private static final String STANDALONE_EDITOR_SIZE_KEY = "StandaloneEditorSize";

    public ReleveTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(MainPanelRegister.class, (String)"CTL_ReleveTopComponent"));
        this.setToolTipText(NbBundle.getMessage(MainPanelRegister.class, (String)"HINT_ReleveTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)"ancestris/modules/releve/images/Releve.png", (boolean)true));
        MainPanelCropper mainPanelCropper = new MainPanelCropper();
        mainPanelCropper.addPropertyChangeListener(this);
        this.transcribers = new ArrayList<MainPanelTranscriber>();
        MainPanelTranscriber mainPanelTranscriber = new MainPanelTranscriber(false);
        mainPanelTranscriber.addPropertyChangeListener(this);
        this.transcribers.add(mainPanelTranscriber);
        MainPanelRegister mainPanelRegister = new MainPanelRegister(mainPanelTranscriber);
        mainPanelRegister.addPropertyChangeListener(this);
        mainPanelRegister.setTranscriber(mainPanelTranscriber);
        mainPanelTranscriber.setRegister(mainPanelRegister);
        this.panels = new MainPanelInterface[]{mainPanelCropper, mainPanelTranscriber, mainPanelRegister};
        this.buttons = new JToggleButton[]{this.cropperToggleButton, this.transcriberToggleButton, this.registerToggleButton};
        JToggleButton button = this.buttons[this.registry.get("register.mode", 0)];
        button.setSelected(true);
        this.manageToggleButtonsEvent(button);
        this.infoPanel.setVisible(this.registry.get("register.showInfo", true));
        ReleveOptionsPanelController.addReleveListerner(this);
    }

    public int getPersistenceType() {
        return 0;
    }

    public void open() {
        Mode m = WindowManager.getDefault().findMode("ancestris-output");
        if (m != null) {
            m.dockInto((TopComponent)this);
        }
        super.open();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void componentOpened() {
        super.componentOpened();
        AncestrisPlugin.register((Object)this);
    }

    private void initComponents() {
        this.mainToolBar = new JToolBar();
        this.cropperToggleButton = new JToggleButton();
        this.transcriberToggleButton = new JToggleButton();
        this.registerToggleButton = new JToggleButton();
        this.separatorFirst = new JToolBar.Separator();
        this.separatorLast = new JToolBar.Separator();
        this.buttonStandaloneEditor = new JButton();
        this.buttonSettings = new JButton();
        this.buttonInfo = new JButton();
        this.buttonHelp = new JButton();
        this.infoPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.containerPanel = new JPanel();
        this.mainToolBar.setFloatable(false);
        this.mainToolBar.setRollover(true);
        this.cropperToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Cropper.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.cropperToggleButton, (String)NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.cropperToggleButton.text"));
        this.cropperToggleButton.setToolTipText(NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.cropperToggleButton.toolTipText"));
        this.cropperToggleButton.setFocusable(false);
        this.cropperToggleButton.setHorizontalTextPosition(0);
        this.cropperToggleButton.setMargin(new Insets(2, 4, 2, 4));
        this.cropperToggleButton.setPreferredSize(new Dimension(50, 29));
        this.cropperToggleButton.setVerticalTextPosition(3);
        this.cropperToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveTopComponent.this.cropperToggleButtonActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.cropperToggleButton);
        this.transcriberToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Transcriber.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.transcriberToggleButton, (String)NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.transcriberToggleButton.text"));
        this.transcriberToggleButton.setToolTipText(NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.transcriberToggleButton.toolTipText"));
        this.transcriberToggleButton.setFocusable(false);
        this.transcriberToggleButton.setHorizontalTextPosition(0);
        this.transcriberToggleButton.setMargin(new Insets(2, 4, 2, 4));
        this.transcriberToggleButton.setPreferredSize(new Dimension(50, 29));
        this.transcriberToggleButton.setVerticalTextPosition(3);
        this.transcriberToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveTopComponent.this.transcriberToggleButtonActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.transcriberToggleButton);
        this.registerToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Register.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.registerToggleButton, (String)NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.registerToggleButton.text"));
        this.registerToggleButton.setToolTipText(NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.registerToggleButton.toolTipText"));
        this.registerToggleButton.setFocusable(false);
        this.registerToggleButton.setHorizontalTextPosition(0);
        this.registerToggleButton.setMargin(new Insets(2, 4, 2, 4));
        this.registerToggleButton.setPreferredSize(new Dimension(50, 29));
        this.registerToggleButton.setVerticalTextPosition(3);
        this.registerToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveTopComponent.this.registerToggleButtonActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.registerToggleButton);
        this.mainToolBar.add(this.separatorFirst);
        this.mainToolBar.add(this.separatorLast);
        this.buttonStandaloneEditor.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Editor.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.buttonStandaloneEditor, (String)NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.buttonStandaloneEditor.text"));
        this.buttonStandaloneEditor.setToolTipText(NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.buttonStandaloneEditor.toolTipText"));
        this.buttonStandaloneEditor.setFocusable(false);
        this.buttonStandaloneEditor.setHorizontalTextPosition(0);
        this.buttonStandaloneEditor.setVerticalTextPosition(3);
        this.buttonStandaloneEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveTopComponent.this.buttonStandaloneEditorActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.buttonStandaloneEditor);
        this.buttonSettings.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Settings.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.buttonSettings, (String)NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.buttonSettings.text"));
        this.buttonSettings.setToolTipText(NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.buttonSettings.toolTipText"));
        this.buttonSettings.setFocusable(false);
        this.buttonSettings.setHorizontalTextPosition(0);
        this.buttonSettings.setMargin(new Insets(2, 4, 2, 4));
        this.buttonSettings.setPreferredSize(new Dimension(28, 29));
        this.buttonSettings.setVerticalTextPosition(3);
        this.buttonSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveTopComponent.this.buttonSettingsActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.buttonSettings);
        this.buttonInfo.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Information.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.buttonInfo, (String)NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.buttonInfo.text"));
        this.buttonInfo.setToolTipText(NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.buttonInfo.toolTipText"));
        this.buttonInfo.setFocusable(false);
        this.buttonInfo.setHorizontalTextPosition(0);
        this.buttonInfo.setMargin(new Insets(2, 4, 2, 4));
        this.buttonInfo.setPreferredSize(new Dimension(28, 29));
        this.buttonInfo.setVerticalTextPosition(3);
        this.buttonInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveTopComponent.this.buttonInfoActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.buttonInfo);
        this.buttonHelp.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Help.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.buttonHelp, (String)NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.buttonHelp.text"));
        this.buttonHelp.setToolTipText(NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.buttonHelp.toolTipText"));
        this.buttonHelp.setFocusable(false);
        this.buttonHelp.setHorizontalTextPosition(0);
        this.buttonHelp.setMargin(new Insets(2, 4, 2, 4));
        this.buttonHelp.setPreferredSize(new Dimension(28, 29));
        this.buttonHelp.setVerticalTextPosition(3);
        this.buttonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveTopComponent.this.buttonHelpActionPerformed(evt);
            }
        });
        this.mainToolBar.add(this.buttonHelp);
        this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Information.png")));
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(ReleveTopComponent.class, (String)"ReleveTopComponent.infoLabel.text"));
        GroupLayout infoPanelLayout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel).addContainerGap(-1, Short.MAX_VALUE)));
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoLabel));
        this.containerPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainToolBar, -1, 435, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.containerPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.infoPanel, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mainToolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.containerPanel, -1, 198, Short.MAX_VALUE).addContainerGap()));
    }

    private void cropperToggleButtonActionPerformed(ActionEvent evt) {
        this.manageToggleButtonsEvent((JToggleButton)evt.getSource());
    }

    private void transcriberToggleButtonActionPerformed(ActionEvent evt) {
        this.manageToggleButtonsEvent((JToggleButton)evt.getSource());
    }

    private void registerToggleButtonActionPerformed(ActionEvent evt) {
        this.manageToggleButtonsEvent((JToggleButton)evt.getSource());
    }

    private void buttonHelpActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    private void buttonInfoActionPerformed(ActionEvent evt) {
        this.showInfo();
    }

    private void buttonSettingsActionPerformed(ActionEvent evt) {
        this.showSettings();
    }

    private void buttonStandaloneEditorActionPerformed(ActionEvent evt) {
        this.openStandaloneEditor();
    }

    private void manageToggleButtonsEvent(JToggleButton clickedButton) {
        for (int i = 0; i < this.panels.length; ++i) {
            int pos;
            JComponent[] menuComponents;
            if (this.buttons[i].equals(clickedButton) && this.buttons[i].isSelected()) {
                this.registry.put("register.mode", i);
                this.containerPanel.add((JPanel)((Object)this.panels[i]));
                this.infoLabel.setText(this.panels[i].getInfoText());
                menuComponents = this.panels[i].getMenuComponents();
                for (pos = 0; pos < menuComponents.length; ++pos) {
                    this.mainToolBar.add((Component)menuComponents[pos], pos + this.panels.length + 1);
                }
                continue;
            }
            if (this.buttons[i].equals(clickedButton) && !this.buttons[i].isSelected()) {
                this.buttons[i].setSelected(true);
                continue;
            }
            this.containerPanel.remove((JPanel)((Object)this.panels[i]));
            menuComponents = this.panels[i].getMenuComponents();
            for (pos = 0; pos < menuComponents.length; ++pos) {
                this.mainToolBar.remove(menuComponents[pos]);
            }
            this.buttons[i].setSelected(false);
        }
        this.buttonStandaloneEditor.setVisible(this.transcriberToggleButton.isSelected() || this.registerToggleButton.isSelected());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block9: {
            Iterator<MainPanelTranscriber> iterator;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        if (!TAB_CHANGED.equals(e.getPropertyName())) break block8;
                                        JTabbedPane tabPane = (JTabbedPane)e.getOldValue();
                                        JComponent[] selectedComponents = null;
                                        int selectedPos = -1;
                                        for (int index = 0; index < tabPane.getTabCount(); ++index) {
                                            int n;
                                            Component component = tabPane.getComponentAt(index);
                                            if (!(component instanceof RelevePanel)) continue;
                                            RelevePanel panel = (RelevePanel)component;
                                            JComponent[] jcomponents = panel.getMenuComponents();
                                            if (jcomponents.length > 0 && (n = this.mainToolBar.getComponentIndex(jcomponents[0])) > -1) {
                                                selectedPos = n;
                                                for (JComponent c : jcomponents) {
                                                    this.mainToolBar.remove(c);
                                                }
                                            }
                                            if (tabPane.getSelectedIndex() != index) continue;
                                            selectedComponents = jcomponents;
                                        }
                                        if (selectedPos == -1) {
                                            return;
                                        }
                                        for (void var8_30 : selectedComponents) {
                                            this.mainToolBar.add((Component)var8_30, selectedPos++);
                                        }
                                        this.revalidate();
                                        this.repaint();
                                        break block9;
                                    }
                                    if (!SELECT_RECORD_IN_MAIN_TRANSCRIBER.equals(e.getPropertyName())) break block10;
                                    this.transcriberToggleButton.setSelected(true);
                                    this.manageToggleButtonsEvent(this.transcriberToggleButton);
                                    MainPanelRegister mainPanelRegister = (MainPanelRegister)e.getOldValue();
                                    Iterator<MainPanelTranscriber> selectedComponents = this.transcribers.iterator();
                                    if (!selectedComponents.hasNext()) break block9;
                                    MainPanelTranscriber transcriber = selectedComponents.next();
                                    mainPanelRegister.selectRecord(transcriber, (Integer)e.getNewValue());
                                    break block9;
                                }
                                if (!OUTPUT_DIR_CHANGED.equals(e.getPropertyName())) break block11;
                                File outputDirectory = (File)e.getOldValue();
                                Iterator<MainPanelTranscriber> selectedComponents = this.transcribers.iterator();
                                if (!selectedComponents.hasNext()) break block9;
                                MainPanelTranscriber transcriber = selectedComponents.next();
                                transcriber.setBrowserDirectory(outputDirectory);
                                break block9;
                            }
                            if (!IMAGE_CROPPED.equals(e.getPropertyName())) break block12;
                            Iterator<MainPanelTranscriber> outputDirectory = this.transcribers.iterator();
                            if (!outputDirectory.hasNext()) break block9;
                            MainPanelTranscriber transcriber = outputDirectory.next();
                            transcriber.refreshImageList();
                            break block9;
                        }
                        if (!FILE_CHANGED.equals(e.getPropertyName())) break block13;
                        String[] nameAndTip = (String[])e.getOldValue();
                        this.setName(nameAndTip[0]);
                        this.setToolTipText(NbBundle.getMessage(MainPanelRegister.class, (String)"HINT_ReleveTopComponent") + ": " + nameAndTip[0]);
                        for (MainPanelTranscriber transcriber : this.transcribers) {
                            transcriber.setFileName(nameAndTip[0], nameAndTip[1]);
                        }
                        break block9;
                    }
                    if (!RELOAD_FILE.equals(e.getPropertyName())) break block14;
                    MainPanelRegister mainPanelRegister = (MainPanelRegister)e.getOldValue();
                    for (MainPanelTranscriber transcriber : this.transcribers) {
                        mainPanelRegister.updateTranscriber(transcriber);
                    }
                    break block9;
                }
                if (!SETTINGS_CHANGED.equals(e.getPropertyName())) break block15;
                for (MainPanelTranscriber transcriber : this.transcribers) {
                    transcriber.settingsUpdated();
                }
                break block9;
            }
            if (!EXTRACT_INFO.equals(e.getPropertyName()) || !(iterator = this.transcribers.iterator()).hasNext()) break block9;
            MainPanelTranscriber transcriber = iterator.next();
            this.transcriberToggleButton.doClick();
            transcriber.extractInformation(e.getOldValue().toString());
        }
    }

    public boolean canClose() {
        this.setName(NbBundle.getMessage(MainPanelRegister.class, (String)"CTL_ReleveTopComponent"));
        this.setToolTipText(NbBundle.getMessage(MainPanelRegister.class, (String)"HINT_ReleveTopComponent"));
        boolean result = true;
        for (MainPanelInterface panel : this.panels) {
            result &= panel.canClose();
        }
        return result;
    }

    public void componentClosed() {
    }

    private void showSettings() {
        OptionsDisplayer.getDefault().open("Extensions/Releve");
        for (MainPanelTranscriber transcriber : this.transcribers) {
            transcriber.settingsUpdated();
        }
    }

    private void showInfo() {
        this.infoPanel.setVisible(!this.infoPanel.isVisible());
        this.registry.put("register.showInfo", Boolean.valueOf(this.infoPanel.isVisible()));
    }

    private void showHelp() {
        try {
            FileAssociation.getDefault().execute(new URL(NbBundle.getMessage(BrowserOptionsPanel.class, (String)"Releve.helpPage")));
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.FINE, "Unable to open help", ex);
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public DataManager getDataManager() {
        for (MainPanelInterface panel : this.panels) {
            if (!(panel instanceof MainPanelRegister)) continue;
            MainPanelRegister register = (MainPanelRegister)panel;
            return register.getDataManager();
        }
        return null;
    }

    public File getCurrentFile() {
        for (MainPanelInterface panel : this.panels) {
            if (!(panel instanceof MainPanelRegister)) continue;
            MainPanelRegister register = (MainPanelRegister)panel;
            return register.getCurrentFile();
        }
        return null;
    }

    public void selectField(AbstractRecord record, AbstractRecord.FieldType fieldType) {
        for (MainPanelInterface panel : this.panels) {
            if (!(panel instanceof MainPanelRegister)) continue;
            MainPanelRegister register = (MainPanelRegister)panel;
            register.selectField(record, fieldType);
        }
    }

    private void openStandaloneEditor() {
        final JFrame editor = new JFrame(NbBundle.getMessage(MainPanelRegister.class, (String)"CTL_ReleveTopComponent"));
        ImageIcon icon = new ImageIcon(ReleveTopComponent.class.getResource("/ancestris/modules/releve/images/Releve.png"));
        editor.setIconImage(icon.getImage());
        final MainPanelTranscriber transcriber = new MainPanelTranscriber(true);
        editor.getContentPane().add((Component)transcriber, "Center");
        editor.pack();
        editor.setVisible(true);
        String size = NbPreferences.forModule(MainPanelTranscriber.class).get(STANDALONE_EDITOR_SIZE_KEY, "300,450,0,0");
        String[] dimensions = size.split(",");
        editor.setLocationRelativeTo(null);
        editor.setSize(Integer.parseInt(dimensions[0]), Integer.parseInt(dimensions[1]));
        editor.setLocation(Integer.parseInt(dimensions[2]), Integer.parseInt(dimensions[3]));
        editor.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                transcriber.componentClosed();
                String size = editor.getWidth() + "," + editor.getHeight() + "," + editor.getX() + "," + editor.getY();
                NbPreferences.forModule(MainPanelTranscriber.class).put(ReleveTopComponent.STANDALONE_EDITOR_SIZE_KEY, size);
                e.getWindow().dispose();
            }
        });
        transcriber.addPropertyChangeListener(this);
        this.transcribers.add(transcriber);
        ((MainPanelRegister)this.panels[2]).setTranscriber(transcriber);
    }
}

