/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.imageAligner;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ImagePanel
extends JPanel {
    public static final String ZOOM_LEVEL_CHANGED_PROPERTY = "zoomLevel";
    public static final String ZOOM_INCREMENT_CHANGED_PROPERTY = "zoomIncrement";
    public static final String IMAGE_CHANGED_PROPERTY = "image";
    private double zoomIncrement = 0.2;
    private double zoomFactor = 1.0 + this.zoomIncrement;
    private BufferedImage image;
    private double initialScale = 0.0;
    private double scale = 0.0;
    private int originX = 0;
    private int originY = 0;
    private Point previousMousePosition;
    private Dimension previousPanelSize;
    private WheelZoomDevice wheelZoomDevice = null;
    private CoordinateListener coordinateListener;
    private CoordImage alignCoords;
    private CropRectangle imageCropRect = new CropRectangle();
    MouseMode mouseMode = MouseMode.MOVE;

    void frameUpdated() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImagePanel.this.imageCropRect.updatePanelCoords();
                ImagePanel.this.repaint();
            }
        });
    }

    public ImagePanel() {
        this.setOpaque(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ImagePanel.this.scale > 0.0) {
                    if (ImagePanel.this.isFullImageInPanel()) {
                        ImagePanel.this.centerImage();
                    } else if (ImagePanel.this.isImageEdgeInPanel()) {
                        ImagePanel.this.scaleOrigin();
                    }
                    ImagePanel.this.repaint();
                }
                ImagePanel.this.previousPanelSize = ImagePanel.this.getSize();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    e.consume();
                    ImagePanel.this.cropImage();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (ImagePanel.this.image == null) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    if (ImagePanel.this.alignCoords == null) {
                        ImagePanel.this.alignCoords = ImagePanel.this.convertPanelToImageCoords(e.getPoint());
                        ImagePanel.this.coordinateListener.updateAlignCoordinates(ImagePanel.this.alignCoords);
                    } else {
                        ImagePanel.this.alignCoords = null;
                        ImagePanel.this.coordinateListener.updateAlignCoordinates(ImagePanel.this.alignCoords);
                    }
                    ImagePanel.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ImagePanel.this.image == null) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (ImagePanel.this.mouseMode == MouseMode.MOVE) {
                        ImagePanel.this.moveImage(e.getPoint());
                    } else {
                        ImagePanel.this.coordinateListener.updateMouseCoordinates(ImagePanel.this.convertPanelToImageCoords(e.getPoint()));
                        switch (ImagePanel.this.mouseMode) {
                            case CROP_X1: {
                                ImagePanel.this.imageCropRect.dragX1(e.getX());
                                ImagePanel.this.repaint();
                                break;
                            }
                            case CROP_Y1: {
                                ImagePanel.this.imageCropRect.dragY1(e.getY());
                                ImagePanel.this.repaint();
                                break;
                            }
                            case CROP_X2: {
                                ImagePanel.this.imageCropRect.dragX2(e.getX());
                                ImagePanel.this.repaint();
                                break;
                            }
                            case CROP_Y2: {
                                ImagePanel.this.imageCropRect.dragY2(e.getY());
                                ImagePanel.this.repaint();
                                break;
                            }
                        }
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                ImagePanel.this.previousMousePosition = e.getPoint();
                ImagePanel.this.coordinateListener.updateMouseCoordinates(ImagePanel.this.convertPanelToImageCoords(ImagePanel.this.previousMousePosition));
                switch (ImagePanel.this.mouseMode) {
                    case MOVE: {
                        if (ImagePanel.this.imageCropRect.isCropX1(e.getPoint())) {
                            ImagePanel.this.setCursor(Cursor.getPredefinedCursor(10));
                            ImagePanel.this.mouseMode = MouseMode.CROP_X1;
                            break;
                        }
                        if (ImagePanel.this.imageCropRect.isCropY1(e.getPoint())) {
                            ImagePanel.this.setCursor(Cursor.getPredefinedCursor(9));
                            ImagePanel.this.mouseMode = MouseMode.CROP_Y1;
                            break;
                        }
                        if (ImagePanel.this.imageCropRect.isCropX2(e.getPoint())) {
                            ImagePanel.this.setCursor(Cursor.getPredefinedCursor(10));
                            ImagePanel.this.mouseMode = MouseMode.CROP_X2;
                            break;
                        }
                        if (!ImagePanel.this.imageCropRect.isCropY2(e.getPoint())) break;
                        ImagePanel.this.setCursor(Cursor.getPredefinedCursor(9));
                        ImagePanel.this.mouseMode = MouseMode.CROP_Y2;
                        break;
                    }
                    case CROP_X1: {
                        if (ImagePanel.this.imageCropRect.isCropX1(e.getPoint())) break;
                        ImagePanel.this.setCursor(Cursor.getPredefinedCursor(13));
                        ImagePanel.this.mouseMode = MouseMode.MOVE;
                        break;
                    }
                    case CROP_Y1: {
                        if (ImagePanel.this.imageCropRect.isCropY1(e.getPoint())) break;
                        ImagePanel.this.setCursor(Cursor.getPredefinedCursor(13));
                        ImagePanel.this.mouseMode = MouseMode.MOVE;
                        break;
                    }
                    case CROP_X2: {
                        if (ImagePanel.this.imageCropRect.isCropX2(e.getPoint())) break;
                        ImagePanel.this.setCursor(Cursor.getPredefinedCursor(13));
                        ImagePanel.this.mouseMode = MouseMode.MOVE;
                        break;
                    }
                    case CROP_Y2: {
                        if (ImagePanel.this.imageCropRect.isCropY2(e.getPoint())) break;
                        ImagePanel.this.setCursor(Cursor.getPredefinedCursor(13));
                        ImagePanel.this.mouseMode = MouseMode.MOVE;
                        break;
                    }
                }
            }
        });
        this.wheelZoomDevice = new WheelZoomDevice();
        this.addMouseWheelListener(this.wheelZoomDevice);
        this.setCursor(Cursor.getPredefinedCursor(13));
    }

    void setCoordinateListener(CoordinateListener coordinateListener) {
        this.coordinateListener = coordinateListener;
    }

    public void cropImage() {
        if (this.alignCoords != null) {
            AffineTransform tx = new AffineTransform();
            tx.translate(-this.alignCoords.x, -this.alignCoords.y);
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            this.image = op.filter(this.image, null);
        }
        this.repaint();
        int tmpCropX = this.imageCropRect.imageCoords.x;
        int tmpCropY = this.imageCropRect.imageCoords.y;
        int tmpCropW = this.imageCropRect.imageCoords.width;
        int tmpCropH = this.imageCropRect.imageCoords.height;
        if (tmpCropX < 0) {
            tmpCropX = 0;
        }
        if (tmpCropY < 0) {
            tmpCropY = 0;
        }
        if (tmpCropX + tmpCropW > this.image.getWidth()) {
            tmpCropW = Math.max(0, this.image.getWidth() - tmpCropX);
        }
        if (tmpCropY + tmpCropH > this.image.getHeight()) {
            tmpCropH = Math.max(0, this.image.getHeight() - tmpCropY);
        }
        try {
            final BufferedImage croppedImage = this.image.getSubimage(tmpCropX, tmpCropY, tmpCropW, tmpCropH);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImagePanel.this.coordinateListener.saveCurrentImage(croppedImage);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showImage(BufferedImage newImage) {
        this.image = newImage;
        this.repaint();
    }

    public void moveToLeft() {
        if (this.image != null) {
            this.originX = 0;
            this.repaint();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void moveToRight() {
        if (this.image != null) {
            this.originX = this.getWidth() - this.getScreenImageWidth();
            this.repaint();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void moveToTop() {
        if (this.image != null) {
            this.originY = 0;
            this.repaint();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void moveToBottom() {
        if (this.image != null) {
            this.originY = this.getHeight() - this.getScreenImageHeight();
            this.repaint();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public boolean isleftSideVisible() {
        return this.originX >= 0;
    }

    public boolean isRightSideVisible() {
        if (this.image != null) {
            return this.originX + this.getScreenImageWidth() <= this.getWidth();
        }
        return true;
    }

    public boolean isTopSideVisible() {
        return this.originY >= 0;
    }

    public boolean isBottomSideVisible() {
        if (this.image != null) {
            return this.originY + this.getScreenImageHeight() <= this.getHeight();
        }
        return true;
    }

    private CoordImage convertPanelToImageCoords(Point p) {
        return new CoordImage((double)(p.x - this.originX) / this.scale, (double)(p.y - this.originY) / this.scale);
    }

    private CoordPanel convertImageToPanelCoords(CoordImage p) {
        return new CoordPanel((double)p.x * this.scale + (double)this.originX, (double)p.y * this.scale + (double)this.originY);
    }

    private boolean isImageEdgeInPanel() {
        if (this.previousPanelSize == null) {
            return false;
        }
        return this.originX > 0 && this.originX < this.previousPanelSize.width || this.originY > 0 && this.originY < this.previousPanelSize.height;
    }

    private boolean isFullImageInPanel() {
        return this.originX >= 0 && this.originX + this.getScreenImageWidth() < this.getWidth() && this.originY >= 0 && this.originY + this.getScreenImageHeight() < this.getHeight();
    }

    private void scaleOrigin() {
        this.originX = this.originX * this.getWidth() / this.previousPanelSize.width;
        this.originY = this.originY * this.getHeight() / this.previousPanelSize.height;
        this.repaint();
    }

    private double zoomToScale(double zoom) {
        return this.initialScale * zoom;
    }

    public double getZoom() {
        return this.scale / this.initialScale;
    }

    public void setZoom(double newZoom, Point zoomingCenter) {
        if (this.image != null) {
            CoordImage imageP = this.convertPanelToImageCoords(zoomingCenter);
            if (imageP.x < 0) {
                imageP.x = 0;
            }
            if (imageP.y < 0) {
                imageP.y = 0;
            }
            if (imageP.x >= this.image.getWidth()) {
                imageP.x = this.image.getWidth() - 1;
            }
            if (imageP.y >= this.image.getHeight()) {
                imageP.y = this.image.getHeight() - 1;
            }
            CoordPanel correctedP = this.convertImageToPanelCoords(imageP);
            this.scale = this.zoomToScale(newZoom);
            CoordPanel panelP = this.convertImageToPanelCoords(imageP);
            this.originX += correctedP.x - panelP.x;
            this.originY += correctedP.y - panelP.y;
        }
        this.repaint();
    }

    private void centerImage() {
        this.originX = (this.getWidth() - this.getScreenImageWidth()) / 2;
        this.originY = (this.getHeight() - this.getScreenImageHeight()) / 2;
    }

    private void moveImage(Point newMousePosition) {
        int xDelta = newMousePosition.x - this.previousMousePosition.x;
        int yDelta = newMousePosition.y - this.previousMousePosition.y;
        this.originX += xDelta;
        this.originY += yDelta;
        this.previousMousePosition = newMousePosition;
        this.imageCropRect.updatePanelCoords();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        if (this.scale == 0.0) {
            double xScale = (double)this.getWidth() / (double)this.image.getWidth();
            double yScale = (double)this.getHeight() / (double)this.image.getHeight();
            this.scale = this.initialScale = Math.min(xScale, yScale);
            this.centerImage();
            this.imageCropRect.setImageBounds(0, 0, this.image.getWidth(), this.image.getHeight());
        }
        g.drawImage(this.image, this.originX, this.originY, this.getScreenImageWidth(), this.getScreenImageHeight(), null);
        if (this.alignCoords != null && this.alignCoords.x != 0 && this.alignCoords.y != 0) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.RED);
            CoordPanel coordPanel = this.convertImageToPanelCoords(this.alignCoords);
            g2d.drawLine(coordPanel.x, 0, coordPanel.x, this.getScreenImageHeight());
            g2d.setColor(Color.ORANGE);
            g2d.drawLine(0, coordPanel.y, this.getScreenImageWidth(), coordPanel.y);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.RED);
        g2d.draw(this.imageCropRect);
    }

    private int getScreenImageWidth() {
        if (this.image != null) {
            return (int)(this.scale * (double)this.image.getWidth());
        }
        return 0;
    }

    private int getScreenImageHeight() {
        if (this.image != null) {
            return (int)(this.scale * (double)this.image.getHeight());
        }
        return 0;
    }

    private class WheelZoomDevice
    implements MouseWheelListener {
        private WheelZoomDevice() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Point p = e.getPoint();
            boolean zoomIn = e.getWheelRotation() < 0;
            ImagePanel.this.zoomFactor = zoomIn ? 1.0 + ImagePanel.this.zoomIncrement : 1.0 - ImagePanel.this.zoomIncrement;
            CoordImage imageP = ImagePanel.this.convertPanelToImageCoords(ImagePanel.this.previousMousePosition);
            ImagePanel.this.scale *= ImagePanel.this.zoomFactor;
            CoordPanel coordPanel = ImagePanel.this.convertImageToPanelCoords(imageP);
            ImagePanel.this.originX += ImagePanel.this.previousMousePosition.x - coordPanel.x;
            ImagePanel.this.originY += ImagePanel.this.previousMousePosition.y - coordPanel.y;
            ImagePanel.this.imageCropRect.updatePanelCoords();
            ImagePanel.this.repaint();
        }
    }

    protected class CropRectangle
    extends Rectangle {
        Rectangle imageCoords = new Rectangle();
        private final int marge = 3;

        protected CropRectangle() {
        }

        void setImageBounds(int x, int y, int width, int height) {
            this.imageCoords.x = x;
            this.imageCoords.y = y;
            this.imageCoords.width = width;
            this.imageCoords.height = height;
            this.updatePanelCoords();
        }

        void updatePanelCoords() {
            this.x = (int)((double)this.imageCoords.x * ImagePanel.this.scale + (double)ImagePanel.this.originX);
            this.y = (int)((double)this.imageCoords.y * ImagePanel.this.scale + (double)ImagePanel.this.originY);
            this.width = (int)((double)this.imageCoords.width * ImagePanel.this.scale);
            this.height = (int)((double)this.imageCoords.height * ImagePanel.this.scale);
        }

        boolean isCropX1(Point point) {
            return point.x > this.x - 3 && point.x < this.x + 3 && point.y > this.y && point.y < this.y + this.height;
        }

        boolean isCropY1(Point point) {
            return point.x > this.x && point.x < this.x + this.width && point.y > this.y - 3 && point.y < this.y + 3;
        }

        boolean isCropX2(Point point) {
            return point.x > this.x + this.width - 3 && point.x < this.x + this.width + 3 && point.y > this.y && point.y < this.y + this.height;
        }

        boolean isCropY2(Point point) {
            return point.x > this.x && point.x < this.x + this.width && point.y > this.y + this.height - 3 && point.y < this.y + this.height + 3;
        }

        void dragX1(int x1) {
            this.width += this.x - x1;
            this.x = x1;
            this.imageCoords.x = (int)((double)(this.x - ImagePanel.this.originX) / ImagePanel.this.scale);
            this.imageCoords.width = (int)((double)this.width / ImagePanel.this.scale);
        }

        void dragY1(int y1) {
            this.height += this.y - y1;
            this.y = y1;
            this.imageCoords.y = (int)((double)(this.y - ImagePanel.this.originY) / ImagePanel.this.scale);
            this.imageCoords.height = (int)((double)this.height / ImagePanel.this.scale);
        }

        void dragX2(int x2) {
            this.width = x2 - this.x;
            this.imageCoords.width = (int)((double)this.width / ImagePanel.this.scale);
        }

        void dragY2(int y2) {
            this.height = y2 - this.y;
            this.imageCoords.height = (int)((double)this.height / ImagePanel.this.scale);
        }
    }

    protected static enum MouseMode {
        MOVE,
        CROP_X1,
        CROP_Y1,
        CROP_X2,
        CROP_Y2;

    }

    static interface CoordinateListener {
        public void updateMouseCoordinates(CoordImage var1);

        public void updateAlignCoordinates(CoordImage var1);

        public void saveCurrentImage(BufferedImage var1);
    }

    protected class CoordImage {
        public int x;
        public int y;

        public CoordImage(double x, double y) {
            this.x = (int)Math.round(x);
            this.y = (int)Math.round(y);
        }

        public CoordImage(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "[Coords: x=" + this.x + ",y=" + this.y + "]";
        }
    }

    protected class CoordPanel
    extends Point {
        public CoordPanel(double x, double y) {
            this.x = (int)Math.round(x);
            this.y = (int)Math.round(y);
        }

        @Override
        public String toString() {
            return "[Coords: x=" + this.x + ",y=" + this.y + "]";
        }
    }
}

