/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.dnd.TransferableRecord;
import ancestris.modules.releve.merge.MergeQuery;
import ancestris.modules.releve.merge.SpouseTag;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.RecordInfoPlace;
import ancestris.modules.releve.model.Synthesis;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertySex;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MergeRecord {
    private final RecordInfoPlace recordInfoPlace = new RecordInfoPlace();
    private final String fileName;
    private final RecordType recordType;
    private final String eventTypeTag;
    private final String eventType;
    private final String eventCote;
    private final String freeComment;
    private final PropertyDate eventDate;
    private final PropertyDate eventSecondDate;
    private final String notary;
    private final String parish;
    private final String generalComment;
    private final String deedText;
    private final String eventMedia;
    private RecordResidence m_eventResidence;
    private final RecordParticipant participant1;
    private final RecordParticipant participant2;
    private final RecordWitness witness1 = new RecordWitness();
    private final RecordWitness witness2 = new RecordWitness();
    private final RecordWitness witness3 = new RecordWitness();
    private final RecordWitness witness4 = new RecordWitness();
    private final RecordMarriageFamily family;
    private static final Pattern jjmmaaaa = Pattern.compile("([0-9]{1,2})/([0-9]{1,2})/([0-9]{4,4})");
    private static final Pattern mmaaaa = Pattern.compile("([0-9]{1,2})/([0-9]{4,4})");
    private static final Pattern aaaa = Pattern.compile("([0-9]{4,4})");

    public MergeRecord(TransferableRecord.TransferableData data) {
        this.fileName = data.fileName;
        this.recordInfoPlace.setCityName(data.cityName);
        this.recordInfoPlace.setCityCode(data.cityCode);
        this.recordInfoPlace.setCountyName(data.countyName);
        this.recordInfoPlace.setStateName(data.stateName);
        this.recordInfoPlace.setCountryName(data.countryName);
        if (data.recordType.equals(RecordType.BIRTH.name())) {
            this.recordType = RecordType.BIRTH;
            this.eventTypeTag = "BIRT";
        } else if (data.recordType.equals(RecordType.MARRIAGE.name())) {
            this.recordType = RecordType.MARRIAGE;
            this.eventTypeTag = "MARR";
        } else if (data.recordType.equals(RecordType.DEATH.name())) {
            this.recordType = RecordType.DEATH;
            this.eventTypeTag = "DEAT";
        } else {
            this.recordType = RecordType.MISC;
            this.eventTypeTag = data.eventTag;
        }
        this.eventType = data.eventType;
        this.eventCote = data.cote;
        this.freeComment = data.freeComment;
        this.eventDate = this.parseDateString(data.eventDate);
        this.eventSecondDate = this.parseDateString(data.secondDate);
        this.notary = data.notary;
        this.parish = data.parish;
        this.generalComment = data.generalComment;
        this.deedText = data.deedText;
        this.eventMedia = data.eventMedia;
        this.participant1 = new RecordParticipant(this, MergeParticipantType.participant1);
        this.participant1.m_FirstName = this.formatFirstName(data.participant1.firstName);
        this.participant1.m_LastName = data.participant1.lastName;
        this.participant1.m_Sex = SexType.fromString(data.participant1.sex);
        this.participant1.m_Age.setValue(data.participant1.age);
        this.participant1.m_BirthDate = this.parseDateString(data.participant1.birthDate);
        this.participant1.m_BirthResidence.m_place = data.participant1.birthPlace;
        this.participant1.m_BirthResidence.m_address = data.participant1.birthAddress;
        this.participant1.m_Occupation = data.participant1.occupation;
        this.participant1.m_Residence.m_place = data.participant1.residence;
        this.participant1.m_Residence.m_address = data.participant1.address;
        this.participant1.m_DeathDate = this.parseDateString(data.participant1.deathDate);
        this.participant1.m_DeathResidence.m_place = data.participant1.deathPlace;
        this.participant1.m_DeathResidence.m_address = data.participant1.deathAddress;
        this.participant1.m_Comment = data.participant1.comment;
        this.participant1.m_marriedFamily.m_married.m_firstName = this.formatFirstName(data.participant1.marriedFirstName);
        this.participant1.m_marriedFamily.m_married.m_lastName = data.participant1.marriedLastName;
        this.participant1.m_marriedFamily.m_married.m_sex = this.participant1.getSex() == 0 || this.participant1.m_marriedFamily.m_married.m_lastName.isEmpty() ? new SexType("U") : (this.participant1.getSex() == 1 ? new SexType("F") : new SexType("M"));
        this.participant1.m_marriedFamily.m_married.m_comment = data.participant1.marriedComment;
        this.participant1.m_marriedFamily.m_married.m_occupation = data.participant1.marriedOccupation;
        this.participant1.m_marriedFamily.m_married.m_residence.m_place = data.participant1.marriedResidence;
        this.participant1.m_marriedFamily.m_married.m_residence.m_address = data.participant1.marriedAddress;
        this.participant1.m_marriedFamily.m_married.m_dead = DeadState.fromString(data.participant1.marriedDead);
        this.participant1.getFather().m_firstName = this.formatFirstName(data.participant1.fatherFirstName);
        this.participant1.getFather().m_lastName = data.participant1.fatherLastName;
        this.participant1.getFather().m_sex = SexType.fromString("M");
        this.participant1.getFather().m_occupation = data.participant1.fatherOccupation;
        this.participant1.getFather().m_residence.m_place = data.participant1.fatherResidence;
        this.participant1.getFather().m_residence.m_address = data.participant1.fatherAddress;
        this.participant1.getFather().m_age.setValue(data.participant1.fatherAge);
        this.participant1.getFather().m_dead = DeadState.fromString(data.participant1.fatherDead);
        this.participant1.getFather().m_comment = data.participant1.fatherComment;
        this.participant1.getMother().m_firstName = this.formatFirstName(data.participant1.motherFirstName);
        this.participant1.getMother().m_lastName = data.participant1.motherLastName;
        this.participant1.getMother().m_sex = SexType.fromString("F");
        this.participant1.getMother().m_occupation = data.participant1.motherOccupation;
        this.participant1.getMother().m_residence.m_place = data.participant1.motherResidence;
        this.participant1.getMother().m_residence.m_address = data.participant1.motherAddress;
        this.participant1.getMother().m_age.setValue(data.participant1.motherAge);
        this.participant1.getMother().m_dead = DeadState.fromString(data.participant1.motherDead);
        this.participant1.getMother().m_comment = data.participant1.motherComment;
        this.participant2 = new RecordParticipant(this, MergeParticipantType.participant2);
        this.participant2.m_FirstName = this.formatFirstName(data.participant2.firstName);
        this.participant2.m_LastName = data.participant2.lastName;
        this.participant2.m_Sex = SexType.fromString(data.participant2.sex);
        this.participant2.m_Age.setValue(data.participant2.age);
        this.participant2.m_BirthDate = this.parseDateString(data.participant2.birthDate);
        this.participant2.m_BirthResidence.m_place = data.participant2.birthPlace;
        this.participant2.m_BirthResidence.m_address = data.participant2.birthAddress;
        this.participant2.m_Occupation = data.participant2.occupation;
        this.participant2.m_Residence.m_place = data.participant2.residence;
        this.participant2.m_Residence.m_address = data.participant2.address;
        this.participant2.m_Comment = data.participant2.comment;
        this.participant2.m_marriedFamily.m_married.m_firstName = this.formatFirstName(data.participant2.marriedFirstName);
        this.participant2.m_marriedFamily.m_married.m_lastName = data.participant2.marriedLastName;
        this.participant2.m_marriedFamily.m_married.m_sex = this.participant2.getSex() == 0 || this.participant2.m_marriedFamily.m_married.m_lastName.isEmpty() ? new SexType("U") : (this.participant2.getSex() == 1 ? new SexType("F") : new SexType("M"));
        this.participant2.m_marriedFamily.m_married.m_comment = data.participant2.marriedComment;
        this.participant2.m_marriedFamily.m_married.m_occupation = data.participant2.marriedOccupation;
        this.participant2.m_marriedFamily.m_married.m_residence.m_place = data.participant2.marriedResidence;
        this.participant2.m_marriedFamily.m_married.m_residence.m_address = data.participant2.marriedAddress;
        this.participant2.m_marriedFamily.m_married.m_dead = DeadState.fromString(data.participant2.marriedDead);
        this.participant2.getFather().m_firstName = this.formatFirstName(data.participant2.fatherFirstName);
        this.participant2.getFather().m_lastName = data.participant2.fatherLastName;
        this.participant2.getFather().m_sex = SexType.fromString("M");
        this.participant2.getFather().m_occupation = data.participant2.fatherOccupation;
        this.participant2.getFather().m_residence.m_place = data.participant2.fatherResidence;
        this.participant2.getFather().m_residence.m_address = data.participant2.fatherAddress;
        this.participant2.getFather().m_age.setValue(data.participant2.fatherAge);
        this.participant2.getFather().m_dead = DeadState.fromString(data.participant2.fatherDead);
        this.participant2.getFather().m_comment = data.participant2.fatherComment;
        this.participant2.getMother().m_firstName = this.formatFirstName(data.participant2.motherFirstName);
        this.participant2.getMother().m_lastName = data.participant2.motherLastName;
        this.participant2.getMother().m_sex = SexType.fromString("F");
        this.participant2.getMother().m_occupation = data.participant2.motherOccupation;
        this.participant2.getMother().m_residence.m_place = data.participant2.motherResidence;
        this.participant2.getMother().m_residence.m_address = data.participant2.motherAddress;
        this.participant2.getMother().m_age.setValue(data.participant2.motherAge);
        this.participant2.getMother().m_dead = DeadState.fromString(data.participant2.motherDead);
        this.participant2.getMother().m_comment = data.participant2.motherComment;
        this.witness1.m_firstName = this.formatFirstName(data.witness1.firstName);
        this.witness1.m_lastName = data.witness1.lastName;
        this.witness1.m_occupation = data.witness1.occupation;
        this.witness1.m_comment = data.witness1.comment;
        this.witness2.m_firstName = this.formatFirstName(data.witness2.firstName);
        this.witness2.m_lastName = data.witness2.lastName;
        this.witness2.m_occupation = data.witness2.occupation;
        this.witness2.m_comment = data.witness2.comment;
        this.witness3.m_firstName = this.formatFirstName(data.witness3.firstName);
        this.witness3.m_lastName = data.witness3.lastName;
        this.witness3.m_occupation = data.witness3.occupation;
        this.witness3.m_comment = data.witness3.comment;
        this.witness4.m_firstName = this.formatFirstName(data.witness4.firstName);
        this.witness4.m_lastName = data.witness4.lastName;
        this.witness4.m_occupation = data.witness4.occupation;
        this.witness4.m_comment = data.witness4.comment;
        this.family = new RecordMarriageFamily(this.participant1, this.participant2);
    }

    private PropertyDate parseDateString(String dateString) {
        PropertyDate dateResult = new PropertyDate();
        String inputDate = dateString.trim();
        Matcher matcher = jjmmaaaa.matcher(inputDate);
        if (matcher.matches()) {
            PointInTime pit = new PointInTime(Integer.parseInt(matcher.group(1)) - 1, Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)));
            dateResult.setValue(dateResult.getFormat(), pit, null, null);
        } else {
            matcher = mmaaaa.matcher(inputDate);
            if (matcher.matches()) {
                PointInTime pit = new PointInTime(Integer.MAX_VALUE, Integer.parseInt(matcher.group(1)) - 1, Integer.parseInt(matcher.group(2)));
                dateResult.setValue(dateResult.getFormat(), pit, null, null);
            } else {
                matcher = aaaa.matcher(inputDate);
                if (matcher.matches()) {
                    PointInTime pit = new PointInTime(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.parseInt(matcher.group(1)));
                    dateResult.setValue(dateResult.getFormat(), pit, null, null);
                } else {
                    dateResult.setValue(inputDate);
                }
            }
        }
        return dateResult;
    }

    RecordParticipant getIndi() {
        return this.participant1;
    }

    RecordParticipant getWife() {
        return this.participant2;
    }

    RecordMarriageFamily getFamily() {
        return this.family;
    }

    RecordParticipant getParticipant(MergeParticipantType mergeParticipantType) {
        if (mergeParticipantType == MergeParticipantType.participant1) {
            return this.participant1;
        }
        return this.participant2;
    }

    RecordType getRecordType() {
        return this.recordType;
    }

    String getEventTypeTag() {
        return this.eventTypeTag;
    }

    String getEventType() {
        return this.eventType;
    }

    String getEventTypeWithDate() {
        Object eventTypeWithDate = this.eventType;
        if (!this.recordInfoPlace.getValue().isEmpty()) {
            if (!((String)eventTypeWithDate).isEmpty()) {
                eventTypeWithDate = (String)eventTypeWithDate + ", ";
            }
            eventTypeWithDate = (String)eventTypeWithDate + this.recordInfoPlace.getValue();
        }
        if (!((String)eventTypeWithDate).isEmpty()) {
            eventTypeWithDate = (String)eventTypeWithDate + " (" + this.getEventDate().getDisplayValue() + ")";
        }
        return eventTypeWithDate;
    }

    String getFileName() {
        return this.fileName;
    }

    String getEventCote() {
        return this.eventCote;
    }

    String getEventPage() {
        return this.freeComment;
    }

    PropertyDate getEventDate() {
        return this.eventDate;
    }

    String getEventDateDDMMYYYY(boolean showFrenchCalendarDate) {
        Object result = MergeRecord.formatDateDDMMYYYY(this.eventDate);
        if (showFrenchCalendarDate) {
            try {
                String frenchCalendarDate = this.eventDate.getStart().getPointInTime((Calendar)PointInTime.FRENCHR).toString();
                if (!frenchCalendarDate.isEmpty()) {
                    result = (String)result + " (" + frenchCalendarDate + ")";
                }
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
        }
        return result;
    }

    String getEventDeedText() {
        return this.deedText;
    }

    String getEventMedia() {
        return this.eventMedia;
    }

    PropertyDate getInsinuationDate() {
        return this.eventSecondDate;
    }

    private String formatFirstName(String namePiece) {
        if (namePiece.isEmpty()) {
            return "";
        }
        String result = namePiece.trim().replaceAll(" +", " ").replaceAll(" *, *", ",");
        return result.replaceAll(",", ", ");
    }

    static String formatDateDDMMYYYY(PropertyDate dateProperty) {
        try {
            PointInTime pit = dateProperty.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
            String result = pit.getYear() == Integer.MAX_VALUE || pit.getYear() == Integer.MIN_VALUE ? "" : (pit.getMonth() == Integer.MAX_VALUE || pit.getMonth() == Integer.MIN_VALUE ? String.format("%04d", pit.getYear()) : (pit.getDay() == Integer.MAX_VALUE || pit.getDay() == Integer.MIN_VALUE ? String.format("%02d/%04d", pit.getMonth() + 1, pit.getYear()) : String.format("%02d/%02d/%04d", pit.getDay() + 1, pit.getMonth() + 1, pit.getYear())));
            return result;
        }
        catch (GedcomException ex) {
            return "";
        }
    }

    String getInsinuationDateDDMMYYYY(boolean showFrenchCalendarDate) {
        Object result = MergeRecord.formatDateDDMMYYYY(this.eventSecondDate);
        if (showFrenchCalendarDate) {
            try {
                String frenchCalendarDate = this.eventSecondDate.getStart().getPointInTime((Calendar)PointInTime.FRENCHR).toString();
                if (!frenchCalendarDate.isEmpty()) {
                    result = (String)result + " (" + frenchCalendarDate + ")";
                }
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
        }
        return result;
    }

    String getInsinuationType() {
        return NbBundle.getMessage(MergeRecord.class, (String)"MergeModel.EventInsinuationType") + " " + this.getEventTagName();
    }

    RecordResidence getEventResidence() {
        if (this.m_eventResidence == null) {
            this.m_eventResidence = new RecordResidence();
            this.m_eventResidence.m_address = "";
            this.m_eventResidence.m_place = this.recordInfoPlace.getValue();
        }
        return this.m_eventResidence;
    }

    String getEventPlace() {
        return this.recordInfoPlace.getValue();
    }

    String getEventPlaceCityName() {
        return this.recordInfoPlace.getCityName();
    }

    String getEventPlaceCityCode() {
        return this.recordInfoPlace.getCityCode();
    }

    String getEventPlaceCountyName() {
        return this.recordInfoPlace.getCountyName();
    }

    String getEventTagName() {
        return Gedcom.getName((String)this.eventTypeTag);
    }

    String getNotary() {
        return this.notary;
    }

    public String getEventComment(boolean showFrenchCalendarDate) {
        return (switch (this.recordType) {
            case RecordType.BIRTH -> this.makeBirthComment(showFrenchCalendarDate);
            case RecordType.MARRIAGE -> this.makeMarriageComment(showFrenchCalendarDate);
            case RecordType.DEATH -> this.makeDeathComment(showFrenchCalendarDate);
            default -> this.makeMiscComment(showFrenchCalendarDate);
        }).replaceAll(",+", ",");
    }

    public String getTitle() {
        MergeRecord record = this;
        if (record == null) {
            return "";
        }
        switch (this.getEventTypeTag()) {
            case "BIRT": {
                String message = record.getIndi().getFirstName() + " " + record.getIndi().getLastName() + " " + record.getEventDate().getDisplayValue();
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.birth", (Object)message);
            }
            case "DEAT": {
                String message = record.getIndi().getFirstName() + " " + record.getIndi().getLastName() + " " + record.getEventDate().getDisplayValue();
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.death", (Object)message);
            }
            case "MARR": {
                String husband = record.getIndi().getFirstName() + " " + record.getIndi().getLastName();
                String wife = record.getWife().getFirstName() + " " + record.getWife().getLastName() + " " + record.getEventDate().getDisplayValue();
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.marriage", (Object)husband, (Object)wife);
            }
            case "MARC": 
            case "MARB": 
            case "MARL": {
                String husband = record.getIndi().getFirstName() + " " + record.getIndi().getLastName();
                String wife = record.getWife().getFirstName() + " " + record.getWife().getLastName() + " " + record.getEventDate().getDisplayValue();
                return MessageFormat.format("{0}: {1} x {2}", record.getEventTagName(), husband, wife);
            }
            case "WILL": {
                String message = record.getIndi().getFirstName() + " " + record.getIndi().getLastName() + " " + record.getEventDate().getDisplayValue();
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.miscWill", (Object)message);
            }
            case "CHR": {
                String message = record.getIndi().getFirstName() + " " + record.getIndi().getLastName() + " " + record.getEventDate().getDisplayValue();
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.miscChr", (Object)message);
            }
            case "BURI": {
                String message = record.getIndi().getFirstName() + " " + record.getIndi().getLastName() + " " + record.getEventDate().getDisplayValue();
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.miscBuri", (Object)message);
            }
            case "CREM": {
                String message = record.getIndi().getFirstName() + " " + record.getIndi().getLastName() + " " + record.getEventDate().getDisplayValue();
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.miscCrem", (Object)message);
            }
            case "NATU": {
                String message = record.getIndi().getFirstName() + " " + record.getIndi().getLastName() + " " + record.getEventDate().getDisplayValue();
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.miscNatu", (Object)message);
            }
        }
        String message1 = record.getIndi().getFirstName() + " " + record.getIndi().getLastName();
        String message2 = record.getWife().getFirstName() + " " + record.getWife().getLastName() + " " + record.getEventDate().getDisplayValue();
        return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.misc", (Object)record.getEventTagName(), (Object)message1, (Object)message2);
    }

    boolean isInsinuation() {
        return this.eventSecondDate != null && this.eventSecondDate.isComparable();
    }

    static boolean isEmpty(Delta delta) {
        return delta.getYears() == 0 && delta.getMonths() == 0 && delta.getDays() == 0;
    }

    public List<RecordWitness> getWitnesses() {
        ArrayList<RecordWitness> ret = new ArrayList<RecordWitness>();
        if (!this.witness1.getLastName().isBlank() || !this.witness1.getFirstName().isBlank()) {
            ret.add(this.witness1);
        }
        if (!this.witness2.getLastName().isBlank() || !this.witness2.getFirstName().isBlank()) {
            ret.add(this.witness2);
        }
        if (!this.witness3.getLastName().isBlank() || !this.witness3.getFirstName().isBlank()) {
            ret.add(this.witness3);
        }
        if (!this.witness4.getLastName().isBlank() || !this.witness4.getFirstName().isBlank()) {
            ret.add(this.witness4);
        }
        return ret;
    }

    private String makeBirthComment(boolean showFrenchCalendarDate) {
        String godMother;
        Object comment = NbBundle.getMessage(AbstractRecord.class, (String)"model.label.DeedDate") + ": " + this.getEventDateDDMMYYYY(showFrenchCalendarDate);
        comment = this.appendComment((String)comment, "model.label.Newborn", this.participant1.makeParticipantComment(showFrenchCalendarDate));
        comment = this.appendComment((String)comment, "model.row.Father", this.participant1.getFather().makeComment());
        comment = this.appendComment((String)comment, "model.row.Mother", this.participant1.getMother().makeComment());
        String godFather = MergeRecord.appendValue(this.witness1.getFirstName() + " " + this.witness1.getLastName(), this.witness1.getOccupation(), this.witness1.getComment());
        if (!godFather.isEmpty()) {
            if (!((String)comment).isEmpty() && ((String)comment).charAt(((String)comment).length() - 1) != '\n') {
                comment = (String)comment + "\n";
            }
            comment = (String)comment + NbBundle.getMessage(AbstractRecord.class, (String)"model.row.GodFather") + ": " + godFather;
        }
        if (!(godMother = MergeRecord.appendValue(this.witness2.getFirstName() + " " + this.witness2.getLastName(), this.witness2.getOccupation(), this.witness2.getComment())).isEmpty()) {
            if (!((String)comment).isEmpty() && ((String)comment).charAt(((String)comment).length() - 1) != '\n') {
                comment = (String)comment + "\n";
            }
            comment = (String)comment + NbBundle.getMessage(AbstractRecord.class, (String)"model.row.GodMother") + ": " + godMother;
        }
        String witness = MergeRecord.appendValue(this.witness3.getFirstName() + " " + this.witness3.getLastName(), this.witness3.getOccupation(), this.witness3.getComment(), this.witness4.getFirstName() + " " + this.witness4.getLastName(), this.witness4.getOccupation(), this.witness4.getComment());
        comment = this.appendComment((String)comment, "model.row.Witnesses", witness);
        comment = this.appendComment((String)comment, "model.column.Picture", this.makeEventPage());
        comment = this.appendComment((String)comment, "model.row.GeneralComment", this.generalComment);
        if (DataManager.getCopySourceTextToComment()) {
            comment = this.appendComment((String)comment, "model.label.DeedText", this.deedText);
        }
        return comment;
    }

    private String makeMarriageComment(boolean showFrenchCalendarDate) {
        Object comment = NbBundle.getMessage(AbstractRecord.class, (String)"model.label.DeedDate") + ": " + this.getEventDateDDMMYYYY(showFrenchCalendarDate);
        comment = this.appendComment((String)comment, "model.row.Husband", this.participant1.makeParticipantComment(showFrenchCalendarDate));
        comment = this.appendComment((String)comment, "model.row.ExWife", this.participant1.getMarriedFamily().getMarried().makeComment());
        comment = this.appendComment((String)comment, "model.row.IndiFather", this.participant1.getFather().makeComment());
        comment = this.appendComment((String)comment, "model.row.IndiMother", this.participant1.getMother().makeComment());
        comment = this.appendComment((String)comment, "model.row.Wife", this.participant2.makeParticipantComment(showFrenchCalendarDate));
        comment = this.appendComment((String)comment, "model.row.ExHusband", this.participant2.getMarriedFamily().getMarried().makeComment());
        comment = this.appendComment((String)comment, "model.row.WifeFather", this.participant2.getFather().makeComment());
        comment = this.appendComment((String)comment, "model.row.WifeMother", this.participant2.getMother().makeComment());
        comment = this.appendComment((String)comment, "model.row.Witnesses", this.makeWitnessComment());
        comment = this.appendComment((String)comment, "model.column.Picture", this.makeEventPage());
        comment = this.appendComment((String)comment, "model.row.GeneralComment", this.generalComment);
        if (DataManager.getCopySourceTextToComment()) {
            comment = this.appendComment((String)comment, "model.label.DeedText", this.deedText);
        }
        return comment;
    }

    private String makeDeathComment(boolean showFrenchCalendarDate) {
        Object comment = NbBundle.getMessage(AbstractRecord.class, (String)"model.label.DeedDate") + ": " + this.getEventDateDDMMYYYY(showFrenchCalendarDate);
        comment = this.appendComment((String)comment, "model.row.Deceased", this.participant1.makeParticipantComment(showFrenchCalendarDate));
        comment = this.appendComment((String)comment, "model.row.Married", this.participant1.getMarriedFamily().getMarried().makeComment());
        comment = this.appendComment((String)comment, "model.row.Father", this.participant1.getFather().makeComment());
        comment = this.appendComment((String)comment, "model.row.Mother", this.participant1.getMother().makeComment());
        comment = this.appendComment((String)comment, "model.row.Witnesses", this.makeWitnessComment());
        comment = this.appendComment((String)comment, "model.column.Picture", this.makeEventPage());
        comment = this.appendComment((String)comment, "model.row.GeneralComment", this.generalComment);
        if (DataManager.getCopySourceTextToComment()) {
            comment = this.appendComment((String)comment, "model.label.DeedText", this.deedText);
        }
        return comment;
    }

    private String makeMiscComment(boolean showFrenchCalendarDate) {
        String insinuationComment;
        Object comment = NbBundle.getMessage(AbstractRecord.class, (String)"model.label.DeedDate") + ": " + this.getEventDateDDMMYYYY(showFrenchCalendarDate);
        if (this.isInsinuation() && !(insinuationComment = MergeRecord.appendValue(NbBundle.getMessage(AbstractRecord.class, (String)"model.label.insinuation", (Object)this.getEventTagName(), (Object)this.getInsinuationDateDDMMYYYY(showFrenchCalendarDate)), this.notary.isEmpty() ? "" : NbBundle.getMessage(AbstractRecord.class, (String)"model.label.insunuationCapturedBy", (Object)this.notary))).isEmpty()) {
            if (!((String)comment).isEmpty() && ((String)comment).charAt(((String)comment).length() - 1) != '\n') {
                comment = (String)comment + "\n";
            }
            comment = (String)comment + insinuationComment;
        }
        String comment2 = "";
        comment2 = this.appendComment(comment2, "model.row.Participant2", this.participant2.makeParticipantComment(showFrenchCalendarDate));
        comment2 = this.appendComment(comment2, "model.row.Participant2Spouse", this.participant2.getMarriedFamily().getMarried().makeComment());
        comment2 = this.appendComment(comment2, "model.row.Participant2Father", this.participant2.getFather().makeComment());
        comment2 = this.appendComment(comment2, "model.row.Participant2Mother", this.participant2.getMother().makeComment());
        String prefix = "Participant1";
        if (comment2.isBlank()) {
            prefix = "Main";
        }
        comment = this.appendComment((String)comment, "model.row." + prefix, this.participant1.makeParticipantComment(showFrenchCalendarDate));
        comment = this.appendComment((String)comment, "model.row." + prefix + "Spouse", this.participant1.getMarriedFamily().getMarried().makeComment());
        comment = this.appendComment((String)comment, "model.row." + prefix + "Father", this.participant1.getFather().makeComment());
        comment = this.appendComment((String)comment, "model.row." + prefix + "Mother", this.participant1.getMother().makeComment());
        comment = (String)comment + comment2;
        comment = this.appendComment((String)comment, "model.row.Witnesses", this.makeWitnessComment());
        comment = this.appendComment((String)comment, "model.column.Picture", this.makeEventPage());
        comment = this.appendComment((String)comment, "model.row.GeneralComment", this.generalComment);
        if (DataManager.getCopySourceTextToComment()) {
            comment = this.appendComment((String)comment, "model.label.DeedText", this.deedText);
        }
        return comment;
    }

    private String makeWitnessComment() {
        String comment = MergeRecord.appendValue(this.witness1.getFirstName() + " " + this.witness1.getLastName(), this.witness1.getOccupation(), this.witness1.getComment(), this.witness2.getFirstName() + " " + this.witness2.getLastName(), this.witness2.getOccupation(), this.witness2.getComment(), this.witness3.getFirstName() + " " + this.witness3.getLastName(), this.witness3.getOccupation(), this.witness3.getComment(), this.witness4.getFirstName() + " " + this.witness4.getLastName(), this.witness4.getOccupation(), this.witness4.getComment());
        return comment;
    }

    protected String makeInsinuationReferenceComment(boolean showFrenchCalendarDate) {
        String comment = NbBundle.getMessage(AbstractRecord.class, (String)"model.label.insinuation", (Object)this.getEventTagName(), (Object)this.getInsinuationDateDDMMYYYY(showFrenchCalendarDate)) + " (" + this.getEventPlaceCityName() + ")" + (String)(this.getNotary().isEmpty() ? "" : " " + NbBundle.getMessage(AbstractRecord.class, (String)"model.label.insunuationCapturedBy", (Object)this.getNotary()));
        return comment;
    }

    protected String makeEventPage() {
        return MergeRecord.appendValue(this.eventCote, this.freeComment);
    }

    private String appendComment(String comment, String label, String newComment) {
        if (!newComment.isEmpty()) {
            Object localLabel;
            if (!((String)comment).isEmpty() && ((String)comment).charAt(((String)comment).length() - 1) != '\n') {
                comment = (String)comment + "\n";
            }
            if (!((String)(localLabel = NbBundle.getMessage(AbstractRecord.class, (String)label))).isBlank()) {
                localLabel = (String)localLabel + ": ";
            }
            comment = (String)comment + (String)localLabel + newComment;
        }
        return comment;
    }

    protected static String appendValue(String ... otherValues) {
        StringBuilder sb = new StringBuilder();
        for (String otherValue : otherValues) {
            if (otherValue.trim().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(otherValue.trim());
        }
        return sb.toString();
    }

    private static String appendPrefixValue(String prefix, String ... otherValues) {
        StringBuilder sb = new StringBuilder();
        for (String otherValue : otherValues) {
            if (otherValue == null || otherValue.trim().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(otherValue.trim());
        }
        if (sb.length() > 0) {
            sb.insert(0, prefix + " ");
        }
        return sb.toString();
    }

    private static PointInTime getYear(PointInTime pit) throws GedcomException {
        return pit;
    }

    private static PointInTime getYear(PointInTime pit, int shiftYear) throws GedcomException {
        if (shiftYear < 2 && shiftYear > -2) {
            return pit;
        }
        PointInTime gregorianPit = pit.getPointInTime((Calendar)PointInTime.GREGORIAN);
        return new PointInTime(Integer.MAX_VALUE, Integer.MAX_VALUE, gregorianPit.getYear() + shiftYear);
    }

    protected static PointInTime getYear(PointInTime refPit, Delta age) throws GedcomException {
        PointInTime gregorianPit = refPit.getPointInTime((Calendar)PointInTime.GREGORIAN);
        PointInTime pit = new PointInTime(gregorianPit.getDay(), gregorianPit.getMonth(), gregorianPit.getYear());
        pit.add(-age.getDays(), -age.getMonths(), -age.getYears());
        if (age.getMonths() == 0 && age.getDays() == 0) {
            pit.set(Integer.MAX_VALUE, Integer.MAX_VALUE, pit.getYear());
        } else if (age.getDays() == 0) {
            pit.set(Integer.MAX_VALUE, pit.getMonth(), pit.getYear());
        }
        return pit;
    }

    private PropertyDate calculateBirthDate(MergeParticipantType participantType, PropertyDate recordBirthDate, Delta age, PropertyDate marriedMarriageDate) {
        PropertyDate resultDate = new PropertyDate();
        resultDate.setValue(recordBirthDate.getValue());
        if (this.recordType == RecordType.BIRTH) {
            if (!recordBirthDate.isComparable()) {
                resultDate.setValue(this.getEventDate().getValue());
            }
        } else if (this.recordType == RecordType.MARRIAGE || this.recordType == RecordType.MISC && (this.eventTypeTag.equals("MARB") || this.eventTypeTag.equals("MARC") || this.eventTypeTag.equals("MARL"))) {
            if (!recordBirthDate.isComparable() && this.eventDate.isComparable()) {
                if (age.getYears() != 0 || age.getMonths() != 0 || age.getDays() != 0) {
                    if (age.getYears() != 0 && age.getMonths() != 0 && age.getDays() != 0) {
                        PointInTime start = null;
                        if (this.eventDate.getStart() != null) {
                            start = new PointInTime();
                            start.set(this.eventDate.getStart());
                            start.add(-age.getDays(), -age.getMonths(), -age.getYears());
                        }
                        PointInTime end = null;
                        if (this.eventDate.getEnd() != null) {
                            end = new PointInTime();
                            end.set(this.eventDate.getEnd());
                            end.add(-age.getDays(), -age.getMonths(), -age.getYears());
                        }
                        resultDate.setValue(this.eventDate.getFormat(), start, end, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdate"));
                    } else {
                        try {
                            resultDate.setValue(PropertyDate.CALCULATED, MergeRecord.getYear(this.getEventDate().getStart(), age), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdate"));
                        }
                        catch (GedcomException ex) {
                            resultDate = new PropertyDate();
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                } else {
                    resultDate = MergeRecord.calulateDateBeforeMinusShift(this.getEventDate(), MergeQuery.minMarriageYearOld, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdatemarrminus", (Object)MergeQuery.minMarriageYearOld));
                }
            }
        } else if (this.recordType == RecordType.DEATH) {
            if (!recordBirthDate.isComparable() && this.eventDate.isComparable()) {
                if (age.getYears() != 0 || age.getMonths() != 0 || age.getDays() != 0) {
                    if (age.getYears() != 0 && age.getMonths() != 0 && age.getDays() != 0) {
                        PointInTime start = null;
                        if (this.eventDate.getStart() != null) {
                            start = new PointInTime();
                            start.set(this.eventDate.getStart());
                            start.add(-age.getDays(), -age.getMonths(), -age.getYears());
                        }
                        PointInTime end = null;
                        if (this.eventDate.getEnd() != null) {
                            end = new PointInTime();
                            end.set(this.eventDate.getEnd());
                            end.add(-age.getDays(), -age.getMonths(), -age.getYears());
                        }
                        resultDate.setValue(this.eventDate.getFormat(), start, end, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdate"));
                    } else {
                        try {
                            resultDate.setValue(PropertyDate.CALCULATED, MergeRecord.getYear(this.getEventDate().getStart(), age), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdate"));
                        }
                        catch (GedcomException ex) {
                            resultDate = new PropertyDate();
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                } else if (marriedMarriageDate != null && marriedMarriageDate.isComparable()) {
                    try {
                        resultDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(marriedMarriageDate.getStart(), -MergeQuery.minMarriageYearOld), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdate", (Object)MergeQuery.minMarriageYearOld));
                    }
                    catch (GedcomException ex) {
                        resultDate = new PropertyDate();
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    try {
                        resultDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(this.getEventDate().getStart()), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdatebef"));
                    }
                    catch (GedcomException ex) {
                        resultDate = new PropertyDate();
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        } else if (!recordBirthDate.isComparable() && this.eventDate.isComparable()) {
            if (age.getYears() != 0) {
                if (age.getYears() != 0 && age.getMonths() != 0 && age.getDays() != 0) {
                    PointInTime start = null;
                    if (this.eventDate.getStart() != null) {
                        start = new PointInTime();
                        start.set(this.eventDate.getStart());
                        start.add(-age.getDays(), -age.getMonths(), -age.getYears());
                    }
                    PointInTime end = null;
                    if (this.eventDate.getEnd() != null) {
                        end = new PointInTime();
                        end.set(this.eventDate.getEnd());
                        end.add(-age.getDays(), -age.getMonths(), -age.getYears());
                    }
                    resultDate.setValue(this.eventDate.getFormat(), start, end, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdate"));
                } else {
                    try {
                        resultDate.setValue(PropertyDate.CALCULATED, MergeRecord.getYear(this.eventDate.getStart(), age), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdate"));
                    }
                    catch (GedcomException ex) {
                        resultDate = new PropertyDate();
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            } else if (marriedMarriageDate != null && marriedMarriageDate.isComparable()) {
                try {
                    resultDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(marriedMarriageDate.getStart(), -MergeQuery.minMarriageYearOld), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdatespouseminus", (Object)MergeQuery.minMarriageYearOld));
                }
                catch (GedcomException ex) {
                    resultDate = new PropertyDate();
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else if (this.eventTypeTag.equals("WILL") && participantType == MergeParticipantType.participant1 || this.eventTypeTag.equals("MARB") || this.eventTypeTag.equals("MARC") || this.eventTypeTag.equals("MARL")) {
                try {
                    resultDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(this.getEventDate().getStart(), -MergeQuery.minMajorityYearOld), null, NbBundle.getMessage(AbstractRecord.class, (String)"birthdatebefadult", (Object)MergeQuery.minMajorityYearOld));
                }
                catch (GedcomException ex) {
                    resultDate = new PropertyDate();
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                try {
                    resultDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(this.getEventDate().getStart()), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdatebef"));
                }
                catch (GedcomException ex) {
                    resultDate = new PropertyDate();
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return resultDate;
    }

    private PropertyDate calculateDeathDate(MergeParticipantType participantType) throws Exception {
        PropertyDate resultDate = new PropertyDate();
        if (this.recordType == RecordType.DEATH) {
            if (participantType == MergeParticipantType.participant1 && this.participant1.m_DeathDate.isComparable()) {
                resultDate.setValue(this.participant1.m_DeathDate.getValue());
            } else {
                resultDate.setValue(this.getEventDate().getValue());
            }
        } else {
            resultDate.setValue(PropertyDate.FROM, MergeRecord.getYear(this.getEventDate().getStart()), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.deathdateevent"));
        }
        return resultDate;
    }

    protected PropertyDate calculateMariageDateFromMarc(PropertyDate marcDate) {
        PropertyDate marriageDate = new PropertyDate();
        if (marcDate.getFormat() == PropertyDate.DATE) {
            try {
                marriageDate.setValue(PropertyDate.ABOUT, MergeRecord.getYear(marcDate.getStart(), 0), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.marrdatecontract"));
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
        }
        return marriageDate;
    }

    private static PropertyDate calulateDateBeforeMinusShift(PropertyDate birthDate, int yearShift, String phrase) {
        try {
            PropertyDate marriageDate = new PropertyDate();
            if (birthDate.getFormat() == PropertyDate.BETWEEN_AND || birthDate.getFormat() == PropertyDate.FROM_TO) {
                marriageDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(birthDate.getEnd(), -yearShift), null, phrase);
            } else if (birthDate.getFormat() == PropertyDate.FROM || birthDate.getFormat() == PropertyDate.AFTER) {
                marriageDate.setValue("");
            } else if (birthDate.getFormat() == PropertyDate.TO || birthDate.getFormat() == PropertyDate.BEFORE) {
                marriageDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(birthDate.getStart(), -yearShift), null, phrase);
            } else if (birthDate.getFormat() == PropertyDate.ABOUT || birthDate.getFormat() == PropertyDate.ESTIMATED) {
                marriageDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(birthDate.getStart(), -yearShift), null, phrase);
            } else {
                marriageDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(birthDate.getStart(), -yearShift), null, phrase);
            }
            return marriageDate;
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new PropertyDate();
        }
    }

    static String cleanPlace(String place) {
        if (place.isBlank()) {
            return "";
        }
        String ret = place.replaceAll("\\?", "").replaceAll(",+", ",").replaceAll("^,", "");
        return ret;
    }

    protected static class RecordWitness
    extends RecordIndi {
        private String m_firstName;
        private String m_lastName;
        private String m_occupation;
        private String m_comment;

        protected RecordWitness() {
        }

        @Override
        String getFirstName() {
            return this.m_firstName;
        }

        @Override
        String getLastName() {
            return this.m_lastName;
        }

        @Override
        String getOccupation() {
            return this.m_occupation;
        }

        String getComment() {
            return this.m_comment;
        }

        String getDisplayValue() {
            return this.m_lastName + " " + this.m_firstName;
        }

        @Override
        PropertyDate getBirthDate() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        PropertyDate getDeathDate() throws Exception {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        String getOccupationWithDate() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        int getSex() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        RecordResidence getBirthResidence() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        RecordResidence getDeathResidence() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        RecordResidence getResidence() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected static enum RecordType {
        BIRTH,
        MARRIAGE,
        DEATH,
        MISC;

    }

    protected static class RecordParticipant
    extends RecordIndi {
        private final MergeParticipantType m_participantType;
        private final MergeRecord m_mergeRecord;
        private String m_FirstName;
        private String m_LastName;
        private SexType m_Sex;
        private Delta m_Age = new Delta(0, 0, 0);
        private PropertyDate m_BirthDate;
        private PropertyDate m_DeathDate;
        private RecordResidence m_BirthResidence = new RecordResidence();
        private RecordResidence m_DeathResidence = new RecordResidence();
        private String m_Occupation;
        private final RecordResidence m_Residence = new RecordResidence();
        private String m_Comment;
        private RecordMarriedFamily m_marriedFamily;
        private final RecordParentFamily m_parentFamily;
        private PropertyDate computedBirthDate = null;
        private PropertyDate computedDeathDate = null;

        RecordParticipant(MergeRecord mergeRecord, MergeParticipantType participantType) {
            this.m_participantType = participantType;
            this.m_mergeRecord = mergeRecord;
            this.m_parentFamily = new RecordParentFamily(new RecordParent(), new RecordParent(), this);
            this.m_marriedFamily = new RecordMarriedFamily(this);
        }

        MergeRecord getMergeRecord() {
            return this.m_mergeRecord;
        }

        MergeParticipantType getParticipantType() {
            return this.m_participantType;
        }

        @Override
        String getFirstName() {
            return this.m_FirstName;
        }

        @Override
        String getLastName() {
            return this.m_LastName;
        }

        @Override
        int getSex() {
            return this.m_Sex.getSex();
        }

        @Override
        PropertyDate getBirthDate() {
            if (this.computedBirthDate == null) {
                this.computedBirthDate = this.m_mergeRecord.calculateBirthDate(this.m_participantType, this.m_BirthDate != null ? this.m_BirthDate : new PropertyDate(), this.m_Age != null ? this.m_Age : new Delta(0, 0, 0), this.getMarriedFamily().getMarriageDate());
            }
            return this.computedBirthDate;
        }

        @Override
        PropertyDate getDeathDate() throws Exception {
            if (this.computedDeathDate == null) {
                this.computedDeathDate = this.m_mergeRecord.calculateDeathDate(this.m_participantType);
            }
            return this.computedDeathDate;
        }

        Delta getAge() {
            return this.m_Age;
        }

        @Override
        RecordResidence getBirthResidence() {
            if (this.m_BirthResidence.m_place.isEmpty()) {
                this.m_BirthResidence.m_place = this.m_mergeRecord.recordType == RecordType.BIRTH && this.m_participantType == MergeParticipantType.participant1 ? (this.m_Residence.m_place != null && !this.m_Residence.m_place.isEmpty() ? this.m_Residence.m_place : (!this.m_parentFamily.m_father.getResidence().getPlace().isEmpty() ? this.m_parentFamily.m_father.getResidence().m_place : this.m_mergeRecord.getEventResidence().m_place)) : "";
            }
            if (this.m_BirthResidence.m_address.isEmpty()) {
                this.m_BirthResidence.m_address = this.m_mergeRecord.recordType == RecordType.BIRTH && this.m_participantType == MergeParticipantType.participant1 ? (this.m_Residence.m_address != null && !this.m_Residence.m_address.isEmpty() ? this.m_Residence.m_address : (!this.m_parentFamily.m_father.getResidence().m_address.isEmpty() ? this.m_parentFamily.m_father.getResidence().m_address : this.m_mergeRecord.getEventResidence().m_address)) : "";
            }
            return this.m_BirthResidence;
        }

        @Override
        RecordResidence getDeathResidence() {
            return this.m_DeathResidence;
        }

        @Override
        String getOccupation() {
            if (this.m_Occupation != null) {
                return this.m_Occupation;
            }
            return null;
        }

        @Override
        String getOccupationWithDate() {
            Object occupation = MergeRecord.appendValue(this.m_Occupation, this.m_Residence.m_place, this.m_Residence.m_address);
            if (!((String)occupation).isEmpty()) {
                occupation = (String)occupation + " (" + this.m_mergeRecord.getEventDate().getDisplayValue() + ")";
            }
            return occupation;
        }

        @Override
        RecordResidence getResidence() {
            return this.m_Residence;
        }

        String getPlace() {
            return this.m_Residence.m_place;
        }

        String getAddress() {
            return this.m_Residence.m_address;
        }

        RecordMarriedFamily getMarriedFamily() {
            return this.m_marriedFamily;
        }

        RecordParentFamily getParentFamily() {
            return this.m_parentFamily;
        }

        RecordParent getFather() {
            return this.m_parentFamily.m_father;
        }

        RecordParent getMother() {
            return this.m_parentFamily.m_mother;
        }

        private String makeParticipantBirthComment(boolean showFrenchCalendarDate) {
            Object comment = "";
            PropertyDate birthDate = this.m_BirthDate;
            if (birthDate != null && birthDate.isValid()) {
                comment = "n\u00e9 le " + MergeRecord.formatDateDDMMYYYY(birthDate);
                if (showFrenchCalendarDate) {
                    try {
                        String frenchCalendarDate = birthDate.getStart().getPointInTime((Calendar)PointInTime.FRENCHR).toString();
                        if (!frenchCalendarDate.isEmpty()) {
                            comment = (String)comment + " (" + frenchCalendarDate + ")";
                        }
                    }
                    catch (GedcomException gedcomException) {
                        // empty catch block
                    }
                }
            }
            comment = (String)comment + MergeRecord.appendPrefixValue(((String)comment).isEmpty() ? "n\u00e9 \u00e0" : " \u00e0", MergeRecord.cleanPlace(this.m_BirthResidence.m_address), MergeRecord.cleanPlace(this.m_BirthResidence.m_place));
            return comment;
        }

        private String makeParticipantDeathComment(boolean showFrenchCalendarDate) {
            Object comment = "";
            PropertyDate deathDate = this.m_DeathDate;
            if (deathDate != null && deathDate.isValid()) {
                comment = NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.diedOn", (Object)MergeRecord.formatDateDDMMYYYY(deathDate));
                if (showFrenchCalendarDate) {
                    try {
                        String frenchCalendarDate = deathDate.getStart().getPointInTime((Calendar)PointInTime.FRENCHR).toString();
                        if (!frenchCalendarDate.isEmpty()) {
                            comment = (String)comment + " (" + frenchCalendarDate + ")";
                        }
                    }
                    catch (GedcomException gedcomException) {
                        // empty catch block
                    }
                }
            }
            comment = (String)comment + MergeRecord.appendPrefixValue((String)(((String)comment).isEmpty() ? NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.diedAt") : " " + NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.at")), MergeRecord.cleanPlace(this.m_DeathResidence.m_address), MergeRecord.cleanPlace(this.m_DeathResidence.m_place));
            return comment;
        }

        private String makeParticipantComment(boolean showFrenchCalendarDate) {
            String comment = MergeRecord.appendValue(this.m_FirstName + " " + this.m_LastName, this.m_Age == null || MergeRecord.isEmpty(this.m_Age) ? "" : this.m_Age.toString(), this.makeParticipantBirthComment(showFrenchCalendarDate), this.m_Occupation, this.m_Residence.makeComment(), this.makeParticipantDeathComment(showFrenchCalendarDate), this.m_Comment);
            return comment;
        }
    }

    public static enum MergeParticipantType {
        participant1,
        participant2;

    }

    protected static class SexType {
        int sex = 0;

        public static SexType fromString(String value) {
            return new SexType(value);
        }

        public SexType(String value) {
            if ("M".equals(value)) {
                this.sex = 1;
            } else if ("F".equals(value)) {
                this.sex = 2;
            }
        }

        public int getSex() {
            return this.sex;
        }

        public static String getLabelForSex(int value) {
            switch (value) {
                case 1: 
                case 2: {
                    return PropertySex.getLabelForSex((int)value);
                }
            }
            return "";
        }
    }

    protected static class RecordResidence {
        private String m_place;
        private String m_address;

        RecordResidence() {
            this.m_place = "";
            this.m_address = "";
        }

        RecordResidence(String place, String address) {
            this.m_place = place;
            this.m_address = address;
        }

        String getPlace() {
            return this.m_place;
        }

        String getAddress() {
            return this.m_address;
        }

        private String makeComment() {
            String comment = MergeRecord.appendPrefixValue(NbBundle.getMessage(AbstractRecord.class, (String)"model.label.Residence"), MergeRecord.cleanPlace(this.m_address), MergeRecord.cleanPlace(this.m_place));
            return comment;
        }

        boolean isEmpty() {
            return this.m_address.isEmpty() && this.m_place.isEmpty();
        }

        public String toString() {
            return this.makeComment();
        }
    }

    protected static class RecordMarriedFamily
    extends RecordFamily {
        RecordParticipant m_indi;
        RecordMarried m_married;
        SpouseTag spousTag;
        private PropertyDate MarriedMarriageDate = null;

        RecordMarriedFamily(RecordParticipant indi) {
            this.m_indi = indi;
            this.m_married = new RecordMarried();
            this.spousTag = this.m_indi.m_participantType == MergeParticipantType.participant1 ? SpouseTag.HUSB : SpouseTag.WIFE;
            this.init();
        }

        RecordMarriedFamily(RecordParticipant husband, RecordMarried wife) {
            this.m_indi = husband;
            this.m_married = wife;
            this.spousTag = SpouseTag.HUSB;
            this.init();
        }

        RecordMarriedFamily(RecordMarried husband, RecordParticipant wife) {
            this.m_indi = wife;
            this.m_married = husband;
            this.spousTag = SpouseTag.WIFE;
            this.init();
        }

        private void init() {
            this.m_indi.m_marriedFamily = this;
            this.m_married.m_marriedFamily = this;
        }

        @Override
        RecordIndi getHusband() {
            return this.spousTag == SpouseTag.HUSB ? this.m_indi : this.m_married;
        }

        @Override
        RecordIndi getWife() {
            return this.spousTag == SpouseTag.WIFE ? this.m_indi : this.m_married;
        }

        RecordMarried getMarried() {
            return this.m_married;
        }

        @Override
        PropertyDate getMarriageDate() {
            if (this.MarriedMarriageDate == null) {
                this.MarriedMarriageDate = new PropertyDate();
                if (!(this.m_married.m_firstName == null || this.m_married.m_lastName == null || this.m_married.m_firstName.isEmpty() && this.m_married.m_lastName.isEmpty() || !this.m_indi.getMergeRecord().getEventDate().isComparable())) {
                    try {
                        this.MarriedMarriageDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(this.m_indi.getMergeRecord().getEventDate().getStart()), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.marrdaterecord"));
                    }
                    catch (GedcomException ex) {
                        this.MarriedMarriageDate = new PropertyDate();
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if (this.m_indi.m_participantType != MergeParticipantType.participant1 || this.m_indi.getMergeRecord().getRecordType() == RecordType.DEATH) {
                    // empty if block
                }
            }
            return this.MarriedMarriageDate;
        }
    }

    protected static class RecordMarried
    extends RecordIndi {
        private String m_firstName;
        private String m_lastName;
        private SexType m_sex;
        private String m_occupation;
        private RecordResidence m_residence = new RecordResidence();
        private DeadState m_dead;
        private String m_comment;
        private PropertyDate computedBirthDate = null;
        private PropertyDate computedDeathDate = null;
        RecordMarriedFamily m_marriedFamily;

        RecordMarried() {
        }

        @Override
        String getFirstName() {
            return this.m_firstName;
        }

        @Override
        String getLastName() {
            return this.m_lastName;
        }

        @Override
        int getSex() {
            return this.m_sex.getSex();
        }

        @Override
        String getOccupation() {
            return this.m_occupation;
        }

        @Override
        RecordResidence getBirthResidence() {
            return new RecordResidence();
        }

        @Override
        RecordResidence getResidence() {
            return this.m_residence;
        }

        @Override
        RecordResidence getDeathResidence() {
            return new RecordResidence();
        }

        String makeComment() {
            String comment = MergeRecord.appendValue(this.m_firstName + " " + this.m_lastName, this.m_dead.toString(), this.m_occupation, this.m_residence.makeComment(), this.m_comment);
            return comment;
        }

        @Override
        PropertyDate getBirthDate() {
            if (this.computedBirthDate == null) {
                this.computedBirthDate = new PropertyDate();
                if (!(this.m_firstName == null || this.m_lastName == null || this.m_firstName.isEmpty() && this.m_lastName.isEmpty() || !this.m_marriedFamily.getMarriageDate().isComparable())) {
                    try {
                        this.computedBirthDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(this.m_marriedFamily.getMarriageDate().getStart(), -MergeQuery.minMarriageYearOld), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdatemarrbef", (Object)MergeQuery.minMarriageYearOld));
                    }
                    catch (GedcomException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return this.computedBirthDate;
        }

        @Override
        String getOccupationWithDate() {
            Object occupation = MergeRecord.appendValue(this.m_occupation, this.m_residence.m_address, this.m_residence.m_place);
            if (!((String)occupation).isEmpty()) {
                occupation = (String)occupation + " (" + this.m_marriedFamily.m_indi.getMergeRecord().getEventDate().getDisplayValue() + ")";
            }
            return occupation;
        }

        @Override
        PropertyDate getDeathDate() throws Exception {
            if (this.computedDeathDate == null) {
                this.computedDeathDate = new PropertyDate();
                switch (this.m_dead) {
                    case DEAD: {
                        this.computedDeathDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(this.m_marriedFamily.m_indi.getMergeRecord().getEventDate().getStart()), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.deathdaterecordbef"));
                        break;
                    }
                    case ALIVE: {
                        this.computedDeathDate.setValue(PropertyDate.AFTER, MergeRecord.getYear(this.m_marriedFamily.m_indi.getMergeRecord().getEventDate().getStart()), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.deathdaterecordaft"));
                        break;
                    }
                }
            }
            return this.computedDeathDate;
        }
    }

    protected static enum DeadState {
        UNKNOWN,
        DEAD,
        ALIVE;

        public static String deadLabel;
        public static String aliveLabel;
        public static String unknownLabel;

        public static DeadState fromString(String value) {
            DeadState death = UNKNOWN;
            if (DEAD.name().equals(value)) {
                death = DEAD;
            } else if (value.equals(ALIVE.name())) {
                death = ALIVE;
            }
            return death;
        }

        public String toString() {
            switch (this) {
                case DEAD: {
                    return deadLabel;
                }
                case ALIVE: {
                    return aliveLabel;
                }
            }
            return "";
        }

        static {
            deadLabel = ResourceBundle.getBundle("ancestris/modules/releve/merge/Bundle").getString("MergeRecord.DeadState.Dead");
            aliveLabel = ResourceBundle.getBundle("ancestris/modules/releve/merge/Bundle").getString("MergeRecord.DeadState.Alive");
            unknownLabel = ResourceBundle.getBundle("ancestris/modules/releve/merge/Bundle").getString("MergeRecord.DeadState.Unknown");
        }
    }

    protected static class RecordParent
    extends RecordIndi {
        private String m_firstName;
        private String m_lastName;
        private SexType m_sex;
        private String m_occupation;
        private final RecordResidence m_residence = new RecordResidence();
        private Delta m_age = new Delta(0, 0, 0);
        private DeadState m_dead;
        private String m_comment;
        private PropertyDate computedBirthDate = null;
        private PropertyDate computedDeathDate = null;
        RecordParentFamily m_family;

        RecordParent() {
        }

        @Override
        String getFirstName() {
            return this.m_firstName;
        }

        @Override
        String getLastName() {
            return this.m_lastName;
        }

        @Override
        int getSex() {
            return this.m_sex.getSex();
        }

        @Override
        String getOccupation() {
            return this.m_occupation;
        }

        @Override
        RecordResidence getBirthResidence() {
            return new RecordResidence();
        }

        @Override
        RecordResidence getResidence() {
            return this.m_residence;
        }

        @Override
        RecordResidence getDeathResidence() {
            return new RecordResidence();
        }

        @Override
        PropertyDate getBirthDate() {
            if (this.computedBirthDate == null) {
                try {
                    this.computedBirthDate = this.calculateParentBirthDate(this.m_age, this.m_family.m_child.getBirthDate(), this.m_family.m_child.getMergeRecord().getEventDate());
                }
                catch (Exception ex) {
                    this.computedBirthDate = new PropertyDate();
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.computedBirthDate;
        }

        @Override
        PropertyDate getDeathDate() throws Exception {
            if (this.computedDeathDate == null) {
                this.computedDeathDate = this.calculateParentDeathDate(this.m_dead != null ? this.m_dead : DeadState.UNKNOWN, this.m_family.m_child.getBirthDate(), this.m_sex.getSex() == 2 ? 0 : 9, this.m_family.m_child.getMergeRecord().getEventDate());
            }
            return this.computedDeathDate;
        }

        @Override
        String getOccupationWithDate() {
            Object occupation = MergeRecord.appendValue(this.m_occupation, this.m_residence.m_address, this.m_residence.m_place);
            if (!((String)occupation).isEmpty()) {
                occupation = (String)occupation + " (" + this.m_family.m_child.getMergeRecord().getEventDate().getDisplayValue() + ")";
            }
            return occupation;
        }

        String makeComment() {
            String comment = MergeRecord.appendValue(this.m_firstName + " " + this.m_lastName, this.m_age == null || MergeRecord.isEmpty(this.m_age) ? "" : this.m_age.toString(), this.m_dead.toString(), this.m_occupation, this.m_residence.makeComment(), this.m_comment);
            return comment;
        }

        private PropertyDate calculateParentBirthDate(Delta parentAge, PropertyDate childBirthDate, PropertyDate eventDate) throws Exception {
            PropertyDate parentBirthDate = new PropertyDate();
            if (parentAge != null && parentAge.getYears() != 0 && eventDate.isComparable()) {
                if (parentAge.getYears() != 0 && parentAge.getMonths() != 0 && parentAge.getDays() != 0) {
                    PointInTime start = null;
                    if (eventDate.getStart() != null) {
                        start = new PointInTime();
                        start.set(eventDate.getStart());
                        start.add(-parentAge.getDays(), -parentAge.getMonths(), -parentAge.getYears());
                    }
                    PointInTime end = null;
                    if (eventDate.getEnd() != null) {
                        end = new PointInTime();
                        end.set(eventDate.getEnd());
                        end.add(-parentAge.getDays(), -parentAge.getMonths(), -parentAge.getYears());
                    }
                    parentBirthDate.setValue(eventDate.getFormat(), start, end, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdate"));
                } else {
                    parentBirthDate.setValue(PropertyDate.CALCULATED, MergeRecord.getYear(eventDate.getStart(), parentAge), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdate"));
                }
            } else if (childBirthDate.isComparable()) {
                parentBirthDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(childBirthDate.getStart(), -MergeQuery.minParentYearOld), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.birthdatechildminus", (Object)MergeQuery.minParentYearOld));
            } else {
                parentBirthDate = new PropertyDate();
            }
            return parentBirthDate;
        }

        private PropertyDate calculateParentDeathDate(DeadState dead, PropertyDate childBirthDate, int monthBeforeBirth, PropertyDate eventDate) throws Exception {
            PropertyDate parentDeathDate = new PropertyDate();
            if (eventDate.isComparable()) {
                boolean birthDateUsefull;
                PointInTime childBirthPit = new PointInTime();
                if (childBirthDate.isValid()) {
                    if (childBirthDate.getFormat() == PropertyDate.DATE || childBirthDate.getFormat() == PropertyDate.AFTER || childBirthDate.getFormat() == PropertyDate.BETWEEN_AND || childBirthDate.getFormat() == PropertyDate.CALCULATED) {
                        birthDateUsefull = true;
                        childBirthPit.set(childBirthDate.getStart());
                        childBirthPit.add(0, -monthBeforeBirth, 0);
                    } else {
                        birthDateUsefull = false;
                    }
                } else {
                    birthDateUsefull = false;
                }
                if (dead == DeadState.DEAD) {
                    if (birthDateUsefull) {
                        if (monthBeforeBirth == 0) {
                            parentDeathDate.setValue(PropertyDate.BETWEEN_AND, MergeRecord.getYear(childBirthPit), MergeRecord.getYear(eventDate.getStart()), NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.deathdatechildbetween"));
                        } else {
                            parentDeathDate.setValue(PropertyDate.BETWEEN_AND, MergeRecord.getYear(childBirthPit), MergeRecord.getYear(eventDate.getStart()), NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.deathdateseedbetween"));
                        }
                    } else {
                        parentDeathDate.setValue(PropertyDate.BEFORE, MergeRecord.getYear(eventDate.getStart()), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.deathdaterecordbef"));
                    }
                } else if (dead == DeadState.ALIVE) {
                    parentDeathDate.setValue(PropertyDate.AFTER, MergeRecord.getYear(eventDate.getStart()), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.deathdaterecordaft"));
                } else if (birthDateUsefull) {
                    parentDeathDate.setValue(String.format("AFT %d", childBirthPit.getYear()));
                    if (monthBeforeBirth == 0) {
                        parentDeathDate.setValue(PropertyDate.AFTER, MergeRecord.getYear(childBirthPit), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.deathdatechildaft"));
                    } else {
                        parentDeathDate.setValue(PropertyDate.AFTER, MergeRecord.getYear(childBirthPit), null, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.deathdateseedaft"));
                    }
                }
            }
            return parentDeathDate;
        }
    }

    protected static class RecordMarriageFamily
    extends RecordFamily {
        RecordParticipant m_husband;
        RecordParticipant m_wife;

        RecordMarriageFamily(RecordParticipant husband, RecordParticipant wife) {
            this.m_husband = husband;
            this.m_wife = wife;
        }

        @Override
        RecordIndi getHusband() {
            return this.m_husband;
        }

        @Override
        RecordIndi getWife() {
            return this.m_wife;
        }

        @Override
        PropertyDate getMarriageDate() {
            if (this.m_husband.getMergeRecord().getRecordType() == RecordType.MARRIAGE) {
                return this.m_husband.getMergeRecord().getEventDate();
            }
            return new PropertyDate();
        }
    }

    protected static class RecordParentFamily
    extends RecordFamily {
        RecordParticipant m_child;
        RecordParent m_father;
        RecordParent m_mother;
        private PropertyDate computedParentMarriageDate = null;

        RecordParentFamily(RecordParent father, RecordParent mother, RecordParticipant child) {
            this.m_child = child;
            this.m_father = father;
            this.m_mother = mother;
            this.init();
        }

        private void init() {
            this.m_father.m_family = this;
            this.m_mother.m_family = this;
        }

        @Override
        RecordParent getHusband() {
            return this.m_father;
        }

        @Override
        RecordParent getWife() {
            return this.m_mother;
        }

        @Override
        PropertyDate getMarriageDate() {
            if (this.computedParentMarriageDate == null) {
                this.computedParentMarriageDate = this.calculateParentMariageDate(this.m_child.getBirthDate(), this.m_child.getMergeRecord().getEventDate(), this.m_child.getMergeRecord().getRecordType());
            }
            return this.computedParentMarriageDate;
        }

        private PropertyDate calculateParentMariageDate(PropertyDate childBirthDate, PropertyDate eventDate, RecordType recordType) {
            PropertyDate parentMariageDate;
            if (recordType == RecordType.MARRIAGE) {
                PropertyDate beforeChildBirth = MergeRecord.calulateDateBeforeMinusShift(childBirthDate, 0, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.marrdatespousebef"));
                PropertyDate beforeChildMarriage = MergeRecord.calulateDateBeforeMinusShift(eventDate, MergeQuery.minMarriageYearOld, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.marrdatecontractminus", (Object)MergeQuery.minMarriageYearOld));
                boolean beforeChildBirthComparable = beforeChildBirth.isComparable();
                boolean beforeChildMarriageComparable = beforeChildMarriage.isComparable();
                parentMariageDate = beforeChildBirthComparable && beforeChildMarriageComparable ? (MergeQuery.getMostAccurateDate(beforeChildBirth, beforeChildMarriage) == beforeChildBirth ? beforeChildBirth : beforeChildMarriage) : (beforeChildBirthComparable ? beforeChildBirth : beforeChildMarriage);
            } else {
                parentMariageDate = MergeRecord.calulateDateBeforeMinusShift(childBirthDate, 0, NbBundle.getMessage(AbstractRecord.class, (String)"model.explain.marrdatechildbef"));
            }
            return parentMariageDate;
        }
    }

    protected static abstract class RecordFamily
    extends RecordEntity {
        protected RecordFamily() {
        }

        abstract RecordIndi getHusband();

        abstract RecordIndi getWife();

        abstract PropertyDate getMarriageDate();
    }

    protected static abstract class RecordIndi
    extends RecordEntity {
        protected RecordIndi() {
        }

        abstract String getLastName();

        abstract String getFirstName();

        abstract PropertyDate getBirthDate();

        abstract PropertyDate getDeathDate() throws Exception;

        abstract String getOccupationWithDate();

        abstract int getSex();

        abstract RecordResidence getBirthResidence();

        abstract RecordResidence getDeathResidence();

        abstract RecordResidence getResidence();

        abstract String getOccupation();

        public String toString() {
            return this.getFirstName() + " " + this.getLastName();
        }
    }

    protected static abstract class RecordEntity {
        protected RecordEntity() {
        }
    }
}

